/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.DefaultClientHeadersFactoryImpl;
import org.jboss.resteasy.microprofile.client.CdiConstructorInjector;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderProvider;
import org.jboss.resteasy.microprofile.client.header.HeaderFillerFactory;

public class ClientHeaderProviders {
    private static final ClientHeadersFactory defaultHeadersFactory;
    private static final Map<Method, ClientHeaderProvider> providersForMethod;
    private static final Map<Class<?>, ClientHeadersFactory> headerFactoriesForClass;
    private static final HeaderFillerFactory fillerFactory;

    public static Optional<ClientHeaderProvider> getProvider(Method method) {
        return Optional.ofNullable(providersForMethod.get(method));
    }

    public static Optional<ClientHeadersFactory> getFactory(Class<?> aClass) {
        return Optional.ofNullable(headerFactoriesForClass.get(aClass));
    }

    @Deprecated
    public static void registerForClass(Class<?> clientClass, Object clientProxy) {
        ClientHeaderProviders.registerForClass(clientClass, clientProxy, null);
    }

    public static void registerForClass(Class<?> clientClass, Object clientProxy, BeanManager beanManager) {
        Stream.of(clientClass.getMethods()).forEach(m -> ClientHeaderProviders.registerForMethod(m, clientProxy));
        ClientHeaderProviders.registerHeaderFactory(clientClass, beanManager);
    }

    private static void registerHeaderFactory(Class<?> aClass, BeanManager beanManager) {
        RegisterClientHeaders annotation = aClass.getAnnotation(RegisterClientHeaders.class);
        if (annotation != null) {
            Optional<ClientHeadersFactory> clientHeadersFactory = ClientHeaderProviders.getCustomHeadersFactory(annotation, aClass, beanManager);
            headerFactoriesForClass.put(aClass, clientHeadersFactory.orElse(defaultHeadersFactory));
        }
    }

    private static Optional<ClientHeadersFactory> getCustomHeadersFactory(RegisterClientHeaders annotation, Class<?> source, BeanManager beanManager) {
        Class factoryClass = annotation.value();
        try {
            return Optional.of(ClientHeaderProviders.construct(factoryClass, beanManager));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RestClientDefinitionException("Failed to instantiate " + factoryClass.getCanonicalName() + ", the client header factory for " + source.getCanonicalName(), (Throwable)e);
        }
    }

    private static void registerForMethod(Method method, Object clientProxy) {
        ClientHeaderProvider.forMethod(method, clientProxy, fillerFactory).ifPresent(provider -> providersForMethod.put(method, (ClientHeaderProvider)provider));
    }

    private static ClientHeadersFactory construct(Class<? extends ClientHeadersFactory> factory, BeanManager manager) throws IllegalAccessException, InstantiationException {
        Set beans;
        if (manager != null && !(beans = manager.getBeans(factory, new Annotation[0])).isEmpty()) {
            CdiConstructorInjector injector = new CdiConstructorInjector(factory, manager);
            return factory.cast(injector.construct(false));
        }
        return factory.newInstance();
    }

    private ClientHeaderProviders() {
    }

    static {
        HeaderFillerFactory result;
        defaultHeadersFactory = new DefaultClientHeadersFactoryImpl();
        providersForMethod = new ConcurrentHashMap<Method, ClientHeaderProvider>();
        headerFactoriesForClass = new ConcurrentHashMap();
        PrivilegedAction<HeaderFillerFactory> action = () -> {
            ServiceLoader<HeaderFillerFactory> fillerFactories = ServiceLoader.load(HeaderFillerFactory.class);
            int highestPrio = Integer.MIN_VALUE;
            HeaderFillerFactory result = null;
            for (HeaderFillerFactory factory : fillerFactories) {
                if (factory.getPriority() <= highestPrio) continue;
                highestPrio = factory.getPriority();
                result = factory;
            }
            return result;
        };
        HeaderFillerFactory headerFillerFactory = result = System.getSecurityManager() == null ? action.run() : AccessController.doPrivileged(action);
        if (result == null) {
            throw new IllegalStateException("Unable to find a HeaderFillerFactory implementation");
        }
        fillerFactory = result;
    }
}

