/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.WebApplicationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class CdiConstructorInjector
implements ConstructorInjector {
    private final BeanManager manager;
    private final Type type;

    public CdiConstructorInjector(Type type, BeanManager manager) {
        this.type = type;
        this.manager = manager;
    }

    public Object construct(boolean unwrapAsync) {
        HashSet<Bean> beans = this.manager.getBeans(this.type, new Annotation[0]);
        if (beans.size() > 1) {
            HashSet<Bean> modifiableBeans = new HashSet<Bean>(beans);
            modifiableBeans.removeIf(bean -> !bean.getBeanClass().equals(this.type) && !bean.isAlternative());
            beans = modifiableBeans;
        }
        Bean bean2 = this.manager.resolve((Set)beans);
        CreationalContext context = this.manager.createCreationalContext((Contextual)bean2);
        return this.manager.getReference(bean2, this.type, context);
    }

    public Object construct(HttpRequest request, HttpResponse response, boolean unwrapAsync) throws Failure, WebApplicationException, ApplicationException {
        return this.construct(unwrapAsync);
    }

    public Object injectableArguments(boolean unwrapAsync) {
        return null;
    }

    public Object injectableArguments(HttpRequest request, HttpResponse response, boolean unwrapAsync) throws Failure {
        return this.injectableArguments(unwrapAsync);
    }
}

