/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.SecurityUtil;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class PropertyAccess {
    public static final String jnlp_prefix = "jnlp.";
    public static final String javaws_prefix = "javaws.";
    static final HashSet<String> trustedPrefixes = new HashSet();

    public static final void addTrustedPrefix(String string, Class<?> clazz) {
        if (!SecurityUtil.equalsLocalCert(clazz)) {
            throw new SecurityException("Illegal Access - prefix " + string + ", with cert class " + clazz);
        }
        trustedPrefixes.add(string);
    }

    public static final boolean isTrusted(String string) {
        int n = string.indexOf(46);
        if (0 <= n) {
            return trustedPrefixes.contains(string.substring(0, n + 1));
        }
        return false;
    }

    public static final int getIntProperty(String string, boolean bl, AccessControlContext accessControlContext, int n) {
        int n2 = n;
        try {
            String string2 = PropertyAccess.getProperty(string, bl, accessControlContext);
            if (null != string2) {
                n2 = Integer.valueOf(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static final long getLongProperty(String string, boolean bl, AccessControlContext accessControlContext, long l) {
        long l2 = l;
        try {
            String string2 = PropertyAccess.getProperty(string, bl, accessControlContext);
            if (null != string2) {
                l2 = Long.valueOf(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l2;
    }

    public static final boolean getBooleanProperty(String string, boolean bl, AccessControlContext accessControlContext) {
        return Boolean.valueOf(PropertyAccess.getProperty(string, bl, accessControlContext));
    }

    public static final boolean getBooleanProperty(String string, boolean bl, AccessControlContext accessControlContext, boolean bl2) {
        String string2 = PropertyAccess.getProperty(string, bl, accessControlContext);
        if (null != string2) {
            return Boolean.valueOf(string2);
        }
        return bl2;
    }

    public static final boolean isPropertyDefined(String string, boolean bl, AccessControlContext accessControlContext) {
        return PropertyAccess.getProperty(string, bl, accessControlContext) != null;
    }

    public static final String getProperty(final String string, boolean bl, AccessControlContext accessControlContext) throws SecurityException, NullPointerException, IllegalArgumentException {
        if (null == string) {
            throw new NullPointerException("propertyKey is NULL");
        }
        if (0 == string.length()) {
            throw new IllegalArgumentException("propertyKey is empty");
        }
        String string2 = null;
        string2 = PropertyAccess.isTrusted(string) ? PropertyAccess.getTrustedPropKey(string) : (null != accessControlContext ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        }, accessControlContext) : System.getProperty(string));
        if (null == string2 && bl && !string.startsWith(jnlp_prefix)) {
            string2 = PropertyAccess.getTrustedPropKey(jnlp_prefix + string);
        }
        return string2;
    }

    private static final String getTrustedPropKey(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(string);
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("Could not access trusted property '" + string + "'", securityException);
                }
            }
        });
    }

    static {
        trustedPrefixes.add(javaws_prefix);
        trustedPrefixes.add(jnlp_prefix);
    }
}

