/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.opengl.GLRendererQuirks;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ProxySurface;
import javax.media.nativewindow.UpstreamSurfaceHook;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLOffscreenAutoDrawable;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;

public abstract class GLDrawableFactory {
    protected static final boolean DEBUG = Debug.debug("GLDrawable");
    protected static final boolean enableANGLE = Debug.isPropertyDefined("jogl.enable.ANGLE", true);
    protected static final boolean disableOpenGLES = Debug.isPropertyDefined("jogl.disable.opengles", true);
    static final String macosxFactoryClassNameCGL = "jogamp.opengl.macosx.cgl.MacOSXCGLDrawableFactory";
    static final String macosxFactoryClassNameAWTCGL = "jogamp.opengl.macosx.cgl.awt.MacOSXAWTCGLDrawableFactory";
    private static volatile boolean isInit = false;
    private static GLDrawableFactory eglFactory;
    private static GLDrawableFactory nativeOSFactory;
    protected static ArrayList<GLDrawableFactory> glDrawableFactories;
    private static boolean factoryShutdownHookRegistered;
    private static Thread factoryShutdownHook;
    private static volatile boolean isJVMShuttingDown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void initSingleton() {
        if (isInit) return;
        Class<GLDrawableFactory> clazz = GLDrawableFactory.class;
        synchronized (GLDrawableFactory.class) {
            if (isInit) return;
            isInit = true;
            GLDrawableFactory.initSingletonImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static final void initSingletonImpl() {
        ClassLoader classLoader;
        GLDrawableFactory gLDrawableFactory;
        block19: {
            GLDrawableFactory.registerFactoryShutdownHook();
            String string = NativeWindowFactory.getNativeWindowType(true);
            gLDrawableFactory = null;
            String string2 = Debug.getProperty("jogl.gldrawablefactory.class.name", true);
            classLoader = GLDrawableFactory.class.getClassLoader();
            if (null == string2) {
                if (string == NativeWindowFactory.TYPE_X11) {
                    string2 = "jogamp.opengl.x11.glx.X11GLXDrawableFactory";
                } else if (string == NativeWindowFactory.TYPE_WINDOWS) {
                    string2 = "jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory";
                } else if (string == NativeWindowFactory.TYPE_MACOSX) {
                    string2 = ReflectionUtil.isClassAvailable((String)macosxFactoryClassNameAWTCGL, (ClassLoader)classLoader) ? macosxFactoryClassNameAWTCGL : macosxFactoryClassNameCGL;
                } else if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("GLDrawableFactory.static - No native Windowing Factory for: " + string + "; May use EGLDrawableFactory, if available.");
                }
            }
            if (null != string2) {
                if (DEBUG || GLProfile.DEBUG) {
                    System.err.println("GLDrawableFactory.static - Native OS Factory for: " + string + ": " + string2);
                }
                try {
                    gLDrawableFactory = (GLDrawableFactory)ReflectionUtil.createInstance((String)string2, (ClassLoader)classLoader);
                }
                catch (JogampRuntimeException jogampRuntimeException) {
                    if (!DEBUG && !GLProfile.DEBUG) break block19;
                    System.err.println("Info: GLDrawableFactory.static - Native Platform: " + string + " - not available: " + string2);
                    jogampRuntimeException.printStackTrace();
                }
            }
        }
        if (null != gLDrawableFactory && gLDrawableFactory.isComplete()) {
            nativeOSFactory = gLDrawableFactory;
        }
        gLDrawableFactory = null;
        if (!disableOpenGLES) {
            block20: {
                try {
                    gLDrawableFactory = (GLDrawableFactory)ReflectionUtil.createInstance((String)"jogamp.opengl.egl.EGLDrawableFactory", (ClassLoader)classLoader);
                }
                catch (JogampRuntimeException jogampRuntimeException) {
                    if (!DEBUG && !GLProfile.DEBUG) break block20;
                    System.err.println("Info: GLDrawableFactory.static - EGLDrawableFactory - not available");
                    jogampRuntimeException.printStackTrace();
                }
            }
            if (null != gLDrawableFactory && gLDrawableFactory.isComplete()) {
                eglFactory = gLDrawableFactory;
            }
        } else if (DEBUG || GLProfile.DEBUG) {
            System.err.println("Info: GLDrawableFactory.static - EGLDrawableFactory - disabled!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void shutdown() {
        if (!isInit) return;
        Class<GLDrawableFactory> clazz = GLDrawableFactory.class;
        synchronized (GLDrawableFactory.class) {
            if (!isInit) return;
            isInit = false;
            GLDrawableFactory.shutdownImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownImpl() {
        ArrayList<GLDrawableFactory> arrayList = glDrawableFactories;
        synchronized (arrayList) {
            for (int i = 0; i < glDrawableFactories.size(); ++i) {
                glDrawableFactories.get(i).destroy();
            }
            glDrawableFactories.clear();
            nativeOSFactory = null;
            eglFactory = null;
        }
        GLContext.shutdown();
        NativeWindowFactory.shutdown(isJVMShuttingDown);
    }

    private static synchronized void registerFactoryShutdownHook() {
        if (factoryShutdownHookRegistered) {
            return;
        }
        factoryShutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                isJVMShuttingDown = true;
                GLDrawableFactory.shutdownImpl();
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Runtime.getRuntime().addShutdownHook(factoryShutdownHook);
                return null;
            }
        });
        factoryShutdownHookRegistered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLDrawableFactory() {
        ArrayList<GLDrawableFactory> arrayList = glDrawableFactories;
        synchronized (arrayList) {
            glDrawableFactories.add(this);
        }
    }

    protected abstract boolean isComplete();

    protected void enterThreadCriticalZone() {
    }

    protected void leaveThreadCriticalZone() {
    }

    protected abstract void destroy();

    public abstract AbstractGraphicsDevice getDefaultDevice();

    public abstract boolean getIsDeviceCompatible(AbstractGraphicsDevice var1);

    protected final AbstractGraphicsDevice validateDevice(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = this.getDefaultDevice();
            if (null == abstractGraphicsDevice) {
                throw new InternalError("no default device");
            }
            if (GLProfile.DEBUG) {
                System.err.println("Info: " + this.getClass().getSimpleName() + ".validateDevice: using default device : " + abstractGraphicsDevice);
            }
        }
        if (!this.getIsDeviceCompatible(abstractGraphicsDevice)) {
            if (GLProfile.DEBUG) {
                System.err.println("Info: " + this.getClass().getSimpleName() + ".validateDevice: device not compatible : " + abstractGraphicsDevice);
            }
            return null;
        }
        return abstractGraphicsDevice;
    }

    protected abstract Thread getSharedResourceThread();

    protected abstract boolean createSharedResource(AbstractGraphicsDevice var1);

    public final boolean hasRendererQuirk(AbstractGraphicsDevice abstractGraphicsDevice, int n) {
        GLRendererQuirks gLRendererQuirks = this.getRendererQuirks(abstractGraphicsDevice);
        return null != gLRendererQuirks ? gLRendererQuirks.exist(n) : false;
    }

    public abstract GLRendererQuirks getRendererQuirks(AbstractGraphicsDevice var1);

    public static GLDrawableFactory getDesktopFactory() {
        GLProfile.initSingleton();
        return nativeOSFactory;
    }

    public static GLDrawableFactory getEGLFactory() {
        GLProfile.initSingleton();
        return eglFactory;
    }

    public static GLDrawableFactory getFactory(GLProfile gLProfile) throws GLException {
        return GLDrawableFactory.getFactoryImpl(gLProfile.getImplName());
    }

    protected static GLDrawableFactory getFactoryImpl(String string) throws GLException {
        if (GLProfile.usesNativeGLES(string)) {
            if (null != eglFactory) {
                return eglFactory;
            }
        } else if (null != nativeOSFactory) {
            return nativeOSFactory;
        }
        throw new GLException("No GLDrawableFactory available for profile: " + string);
    }

    protected static GLDrawableFactory getFactoryImpl(AbstractGraphicsDevice abstractGraphicsDevice) throws GLException {
        if (null != nativeOSFactory && nativeOSFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            return nativeOSFactory;
        }
        if (null != eglFactory && eglFactory.getIsDeviceCompatible(abstractGraphicsDevice)) {
            return eglFactory;
        }
        throw new GLException("No native platform GLDrawableFactory, nor EGLDrawableFactory available: " + abstractGraphicsDevice);
    }

    public final List<GLCapabilitiesImmutable> getAvailableCapabilities(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (null != (abstractGraphicsDevice = this.validateDevice(abstractGraphicsDevice))) {
            return this.getAvailableCapabilitiesImpl(abstractGraphicsDevice);
        }
        return null;
    }

    protected abstract List<GLCapabilitiesImmutable> getAvailableCapabilitiesImpl(AbstractGraphicsDevice var1);

    public abstract GLDrawable createGLDrawable(NativeSurface var1) throws IllegalArgumentException, GLException;

    public abstract GLOffscreenAutoDrawable createOffscreenAutoDrawable(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5, GLContext var6) throws GLException;

    public abstract GLDrawable createOffscreenDrawable(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5) throws GLException;

    public abstract ProxySurface createProxySurface(AbstractGraphicsDevice var1, int var2, long var3, GLCapabilitiesImmutable var5, GLCapabilitiesChooser var6, UpstreamSurfaceHook var7);

    public abstract boolean canCreateFBO(AbstractGraphicsDevice var1, GLProfile var2);

    public abstract boolean canCreateGLPbuffer(AbstractGraphicsDevice var1);

    public abstract GLPbuffer createGLPbuffer(AbstractGraphicsDevice var1, GLCapabilitiesImmutable var2, GLCapabilitiesChooser var3, int var4, int var5, GLContext var6) throws GLException;

    public abstract GLContext createExternalGLContext() throws GLException;

    public abstract boolean canCreateExternalGLDrawable(AbstractGraphicsDevice var1);

    public abstract GLDrawable createExternalGLDrawable() throws GLException;

    static {
        glDrawableFactories = new ArrayList();
        factoryShutdownHookRegistered = false;
        factoryShutdownHook = null;
        isJVMShuttingDown = false;
    }
}

