/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.windows;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.windows.DisplayDriver;
import jogamp.newt.driver.windows.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private long hmon;
    private long hdc;
    private long hdc_old;
    private long windowHandleClose;
    private IntIntHashMap typedKeyCode2KeyChar = new IntIntHashMap(526);

    @Override
    protected int lockSurfaceImpl() {
        if (0L != this.hdc) {
            throw new InternalError("surface not released");
        }
        this.hdc = GDI.GetDC(this.getWindowHandle());
        this.hmon = this.MonitorFromWindow0(this.getWindowHandle());
        if (0L == this.hdc) {
            return 1;
        }
        if (this.hdc_old == this.hdc) {
            return 3;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow: surface change " + WindowDriver.toHexString(this.hdc_old) + " -> " + WindowDriver.toHexString(this.hdc));
        }
        return 2;
    }

    @Override
    protected void unlockSurfaceImpl() {
        if (0L != this.hdc) {
            GDI.ReleaseDC(this.getWindowHandle(), this.hdc);
            this.hdc_old = this.hdc;
            this.hdc = 0L;
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return this.hdc;
    }

    @Override
    public boolean hasDeviceChanged() {
        long l;
        if (0L != this.getWindowHandle() && this.hmon != (l = this.MonitorFromWindow0(this.getWindowHandle()))) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Info: Window Device Changed " + Thread.currentThread().getName() + ", HMON " + WindowDriver.toHexString(this.hmon) + " -> " + WindowDriver.toHexString(l));
            }
            this.hmon = l;
            return true;
        }
        return false;
    }

    @Override
    protected void createNativeImpl() {
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(displayDriver.getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, screenDriver.getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        int n = this.getReconfigureFlags(0, true) & 0xA00;
        this.setWindowHandle(this.CreateWindow0(displayDriver.getHInstance(), displayDriver.getWindowClassName(), displayDriver.getWindowClassName(), this.getParentWindowHandle(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.autoPosition(), n));
        if (this.getWindowHandle() == 0L) {
            throw new NativeWindowException("Error creating window");
        }
        this.windowHandleClose = this.getWindowHandle();
        this.addMouseListener(new MouseTracker());
        if (DEBUG_IMPLEMENTATION) {
            Exception exception = new Exception("Info: Window new window handle " + Thread.currentThread().getName() + " (Parent HWND " + WindowDriver.toHexString(this.getParentWindowHandle()) + ") : HWND " + WindowDriver.toHexString(this.getWindowHandle()) + ", " + Thread.currentThread());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        if (this.windowHandleClose != 0L) {
            Exception exception;
            block10: {
                if (this.hdc != 0L) {
                    try {
                        GDI.ReleaseDC(this.windowHandleClose, this.hdc);
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG_IMPLEMENTATION) break block10;
                        exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                        exception.printStackTrace();
                    }
                }
            }
            try {
                GDI.DestroyWindow(this.windowHandleClose);
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                this.windowHandleClose = 0L;
            }
        }
        this.hdc = 0L;
        this.hdc_old = 0L;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow reconfig: " + n + "/" + n2 + " " + n3 + "x" + n4 + ", " + WindowDriver.getReconfigureFlagsAsString(null, n5));
        }
        if (0 == (0x200 & n5)) {
            InsetsImmutable insetsImmutable = this.getInsets();
            n -= insetsImmutable.getLeftWidth();
            n2 -= insetsImmutable.getTopHeight();
            if (0 < n3 && 0 < n4) {
                n3 += insetsImmutable.getTotalWidth();
                n4 += insetsImmutable.getTotalHeight();
            }
        }
        this.reconfigureWindow0(this.getParentWindowHandle(), this.getWindowHandle(), n, n2, n3, n4, n5);
        if (0 != (0x10 & n5)) {
            this.visibleChanged(false, 0 != (0x1000 & n5));
        }
        return true;
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getWindowHandle(), bl);
    }

    @Override
    protected void setTitleImpl(String string) {
        WindowDriver.setTitle0(this.getWindowHandle(), string);
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                booleanArray[0] = WindowDriver.setPointerVisible0(WindowDriver.this.getWindowHandle(), bl);
            }
        });
        return booleanArray[0];
    }

    @Override
    protected boolean confinePointerImpl(final boolean bl) {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = WindowDriver.this.getLocationOnScreenImpl(0, 0);
                booleanArray[0] = WindowDriver.confinePointer0(WindowDriver.this.getWindowHandle(), bl, point.getX(), point.getY(), point.getX() + WindowDriver.this.getWidth(), point.getY() + WindowDriver.this.getHeight());
            }
        });
        return booleanArray[0];
    }

    @Override
    protected void warpPointerImpl(final int n, final int n2) {
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = WindowDriver.this.getLocationOnScreenImpl(n, n2);
                WindowDriver.warpPointer0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY());
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return GDIUtil.GetRelativeLocation(this.getWindowHandle(), 0L, n, n2);
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    private final void emitKeyEvent(boolean bl, boolean bl2, int n, int n2, int n3, char c) {
        if (bl) {
            super.sendKeyEvent(n, n2, n3, c);
        } else {
            super.enqueueKeyEvent(bl2, n, n2, n3, c);
        }
    }

    private final void handleKeyEvent(boolean bl, boolean bl2, int n, int n2, int n3, char c) {
        boolean bl3 = KeyEvent.isModifierKey(n3);
        switch (n) {
            case 301: {
                int n4;
                if (this.isKeyCodeTracked(n3)) {
                    if (this.keyRepeatState.put((long)n3, false) && !bl3) {
                        this.emitKeyEvent(bl, bl2, 300, n2 | 0x20000000, n3, c);
                    }
                    this.keyPressedState.put((long)n3, false);
                }
                if (0 != (n4 = this.typedKeyCode2KeyChar.put(n3, 0))) {
                    c = (char)n4;
                }
                this.emitKeyEvent(bl, bl2, n, n2, n3, c);
                this.emitKeyEvent(bl, bl2, 302, n2, n3, c);
                break;
            }
            case 300: {
                if (this.isKeyCodeTracked(n3)) {
                    if (this.keyPressedState.put((long)n3, true)) {
                        if (!this.keyRepeatState.put((long)n3, true) || bl3) break;
                        this.emitKeyEvent(bl, bl2, n, n2 | 0x20000000, n3, c);
                        break;
                    }
                    this.emitKeyEvent(bl, bl2, n, n2, n3, c);
                    break;
                }
                this.emitKeyEvent(bl, bl2, n, n2, n3, c);
                break;
            }
            case 302: {
                if (1 == this.isKeyInAutoRepeat(n3)) {
                    this.emitKeyEvent(bl, bl2, 301, n2 |= 0x20000000, n3, c);
                    this.emitKeyEvent(bl, bl2, n, n2, n3, c);
                    break;
                }
                if (0 == n3) break;
                this.typedKeyCode2KeyChar.put(n3, (int)c);
            }
        }
    }

    @Override
    public void sendKeyEvent(int n, int n2, int n3, char c) {
        this.handleKeyEvent(true, false, n, n2, n3, c);
    }

    @Override
    public void enqueueKeyEvent(boolean bl, int n, int n2, int n3, char c) {
        this.handleKeyEvent(false, bl, n, n2, n3, c);
    }

    protected static native boolean initIDs0();

    protected static native long getNewtWndProc0();

    private native long CreateWindow0(long var1, String var3, String var4, long var5, int var7, int var8, int var9, int var10, boolean var11, int var12);

    private native long MonitorFromWindow0(long var1);

    private native void reconfigureWindow0(long var1, long var3, int var5, int var6, int var7, int var8, int var9);

    private static native void setTitle0(long var0, String var2);

    private native void requestFocus0(long var1, boolean var3);

    private static native boolean setPointerVisible0(long var0, boolean var2);

    private static native boolean confinePointer0(long var0, boolean var2, int var3, int var4, int var5, int var6);

    private static native void warpPointer0(long var0, int var2, int var3);

    private static native void trackPointerLeave0(long var0);

    static {
        DisplayDriver.initSingleton();
    }

    class MouseTracker
    extends MouseAdapter {
        MouseTracker() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            WindowDriver.trackPointerLeave0(WindowDriver.this.getWindowHandle());
        }
    }
}

