/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import jogamp.opengl.GLContextImpl;

final class ExtensionAvailabilityCache {
    protected static final boolean DEBUG = GLContextImpl.DEBUG;
    private boolean initialized = false;
    private String glExtensions = null;
    private int glExtensionCount = 0;
    private String glXExtensions = null;
    private int glXExtensionCount = 0;
    private HashSet<String> availableExtensionCache = new HashSet(50);

    ExtensionAvailabilityCache() {
        this.flush();
    }

    final void flush() {
        this.initialized = false;
        this.glExtensions = null;
        this.glExtensionCount = 0;
        this.glXExtensions = null;
        this.glXExtensionCount = 0;
        this.availableExtensionCache.clear();
    }

    final void reset(GLContextImpl gLContextImpl) {
        this.flush();
        this.initAvailableExtensions(gLContextImpl);
    }

    final boolean isInitialized() {
        return this.initialized && !this.availableExtensionCache.isEmpty();
    }

    final int getTotalExtensionCount() {
        this.validateInitialization();
        return this.availableExtensionCache.size();
    }

    final boolean isExtensionAvailable(String string) {
        this.validateInitialization();
        return this.availableExtensionCache.contains(string);
    }

    final int getPlatformExtensionCount() {
        this.validateInitialization();
        return this.glXExtensionCount;
    }

    final String getPlatformExtensionsString() {
        this.validateInitialization();
        return this.glXExtensions;
    }

    final int getGLExtensionCount() {
        this.validateInitialization();
        return this.glExtensionCount;
    }

    final String getGLExtensionsString() {
        this.validateInitialization();
        if (DEBUG) {
            System.err.println("ExtensionAvailabilityCache: getGLExtensions() called");
        }
        return this.glExtensions;
    }

    private final void validateInitialization() {
        if (!this.isInitialized()) {
            throw new InternalError("ExtensionAvailabilityCache not initialized!");
        }
    }

    private final void initAvailableExtensions(GLContextImpl gLContextImpl) {
        Object object;
        Object object2;
        GL gL = gLContextImpl.getGL();
        if (this.isInitialized()) {
            throw new InternalError("ExtensionAvailabilityCache already initialized!");
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching init " + gL + ", OpenGL " + gLContextImpl.getGLVersion());
        }
        boolean bl = false;
        if (gLContextImpl.isGL3()) {
            if (!gLContextImpl.isFunctionAvailable("glGetStringi")) {
                if (DEBUG) {
                    System.err.println("GLContext: GL >= 3.1 usage, but no glGetStringi");
                }
            } else {
                bl = true;
            }
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching extension availability OpenGL " + gLContextImpl.getGLVersion() + ", use " + (bl ? "glGetStringi" : "glGetString"));
        }
        HashSet<String> hashSet = new HashSet<String>(gL.isGLES() ? 50 : 320);
        if (bl) {
            object2 = gL.getGL2GL3();
            object = new int[]{0};
            object2.glGetIntegerv(33309, (int[])object, 0);
            int n = object[0];
            object = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    object.append(" ");
                }
                String string = object2.glGetStringi(7939, i);
                hashSet.add(string);
                object.append(string);
            }
            if (0 == n || object.length() == 0) {
                bl = false;
            } else {
                this.glExtensions = object.toString();
            }
        }
        if (!bl) {
            this.glExtensions = gL.glGetString(7939);
            if (null != this.glExtensions) {
                object2 = new StringTokenizer(this.glExtensions);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    hashSet.add(((StringTokenizer)object2).nextToken().trim());
                }
            }
        }
        this.glExtensionCount = hashSet.size();
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL_EXTENSIONS: " + this.glExtensionCount + ", used " + (bl ? "glGetStringi" : "glGetString"));
        }
        object2 = new HashSet(50);
        Object object3 = new StringTokenizer(gLContextImpl.getPlatformExtensionsStringImpl().toString());
        while (((StringTokenizer)object3).hasMoreTokens()) {
            ((HashSet)object2).add(((StringTokenizer)object3).nextToken().trim());
        }
        object = new StringBuilder();
        Iterator iterator = ((HashSet)object2).iterator();
        while (iterator.hasNext()) {
            object.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            object.append(" ");
        }
        this.glXExtensions = object.toString();
        this.glXExtensionCount = ((HashSet)object2).size();
        this.availableExtensionCache.addAll(hashSet);
        this.availableExtensionCache.addAll((Collection<String>)object2);
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GLX_EXTENSIONS: " + this.glXExtensionCount);
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL vendor: " + gL.glGetString(7936));
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: ALL EXTENSIONS: " + this.availableExtensionCache.size());
        }
        if (!gLContextImpl.isGLES()) {
            object3 = new int[]{gLContextImpl.getGLVersionMajor()};
            object = new int[]{gLContextImpl.getGLVersionMinor()};
            while (GLContext.isValidGLVersion((int)object3[0], object[0])) {
                this.availableExtensionCache.add("GL_VERSION_" + (int)object3[0] + "_" + object[0]);
                if (DEBUG) {
                    System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Added GL_VERSION_" + (int)object3[0] + "_" + object[0] + " to known extensions");
                }
                if (GLContext.decrementGLVersion((int[])object3, object)) continue;
            }
        }
        this.availableExtensionCache.add("<INTERNAL_DUMMY_PLACEHOLDER>");
        this.initialized = true;
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

