/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ccex;

import java.io.IOException;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.knowm.xchange.ccex.dto.marketdata.CCEXGetorderbook;
import org.knowm.xchange.ccex.dto.marketdata.CCEXMarkets;
import org.knowm.xchange.ccex.dto.marketdata.CCEXTrades;
import org.knowm.xchange.ccex.dto.ticker.CCEXPairs;
import org.knowm.xchange.ccex.dto.ticker.CCEXTickerResponse;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.utils.jackson.CurrencyPairDeserializer;

@Path(value="t")
@Produces(value={"application/json"})
public interface CCEX {
    @GET
    @Path(value="api_pub.html?a=getmarkets")
    public CCEXMarkets getProducts() throws IOException;

    @GET
    @Path(value="pairs.json")
    public CCEXPairs getPairs() throws IOException;

    @GET
    @Path(value="{lpair}-{rpair}.json")
    public CCEXTickerResponse getTicker(@PathParam(value="lpair") String var1, @PathParam(value="rpair") String var2) throws IOException;

    @GET
    @Path(value="api_pub.html?a=getorderbook&market={pair}&type=both&depth={depth}")
    public CCEXGetorderbook getOrderBook(@PathParam(value="pair") Pair var1, @PathParam(value="depth") int var2) throws IOException;

    @GET
    @Path(value="api_pub.html?a=getmarkethistory&market={pair}&count=100")
    public CCEXTrades getTrades(@PathParam(value="pair") Pair var1) throws IOException;

    public static class Pair {
        public final CurrencyPair pair;

        public Pair(CurrencyPair pair) {
            this.pair = pair;
        }

        public Pair(String pair) {
            this(CurrencyPairDeserializer.getCurrencyPairFromString((String)pair));
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Objects.equals(this.pair, ((Pair)o).pair);
        }

        public int hashCode() {
            return Objects.hash(this.pair);
        }

        public String toString() {
            return String.format("%s-%s", this.pair.base.getCurrencyCode().toLowerCase(), this.pair.counter.getCurrencyCode().toLowerCase());
        }
    }
}

