/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ccex;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.ccex.CCEXAdapters;
import org.knowm.xchange.ccex.dto.marketdata.CCEXMarket;
import org.knowm.xchange.ccex.service.CCEXAccountService;
import org.knowm.xchange.ccex.service.CCEXMarketDataService;
import org.knowm.xchange.ccex.service.CCEXMarketDataServiceRaw;
import org.knowm.xchange.ccex.service.CCEXTradeService;
import org.knowm.xchange.utils.nonce.CurrentTimeNonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class CCEXExchange
extends BaseExchange
implements Exchange {
    private SynchronizedValueFactory<Long> nonceFactory = new CurrentTimeNonceFactory();

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://c-cex.com");
        exchangeSpecification.setHost("c-cex.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("C-CEX");
        exchangeSpecification.setExchangeDescription("C-CEX.com - Crypto-currency exchange / MultiWallet");
        return exchangeSpecification;
    }

    protected void initServices() {
        this.marketDataService = new CCEXMarketDataService(this);
        this.tradeService = new CCEXTradeService(this);
        this.accountService = new CCEXAccountService(this);
    }

    public void remoteInit() throws IOException {
        List<CCEXMarket> products = ((CCEXMarketDataServiceRaw)this.marketDataService).getConbaseExProducts();
        this.exchangeMetaData = CCEXAdapters.adaptToExchangeMetaData(this.exchangeMetaData, products);
    }
}

