/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ccex.dto.ticker;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;

@JsonDeserialize(using=CCEXPriceDeserializer.class)
public class CCEXPrice {
    private final BigDecimal high;
    private final BigDecimal low;
    private final BigDecimal avg;
    private final BigDecimal lastbuy;
    private final BigDecimal lastsell;
    private final BigDecimal buy;
    private final BigDecimal sell;
    private final BigDecimal lastprice;
    private final int updated;

    private CCEXPrice(BigDecimal high, BigDecimal low, BigDecimal avg, BigDecimal lastbuy, BigDecimal lastsell, BigDecimal buy, BigDecimal sell, BigDecimal lastprice, int updated) {
        this.high = high;
        this.low = low;
        this.avg = avg;
        this.lastbuy = lastbuy;
        this.lastsell = lastsell;
        this.buy = buy;
        this.sell = sell;
        this.lastprice = lastprice;
        this.updated = updated;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getAvg() {
        return this.avg;
    }

    public BigDecimal getLastbuy() {
        return this.lastbuy;
    }

    public BigDecimal getLastsell() {
        return this.lastsell;
    }

    public BigDecimal getBuy() {
        return this.buy;
    }

    public BigDecimal getSell() {
        return this.sell;
    }

    public BigDecimal getLastprice() {
        return this.lastprice;
    }

    public int getUpdated() {
        return this.updated;
    }

    public String toString() {
        return "CCEXPrice [high=" + this.high + ", low=" + this.low + ", avg=" + this.avg + ", lastbuy=" + this.lastbuy + ", lastsell=" + this.lastsell + ", buy=" + this.buy + ", sell=" + this.sell + ", lastprice=" + this.lastprice + ", updated=" + this.updated + "]";
    }

    static class CCEXPriceDeserializer
    extends JsonDeserializer<CCEXPrice> {
        CCEXPriceDeserializer() {
        }

        private static BigDecimal getNumberIfPresent(JsonNode numberNode) {
            String numberString = numberNode.asText();
            return numberString.isEmpty() ? null : new BigDecimal(numberString);
        }

        public static CCEXPrice deserializeFromNode(JsonNode tickerNode) {
            BigDecimal high = CCEXPriceDeserializer.getNumberIfPresent(tickerNode.path("high"));
            BigDecimal low = CCEXPriceDeserializer.getNumberIfPresent(tickerNode.path("low"));
            BigDecimal avg = CCEXPriceDeserializer.getNumberIfPresent(tickerNode.path("avg"));
            BigDecimal lastbuy = CCEXPriceDeserializer.getNumberIfPresent(tickerNode.path("lastbuy"));
            BigDecimal lastsell = CCEXPriceDeserializer.getNumberIfPresent(tickerNode.path("lastsell"));
            BigDecimal buy = CCEXPriceDeserializer.getNumberIfPresent(tickerNode.path("buy"));
            BigDecimal sell = CCEXPriceDeserializer.getNumberIfPresent(tickerNode.path("sell"));
            BigDecimal lastprice = CCEXPriceDeserializer.getNumberIfPresent(tickerNode.path("lastprice"));
            int updated = tickerNode.path("updated").asInt();
            return new CCEXPrice(high, low, avg, lastbuy, lastsell, buy, sell, lastprice, updated);
        }

        public CCEXPrice deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jp.getCodec();
            JsonNode tickerNode = (JsonNode)oc.readTree(jp);
            return CCEXPriceDeserializer.deserializeFromNode(tickerNode);
        }
    }
}

