/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.ccex.dto.ticker;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.knowm.xchange.ccex.CCEXAdapters;
import org.knowm.xchange.ccex.dto.ticker.CCEXPrice;
import org.knowm.xchange.currency.CurrencyPair;

@JsonDeserialize(using=CCEXPricesDeserializer.class)
public class CCEXPrices {
    private final Map<CurrencyPair, CCEXPrice> priceMap;

    private CCEXPrices(Map<CurrencyPair, CCEXPrice> priceMap) {
        this.priceMap = priceMap;
    }

    public Map<CurrencyPair, CCEXPrice> getTickerMap() {
        return this.priceMap;
    }

    public String toString() {
        return "CCEXPrices [priceMap=" + this.priceMap + "]";
    }

    static class CCEXPricesDeserializer
    extends JsonDeserializer<CCEXPrices> {
        CCEXPricesDeserializer() {
        }

        public CCEXPrices deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            HashMap<CurrencyPair, CCEXPrice> priceMap = new HashMap<CurrencyPair, CCEXPrice>();
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            if (node.isObject()) {
                Iterator priceEntryIter = node.fields();
                while (priceEntryIter.hasNext()) {
                    Map.Entry priceEntryNode = (Map.Entry)priceEntryIter.next();
                    String pairString = (String)priceEntryNode.getKey();
                    CurrencyPair pair = CCEXAdapters.adaptCurrencyPair(pairString);
                    JsonNode priceNode = (JsonNode)priceEntryNode.getValue();
                    CCEXPrice price = CCEXPrice.CCEXPriceDeserializer.deserializeFromNode(priceNode);
                    priceMap.put(pair, price);
                }
            }
            return new CCEXPrices(priceMap);
        }
    }
}

