/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class SourceReference {
    private final Parameter parameter;
    private final List<PropertyEntry> propertyEntries;
    private final boolean isValid;

    private SourceReference(Parameter sourceParameter, List<PropertyEntry> sourcePropertyEntries, boolean isValid) {
        this.parameter = sourceParameter;
        this.propertyEntries = sourcePropertyEntries;
        this.isValid = isValid;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public List<PropertyEntry> getPropertyEntries() {
        return this.propertyEntries;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public List<String> getElementNames() {
        ArrayList<String> sourceName = new ArrayList<String>();
        sourceName.add(this.parameter.getName());
        for (PropertyEntry propertyEntry : this.propertyEntries) {
            sourceName.add(propertyEntry.getName());
        }
        return sourceName;
    }

    public SourceReference copyForInheritanceTo(SourceMethod method) {
        ArrayList<Parameter> replacementParamCandidates = new ArrayList<Parameter>();
        for (Parameter sourceParam : method.getSourceParameters()) {
            if (!sourceParam.getType().isAssignableTo(this.parameter.getType())) continue;
            replacementParamCandidates.add(sourceParam);
        }
        Parameter replacement = this.parameter;
        if (replacementParamCandidates.size() == 1) {
            replacement = (Parameter)Collections.first(replacementParamCandidates);
        }
        return new SourceReference(replacement, this.propertyEntries, this.isValid);
    }

    public static class BuilderFromProperty {
        private String name;
        private ExecutableElement readAccessor;
        private ExecutableElement presenceChecker;
        private Type type;
        private Parameter sourceParameter;

        public BuilderFromProperty name(String name) {
            this.name = name;
            return this;
        }

        public BuilderFromProperty readAccessor(ExecutableElement readAccessor) {
            this.readAccessor = readAccessor;
            return this;
        }

        public BuilderFromProperty presenceChecker(ExecutableElement presenceChecker) {
            this.presenceChecker = presenceChecker;
            return this;
        }

        public BuilderFromProperty type(Type type) {
            this.type = type;
            return this;
        }

        public BuilderFromProperty sourceParameter(Parameter sourceParameter) {
            this.sourceParameter = sourceParameter;
            return this;
        }

        public SourceReference build() {
            ArrayList<PropertyEntry> sourcePropertyEntries = new ArrayList<PropertyEntry>();
            if (this.readAccessor != null) {
                sourcePropertyEntries.add(PropertyEntry.forSourceReference(this.name, this.readAccessor, this.presenceChecker, this.type));
            }
            return new SourceReference(this.sourceParameter, sourcePropertyEntries, true);
        }
    }

    public static class BuilderFromMapping {
        private Mapping mapping;
        private SourceMethod method;
        private FormattingMessager messager;
        private TypeFactory typeFactory;

        public BuilderFromMapping messager(FormattingMessager messager) {
            this.messager = messager;
            return this;
        }

        public BuilderFromMapping mapping(Mapping mapping) {
            this.mapping = mapping;
            return this;
        }

        public BuilderFromMapping method(SourceMethod method) {
            this.method = method;
            return this;
        }

        public BuilderFromMapping typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public SourceReference build() {
            boolean foundEntryMatch;
            String sourceName = this.mapping.getSourceName();
            if (sourceName == null) {
                return null;
            }
            boolean isValid = true;
            String[] sourcePropertyNames = new String[]{};
            String[] segments = sourceName.split("\\.");
            Parameter parameter = null;
            List<Object> entries = new ArrayList();
            if (this.method.getSourceParameters().size() > 1) {
                String sourceParameterName;
                if (segments.length > 0 && (parameter = this.method.getSourceParameter(sourceParameterName = segments[0])) == null) {
                    this.reportMappingError(Message.PROPERTYMAPPING_INVALID_PARAMETER_NAME, sourceParameterName);
                    isValid = false;
                }
                if (segments.length > 1 && parameter != null) {
                    sourcePropertyNames = Arrays.copyOfRange(segments, 1, segments.length);
                    entries = this.getSourceEntries(parameter.getType(), sourcePropertyNames);
                    foundEntryMatch = entries.size() == sourcePropertyNames.length;
                } else {
                    foundEntryMatch = true;
                }
            } else {
                sourcePropertyNames = segments;
                parameter = this.method.getSourceParameters().get(0);
                entries = this.getSourceEntries(parameter.getType(), sourcePropertyNames);
                boolean bl = foundEntryMatch = entries.size() == sourcePropertyNames.length;
                if (!foundEntryMatch) {
                    if (parameter.getName().equals(segments[0])) {
                        sourcePropertyNames = Arrays.copyOfRange(segments, 1, segments.length);
                        entries = this.getSourceEntries(parameter.getType(), sourcePropertyNames);
                        foundEntryMatch = entries.size() == sourcePropertyNames.length;
                    } else {
                        parameter = null;
                    }
                }
            }
            if (!foundEntryMatch) {
                if (parameter != null) {
                    this.reportMappingError(Message.PROPERTYMAPPING_NO_PROPERTY_IN_PARAMETER, parameter.getName(), Strings.join(Arrays.asList(sourcePropertyNames), "."));
                } else {
                    this.reportMappingError(Message.PROPERTYMAPPING_INVALID_PROPERTY_NAME, this.mapping.getSourceName());
                }
                isValid = false;
            }
            return new SourceReference(parameter, entries, isValid);
        }

        private List<PropertyEntry> getSourceEntries(Type type, String[] entryNames) {
            ArrayList<PropertyEntry> sourceEntries = new ArrayList<PropertyEntry>();
            Type newType = type;
            for (String entryName : entryNames) {
                boolean matchFound = false;
                Map<String, ExecutableElement> sourceReadAccessors = newType.getPropertyReadAccessors();
                Map<String, ExecutableElement> sourcePresenceCheckers = newType.getPropertyPresenceCheckers();
                for (Map.Entry<String, ExecutableElement> getter : sourceReadAccessors.entrySet()) {
                    if (!getter.getKey().equals(entryName)) continue;
                    newType = this.typeFactory.getReturnType((DeclaredType)newType.getTypeMirror(), getter.getValue());
                    sourceEntries.add(PropertyEntry.forSourceReference(entryName, getter.getValue(), sourcePresenceCheckers.get(entryName), newType));
                    matchFound = true;
                    break;
                }
                if (!matchFound) break;
            }
            return sourceEntries;
        }

        private void reportMappingError(Message msg, Object ... objects) {
            this.messager.printMessage((Element)this.method.getExecutable(), this.mapping.getMirror(), this.mapping.getSourceAnnotationValue(), msg, objects);
        }
    }
}

