/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.vault;

import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoConfigurationException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoUpdatedEncryptedFieldsException;
import com.mongodb.ReadConcern;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateEncryptedCollectionParams;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.Updates;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.mongodb.client.model.vault.RewrapManyDataKeyResult;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.mongodb.reactivestreams.client.internal.crypt.Crypts;
import com.mongodb.reactivestreams.client.vault.ClientEncryption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.internal.BsonUtil;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClientEncryptionImpl
implements ClientEncryption {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;
    private final MongoCollection<BsonDocument> collection;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this(MongoClients.create(options.getKeyVaultMongoClientSettings()), options);
    }

    public ClientEncryptionImpl(MongoClient keyVaultClient, ClientEncryptionSettings options) {
        this.keyVaultClient = keyVaultClient;
        this.crypt = Crypts.create(keyVaultClient, options);
        this.options = options;
        MongoNamespace namespace = new MongoNamespace(options.getKeyVaultNamespace());
        this.collection = keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).withReadConcern(ReadConcern.MAJORITY);
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        return this.crypt.createDataKey(kmsProvider, dataKeyOptions).flatMap(dataKeyDocument -> {
            MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
            return Mono.from(this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne((BsonDocument)dataKeyDocument)).map(i -> dataKeyDocument.getBinary((Object)"_id"));
        });
    }

    @Override
    public Publisher<BsonBinary> encrypt(BsonValue value, EncryptOptions options) {
        return this.crypt.encryptExplicitly(value, options);
    }

    @Override
    public Publisher<BsonDocument> encryptExpression(Bson expression, EncryptOptions options) {
        return this.crypt.encryptExpression(expression.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options);
    }

    @Override
    public Publisher<BsonValue> decrypt(BsonBinary value) {
        return this.crypt.decryptExplicitly(value);
    }

    @Override
    public Publisher<DeleteResult> deleteKey(BsonBinary id) {
        return this.collection.deleteOne(Filters.eq((String)"_id", (Object)id));
    }

    @Override
    public Publisher<BsonDocument> getKey(BsonBinary id) {
        return this.collection.find(Filters.eq((String)"_id", (Object)id)).first();
    }

    @Override
    public FindPublisher<BsonDocument> getKeys() {
        return this.collection.find();
    }

    @Override
    public Publisher<BsonDocument> addKeyAltName(BsonBinary id, String keyAltName) {
        return this.collection.findOneAndUpdate(Filters.eq((String)"_id", (Object)id), Updates.addToSet((String)"keyAltNames", (Object)keyAltName));
    }

    @Override
    public Publisher<BsonDocument> removeKeyAltName(BsonBinary id, String keyAltName) {
        BsonDocument updateDocument = new BsonDocument().append("$set", (BsonValue)new BsonDocument().append("keyAltNames", (BsonValue)new BsonDocument().append("$cond", (BsonValue)new BsonArray(Arrays.asList(new BsonDocument().append("$eq", (BsonValue)new BsonArray(Arrays.asList(new BsonString("$keyAltNames"), new BsonArray(Collections.singletonList(new BsonString(keyAltName)))))), new BsonString("$$REMOVE"), new BsonDocument().append("$filter", (BsonValue)new BsonDocument().append("input", (BsonValue)new BsonString("$keyAltNames")).append("cond", (BsonValue)new BsonDocument().append("$ne", (BsonValue)new BsonArray(Arrays.asList(new BsonString("$$this"), new BsonString(keyAltName)))))))))));
        return this.collection.findOneAndUpdate(Filters.eq((String)"_id", (Object)id), Collections.singletonList(updateDocument));
    }

    @Override
    public Publisher<BsonDocument> getKeyByAltName(String keyAltName) {
        return this.collection.find(Filters.eq((String)"keyAltNames", (Object)keyAltName)).first();
    }

    @Override
    public Publisher<RewrapManyDataKeyResult> rewrapManyDataKey(Bson filter) {
        return this.rewrapManyDataKey(filter, new RewrapManyDataKeyOptions());
    }

    @Override
    public Publisher<RewrapManyDataKeyResult> rewrapManyDataKey(Bson filter, RewrapManyDataKeyOptions options) {
        return Mono.fromRunnable(() -> MongoCryptHelper.validateRewrapManyDataKeyOptions((RewrapManyDataKeyOptions)options)).then(this.crypt.rewrapManyDataKey(filter.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options).flatMap(results -> {
            if (results.isEmpty()) {
                return Mono.fromCallable(RewrapManyDataKeyResult::new);
            }
            List updateModels = results.getArray((Object)"v", new BsonArray()).stream().map(v -> {
                BsonDocument updateDocument = v.asDocument();
                return new UpdateOneModel(Filters.eq((Object)updateDocument.get((Object)"_id")), Updates.combine((Bson[])new Bson[]{Updates.set((String)"masterKey", (Object)updateDocument.get((Object)"masterKey")), Updates.set((String)"keyMaterial", (Object)updateDocument.get((Object)"keyMaterial")), Updates.currentDate((String)"updateDate")}));
            }).collect(Collectors.toList());
            return Mono.from(this.collection.bulkWrite(updateModels)).map(RewrapManyDataKeyResult::new);
        }));
    }

    @Override
    public Publisher<BsonDocument> createEncryptedCollection(MongoDatabase database, String collectionName, CreateCollectionOptions createCollectionOptions, CreateEncryptedCollectionParams createEncryptedCollectionParams) {
        Assertions.notNull((String)"collectionName", (Object)collectionName);
        Assertions.notNull((String)"createCollectionOptions", (Object)createCollectionOptions);
        Assertions.notNull((String)"createEncryptedCollectionParams", (Object)createEncryptedCollectionParams);
        MongoNamespace namespace = new MongoNamespace(database.getName(), collectionName);
        Bson rawEncryptedFields = createCollectionOptions.getEncryptedFields();
        if (rawEncryptedFields == null) {
            throw new MongoConfigurationException(String.format("`encryptedFields` is not configured for the collection %s.", namespace));
        }
        CodecRegistry codecRegistry = this.options.getKeyVaultMongoClientSettings().getCodecRegistry();
        BsonDocument encryptedFields = rawEncryptedFields.toBsonDocument(BsonDocument.class, codecRegistry);
        BsonValue fields = encryptedFields.get((Object)"fields");
        if (fields != null && fields.isArray()) {
            String kmsProvider = createEncryptedCollectionParams.getKmsProvider();
            DataKeyOptions dataKeyOptions = new DataKeyOptions();
            BsonDocument masterKey = createEncryptedCollectionParams.getMasterKey();
            if (masterKey != null) {
                dataKeyOptions.masterKey(masterKey);
            }
            String keyIdBsonKey = "keyId";
            return Mono.defer(() -> {
                BsonDocument maybeUpdatedEncryptedFields = BsonUtil.mutableDeepCopy((BsonDocument)encryptedFields);
                AtomicBoolean dataKeyMightBeCreated = new AtomicBoolean();
                Iterable publishersOfUpdatedFields = () -> maybeUpdatedEncryptedFields.get((Object)"fields").asArray().stream().filter(BsonValue::isDocument).map(BsonValue::asDocument).filter(field -> field.containsKey((Object)keyIdBsonKey)).filter(field -> Objects.equals(field.get((Object)keyIdBsonKey), BsonNull.VALUE)).map(field -> Mono.fromDirect(this.createDataKey(kmsProvider, dataKeyOptions)).doOnSubscribe(subscription -> dataKeyMightBeCreated.set(true)).doOnNext(dataKeyId -> field.put(keyIdBsonKey, (BsonValue)dataKeyId)).map(dataKeyId -> field)).iterator();
                Flux publisherOfUpdatedFields = Flux.concat(publishersOfUpdatedFields);
                return publisherOfUpdatedFields.thenEmpty((Publisher)Mono.defer(() -> Mono.fromDirect(database.createCollection(collectionName, new CreateCollectionOptions(createCollectionOptions).encryptedFields((Bson)maybeUpdatedEncryptedFields))))).onErrorMap(e -> dataKeyMightBeCreated.get(), e -> new MongoUpdatedEncryptedFieldsException(maybeUpdatedEncryptedFields, String.format("Failed to create %s.", namespace), e)).thenReturn((Object)maybeUpdatedEncryptedFields);
            });
        }
        return Mono.fromDirect(database.createCollection(collectionName, createCollectionOptions)).thenReturn((Object)encryptedFields);
    }

    @Override
    public void close() {
        this.keyVaultClient.close();
        this.crypt.close();
    }
}

