/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;

public class MuleArchiver
extends ZipArchiver {
    public static final String LIB_LOCATION = "lib" + File.separator;
    public static final String CLASSES_LOCATION = "classes" + File.separator;
    public static final String ROOT_LOCATION = "";
    private boolean prependGroupId;

    public MuleArchiver(boolean prependGroupId) {
        this.prependGroupId = prependGroupId;
    }

    public void addResources(File directoryName) throws ArchiverException {
        this.addDirectory(directoryName, ROOT_LOCATION, null, this.addDefaultExcludes(null));
    }

    public void addLib(File file) throws ArchiverException {
        this.addFile(file, LIB_LOCATION + file.getName());
    }

    public void addLibraryArtifact(Artifact artifact) throws ArchiverException {
        String filename = this.filenameInArchive(artifact);
        this.addFile(artifact.getFile(), filename);
    }

    private String filenameInArchive(Artifact artifact) {
        StringBuilder buf = new StringBuilder(LIB_LOCATION);
        if (this.prependGroupId) {
            buf.append(artifact.getGroupId());
            buf.append(".");
        }
        buf.append(artifact.getFile().getName());
        return buf.toString();
    }

    public void addLibs(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, LIB_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    public void addClasses(File directoryName, String[] includes, String[] excludes) throws ArchiverException {
        this.addDirectory(directoryName, CLASSES_LOCATION, includes, this.addDefaultExcludes(excludes));
    }

    private String[] addDefaultExcludes(String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return DirectoryScanner.DEFAULTEXCLUDES;
        }
        String[] newExcludes = new String[excludes.length + DirectoryScanner.DEFAULTEXCLUDES.length];
        System.arraycopy(DirectoryScanner.DEFAULTEXCLUDES, 0, newExcludes, 0, DirectoryScanner.DEFAULTEXCLUDES.length);
        System.arraycopy(excludes, 0, newExcludes, DirectoryScanner.DEFAULTEXCLUDES.length, excludes.length);
        return newExcludes;
    }
}

