/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.CSharpNetCoreReducedClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsharpNetcoreFunctionsServerCodegen
extends CSharpNetCoreReducedClientCodegen {
    public static final String PROJECT_NAME = "projectName";
    final Logger LOGGER = LoggerFactory.getLogger(CsharpNetcoreFunctionsServerCodegen.class);

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "csharp-netcore-functions";
    }

    @Override
    public String getHelp() {
        return "Generates a csharp server.";
    }

    public CsharpNetcoreFunctionsServerCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "csharp";
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("functions.mustache", ".cs");
        this.templateDir = "csharp-netcore-functions";
        this.embeddedTemplateDir = "csharp-netcore-functions";
        this.apiPackage = "Apis";
        this.modelPackage = "Models";
        String clientPackageDir = "generatedSrc/Client";
        this.supportingFiles.add(new SupportingFile("README.mustache", "generatedSrc", "README.md"));
        this.supportingFiles.add(new SupportingFile("project.mustache", "generatedSrc", "project.json"));
        this.supportingFiles.add(new SupportingFile("IApiAccessor.mustache", clientPackageDir, "IApiAccessor.cs"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", clientPackageDir, "Configuration.cs"));
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", clientPackageDir, "ApiClient.cs"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", clientPackageDir, "ApiException.cs"));
        this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", clientPackageDir, "ApiResponse.cs"));
        this.supportingFiles.add(new SupportingFile("ExceptionFactory.mustache", clientPackageDir, "ExceptionFactory.cs"));
        this.supportingFiles.add(new SupportingFile("OpenAPIDateConverter.mustache", clientPackageDir, "OpenAPIDateConverter.cs"));
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + "generatedSrc" + File.separator + "Functions";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + "generatedSrc" + File.separator + "Models";
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/Docs").replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + "Tests" + File.separator + "Tests" + File.separator + this.apiPackage();
    }
}

