/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.templating.mustache.IndentedLambda;
import org.openapitools.codegen.utils.ModelUtils;

public class TypeScriptFetchClientCodegen
extends AbstractTypeScriptClientCodegen {
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String WITH_INTERFACES = "withInterfaces";
    public static final String USE_SINGLE_REQUEST_PARAMETER = "useSingleRequestParameter";
    public static final String PREFIX_PARAMETER_INTERFACES = "prefixParameterInterfaces";
    public static final String WITHOUT_RUNTIME_CHECKS = "withoutRuntimeChecks";
    public static final String STRING_ENUMS = "stringEnums";
    public static final String STRING_ENUMS_DESC = "Generate string enums instead of objects for enum values.";
    public static final String IMPORT_FILE_EXTENSION_SWITCH = "importFileExtension";
    public static final String IMPORT_FILE_EXTENSION_SWITCH_DESC = "File extension to use with relative imports. Set it to '.js' or '.mjs' when using [ESM](https://nodejs.org/api/esm.html).";
    protected String npmRepository = null;
    protected String importFileExtension = "";
    private boolean useSingleRequestParameter = true;
    private boolean prefixParameterInterfaces = false;
    protected boolean addedApiIndex = false;
    protected boolean addedModelIndex = false;
    protected boolean withoutRuntimeChecks = false;
    protected boolean stringEnums = false;
    public static final String SAGAS_AND_RECORDS = "sagasAndRecords";
    public static final String DETECT_PASSTHROUGH_MODELS_WITH_SUFFIX_AND_FIELD = "detectPassthroughModelsWithSuffixAndField";
    public static final String INFER_UNIQUE_ID_FROM_NAME_SUFFIX = "inferUniqueIdFromNameSuffix";
    public static final String INFER_ENTITY_FROM_UNIQUE_ID_WITH_NAME = "inferEntityFromUniqueIdWithName";
    public static final String PACKAGE_AS_SOURCE_ONLY_LIBRARY = "packageAsSourceOnlyLibrary";
    private static final String X_IS_UNIQUE_ID = "x-isUniqueId";
    private static final String X_ENTITY_ID = "x-entityId";
    private static final String X_OPERATION_RETURN_PASSTHROUGH = "x-operationReturnPassthrough";
    private static final String X_KEEP_AS_JS_OBJECT = "x-keepAsJSObject";
    protected boolean sagasAndRecords = false;
    protected String detectPassthroughModelsWithSuffixAndField = null;
    protected boolean inferUniqueIdFromNameSuffix = false;
    protected String inferEntityFromUniqueIdWithName = null;
    protected boolean packageAsSourceOnlyLibrary = false;

    public TypeScriptFetchClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BearerToken}));
        this.importMapping.clear();
        this.outputFolder = "generated-code/typescript-fetch";
        this.templateDir = "typescript-fetch";
        this.embeddedTemplateDir = "typescript-fetch";
        this.apiTemplateFiles.put("apis.mustache", ".ts");
        this.addExtraReservedWords();
        this.supportModelPropertyNaming(CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.camelCase);
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(USE_SINGLE_REQUEST_PARAMETER, "Setting this property to true will generate functions with a single argument containing all API endpoint parameters instead of one argument per parameter.", "boolean").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption(PREFIX_PARAMETER_INTERFACES, "Setting this property to true will generate parameter interface declarations prefixed with API class name to avoid name conflicts.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(WITHOUT_RUNTIME_CHECKS, "Setting this property to true will remove any runtime checks on the request and response payloads. Payloads will be casted to their expected types.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(SAGAS_AND_RECORDS, "Setting this property to true will generate additional files for use with redux-saga and immutablejs.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(STRING_ENUMS, STRING_ENUMS_DESC, "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(IMPORT_FILE_EXTENSION_SWITCH, IMPORT_FILE_EXTENSION_SWITCH_DESC).defaultValue(""));
    }

    @Override
    public String getName() {
        return "typescript-fetch";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library using Fetch API (beta).";
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    public String getImportFileExtension() {
        return this.importFileExtension;
    }

    public void setImportFileExtension(String importFileExtension) {
        this.importFileExtension = importFileExtension;
    }

    public Boolean getWithoutRuntimeChecks() {
        return this.withoutRuntimeChecks;
    }

    public void setWithoutRuntimeChecks(Boolean withoutRuntimeChecks) {
        this.withoutRuntimeChecks = withoutRuntimeChecks;
    }

    public Boolean getStringEnums() {
        return this.stringEnums;
    }

    public void setStringEnums(Boolean stringEnums) {
        this.stringEnums = stringEnums;
    }

    public Boolean getSagasAndRecords() {
        return this.sagasAndRecords;
    }

    public void setSagasAndRecords(Boolean sagasAndRecords) {
        this.sagasAndRecords = sagasAndRecords;
    }

    public String getPassthroughSuffix() {
        return this.detectPassthroughModelsWithSuffixAndField != null ? this.detectPassthroughModelsWithSuffixAndField.split("\\.")[0] : null;
    }

    public String getPassthroughField() {
        return this.detectPassthroughModelsWithSuffixAndField != null ? this.detectPassthroughModelsWithSuffixAndField.split("\\.")[1] : null;
    }

    public String getDetectPassthroughModelsWithSuffixAndField() {
        return this.detectPassthroughModelsWithSuffixAndField;
    }

    public void setDetectPassthroughModelsWithSuffixAndField(String detectPassthroughModelsWithSuffixAndField) {
        this.detectPassthroughModelsWithSuffixAndField = detectPassthroughModelsWithSuffixAndField;
    }

    public boolean getInferUniqueIdFromNameSuffix() {
        return this.inferUniqueIdFromNameSuffix;
    }

    public void setInferUniqueIdFromNameSuffix(boolean inferUniqueIdFromNameSuffix) {
        this.inferUniqueIdFromNameSuffix = inferUniqueIdFromNameSuffix;
    }

    public String getInferEntityFromUniqueIdWithName() {
        return this.inferEntityFromUniqueIdWithName;
    }

    public void setInferEntityFromUniqueIdWithName(String inferEntityFromUniqueIdWithName) {
        this.inferEntityFromUniqueIdWithName = inferEntityFromUniqueIdWithName;
    }

    public boolean getPackageAsSourceOnlyLibrary() {
        return this.packageAsSourceOnlyLibrary;
    }

    public void setPackageAsSourceOnlyLibrary(boolean packageAsSourceOnlyLibrary) {
        this.packageAsSourceOnlyLibrary = packageAsSourceOnlyLibrary;
    }

    public boolean isUniqueIdAccordingToNameSuffix(String name) {
        if (name == null) {
            return false;
        }
        return "id".equals(name) || "ids".equals(name) || name.length() >= 3 && name.endsWith("Id") || name.length() >= 4 && name.endsWith("Ids");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.additionalProperties.put("isOriginalModelPropertyNaming", this.getModelPropertyNaming() == CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.original);
        this.additionalProperties.put("modelPropertyNaming", this.getModelPropertyNaming().name());
        Object sourceDir = "";
        if (this.additionalProperties.containsKey("npmName")) {
            sourceDir = "src" + File.separator;
        }
        this.apiPackage = (String)sourceDir + "apis";
        this.modelPackage = (String)sourceDir + "models";
        this.supportingFiles.add(new SupportingFile("index.mustache", (String)sourceDir, "index.ts"));
        this.supportingFiles.add(new SupportingFile("runtime.mustache", (String)sourceDir, "runtime.ts"));
        if (this.additionalProperties.containsKey(IMPORT_FILE_EXTENSION_SWITCH)) {
            this.setImportFileExtension(this.additionalProperties.get(IMPORT_FILE_EXTENSION_SWITCH).toString());
        }
        this.writePropertyBack(IMPORT_FILE_EXTENSION_SWITCH, this.getImportFileExtension());
        if (this.additionalProperties.containsKey(USE_SINGLE_REQUEST_PARAMETER)) {
            this.setUseSingleRequestParameter(this.convertPropertyToBoolean(USE_SINGLE_REQUEST_PARAMETER));
        }
        this.writePropertyBack(USE_SINGLE_REQUEST_PARAMETER, this.getUseSingleRequestParameter());
        if (this.additionalProperties.containsKey(PREFIX_PARAMETER_INTERFACES)) {
            this.setPrefixParameterInterfaces(this.convertPropertyToBoolean(PREFIX_PARAMETER_INTERFACES));
        }
        this.writePropertyBack(PREFIX_PARAMETER_INTERFACES, this.getPrefixParameterInterfaces());
        if (this.additionalProperties.containsKey("npmName")) {
            this.addNpmPackageGeneration();
        }
        if (this.additionalProperties.containsKey(WITHOUT_RUNTIME_CHECKS)) {
            this.setWithoutRuntimeChecks(this.convertPropertyToBoolean(WITHOUT_RUNTIME_CHECKS));
        }
        if (this.additionalProperties.containsKey(STRING_ENUMS)) {
            this.setStringEnums(this.convertPropertyToBoolean(STRING_ENUMS));
        }
        if (!this.withoutRuntimeChecks) {
            this.modelTemplateFiles.put("models.mustache", ".ts");
            this.typeMapping.put("date", "Date");
            this.typeMapping.put("DateTime", "Date");
        }
        if (this.additionalProperties.containsKey(SAGAS_AND_RECORDS)) {
            this.setSagasAndRecords(this.convertPropertyToBoolean(SAGAS_AND_RECORDS));
            if (this.getSagasAndRecords().booleanValue()) {
                this.apiTemplateFiles.put("sagas.mustache", "Sagas.ts");
                this.modelTemplateFiles.put("records.mustache", "Record.ts");
                this.supportingFiles.add(new SupportingFile("runtimeSagasAndRecords.mustache", (String)sourceDir, "runtimeSagasAndRecords.ts"));
                this.supportingFiles.add(new SupportingFile("ApiEntitiesRecord.mustache", (String)sourceDir, "ApiEntitiesRecord.ts"));
                this.supportingFiles.add(new SupportingFile("ApiEntitiesReducer.mustache", (String)sourceDir, "ApiEntitiesReducer.ts"));
                this.supportingFiles.add(new SupportingFile("ApiEntitiesSelectors.mustache", (String)sourceDir, "ApiEntitiesSelectors.ts"));
                if (this.additionalProperties.containsKey(DETECT_PASSTHROUGH_MODELS_WITH_SUFFIX_AND_FIELD)) {
                    this.setDetectPassthroughModelsWithSuffixAndField((String)this.additionalProperties.get(DETECT_PASSTHROUGH_MODELS_WITH_SUFFIX_AND_FIELD));
                }
                if (this.additionalProperties.containsKey(INFER_UNIQUE_ID_FROM_NAME_SUFFIX)) {
                    this.setInferUniqueIdFromNameSuffix(this.convertPropertyToBoolean(INFER_UNIQUE_ID_FROM_NAME_SUFFIX));
                }
                if (this.additionalProperties.containsKey(INFER_ENTITY_FROM_UNIQUE_ID_WITH_NAME)) {
                    this.setInferEntityFromUniqueIdWithName((String)this.additionalProperties.get(INFER_ENTITY_FROM_UNIQUE_ID_WITH_NAME));
                }
                if (this.additionalProperties.containsKey(PACKAGE_AS_SOURCE_ONLY_LIBRARY)) {
                    this.setPackageAsSourceOnlyLibrary(this.convertPropertyToBoolean(PACKAGE_AS_SOURCE_ONLY_LIBRARY));
                }
                this.addExtraReservedWordsForSagasAndRecords();
                if (this.getPackageAsSourceOnlyLibrary()) {
                    this.supportingFiles.add(new SupportingFile("sourceLibraryIndex.mustache", "", "index.ts"));
                }
            }
        }
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        if (this.getSagasAndRecords().booleanValue()) {
            return datatype + "." + value;
        }
        return super.toEnumDefaultValue(value, datatype);
    }

    @Override
    protected String getEnumDefaultValue(String defaultValue, String dataType) {
        if (this.getSagasAndRecords().booleanValue()) {
            return defaultValue;
        }
        return super.getEnumDefaultValue(defaultValue, dataType);
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        ImmutableMap.Builder<String, Mustache.Lambda> lambdas = super.addMustacheLambdas();
        lambdas.put((Object)"indented_star_1", (Object)new IndentedLambda(1, " ", "* ", false, false));
        lambdas.put((Object)"indented_star_4", (Object)new IndentedLambda(5, " ", "* ", false, false));
        return lambdas;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isFileSchema(p)) {
            return "Blob";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return "Blob";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(ModelUtils.getAdditionalProperties(schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        List<ModelMap> models = this.postProcessModelsEnum(objs).getModels();
        for (ModelMap mo : models) {
            ExtendedCodegenModel cm = (ExtendedCodegenModel)mo.getModel();
            cm.imports = new TreeSet(cm.imports);
            this.processCodeGenModel(cm);
        }
        return objs;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        if (parameter.isFormParam && parameter.isArray && "binary".equals(parameter.dataFormat)) {
            parameter.isCollectionFormatMulti = true;
        }
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        ArrayList<ExtendedCodegenModel> allModels = new ArrayList<ExtendedCodegenModel>();
        ArrayList<String> entityModelClassnames = new ArrayList<String>();
        Map<String, ModelsMap> result = super.postProcessAllModels(objs);
        for (ModelsMap entry : result.values()) {
            for (ModelMap model : entry.getModels()) {
                ExtendedCodegenModel codegenModel = (ExtendedCodegenModel)model.getModel();
                model.put("hasImports", codegenModel.imports.size() > 0);
                allModels.add(codegenModel);
                if (!codegenModel.isEntity) continue;
                entityModelClassnames.add(codegenModel.classname);
            }
        }
        for (ExtendedCodegenModel rootModel : allModels) {
            for (String curImport : rootModel.imports) {
                boolean isModelImport = false;
                for (ExtendedCodegenModel model : allModels) {
                    if (!model.classname.equals(curImport) || model.isEnum) continue;
                    isModelImport = true;
                    break;
                }
                if (!isModelImport) continue;
                rootModel.modelImports.add(curImport);
            }
            for (CodegenProperty cpVar : rootModel.vars) {
                ExtendedCodegenProperty var = (ExtendedCodegenProperty)cpVar;
                if (var.isModel && entityModelClassnames.indexOf(var.dataType) != -1) {
                    var.isEntity = true;
                    continue;
                }
                if (!var.isArray || !var.items.isModel || entityModelClassnames.indexOf(var.items.dataType) == -1) continue;
                ((ExtendedCodegenProperty)var.items).isEntity = true;
            }
        }
        return result;
    }

    private void autoSetDefaultValueForProperty(ExtendedCodegenProperty var) {
        if (var.isArray || var.isModel) {
            var.defaultValue = var.dataTypeAlternate + "()";
        } else if (var.isUniqueId) {
            var.defaultValue = "\"-1\"";
        } else if (var.isEnum) {
            var.defaultValue = "'" + (String)var._enum.get(0) + "'";
            this.updateCodegenPropertyEnum(var);
        } else if (var.dataType.equalsIgnoreCase("string")) {
            var.defaultValue = "\"\"";
        } else if (var.dataType.equalsIgnoreCase("number")) {
            var.defaultValue = "0";
        } else if (var.dataType.equalsIgnoreCase("boolean")) {
            var.defaultValue = "false";
        } else if (var.allowableValues != null && var.allowableValues.get("enumVars") instanceof ArrayList && ((ArrayList)var.allowableValues.get("enumVars")).get(0) instanceof HashMap) {
            var.defaultValue = var.dataTypeAlternate + "." + (String)((HashMap)((ArrayList)var.allowableValues.get("enumVars")).get(0)).get("name");
        }
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
        if (this.supportsES6.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("tsconfig.esm.mustache", "", "tsconfig.esm.json"));
        }
        this.supportingFiles.add(new SupportingFile("npmignore.mustache", "", ".npmignore"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
    }

    @Override
    public List<CodegenParameter> fromRequestBodyToFormParameters(RequestBody body, Set<String> imports) {
        List<CodegenParameter> superParams = super.fromRequestBodyToFormParameters(body, imports);
        ArrayList<CodegenParameter> extendedParams = new ArrayList<CodegenParameter>();
        for (CodegenParameter cp : superParams) {
            extendedParams.add(new ExtendedCodegenParameter(cp));
        }
        return extendedParams;
    }

    @Override
    public ExtendedCodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        CodegenParameter cp = super.fromParameter(parameter, imports);
        return new ExtendedCodegenParameter(cp);
    }

    @Override
    public CodegenParameter fromFormProperty(String name, Schema propertySchema, Set<String> imports) {
        CodegenParameter cp = super.fromFormProperty(name, propertySchema, imports);
        return new ExtendedCodegenParameter(cp);
    }

    @Override
    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        CodegenParameter cp = super.fromRequestBody(body, imports, bodyParameterName);
        return new ExtendedCodegenParameter(cp);
    }

    @Override
    public ExtendedCodegenProperty fromProperty(String name, Schema p, boolean required) {
        CodegenProperty cp = super.fromProperty(name, p, required);
        return new ExtendedCodegenProperty(cp);
    }

    @Override
    public ExtendedCodegenModel fromModel(String name, Schema model) {
        CodegenModel cm = super.fromModel(name, model);
        return new ExtendedCodegenModel(cm);
    }

    @Override
    public ExtendedCodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        ApiResponse methodResponse;
        CodegenOperation superOp = super.fromOperation(path, httpMethod, operation, servers);
        ExtendedCodegenOperation op = new ExtendedCodegenOperation(superOp);
        if (this.getSagasAndRecords().booleanValue() && (methodResponse = this.findMethodResponse(operation.getResponses())) != null) {
            Map<String, Schema> schemas = ModelUtils.getSchemas(this.openAPI);
            Schema schema = null;
            if (schemas != null) {
                schema = schemas.get(op.returnBaseType);
            }
            ExtendedCodegenModel cm = null;
            if (schema != null) {
                boolean foundMatch;
                cm = this.fromModel(op.returnBaseType, schema);
                Object returnPassthrough = cm.vendorExtensions.get(X_OPERATION_RETURN_PASSTHROUGH);
                if (returnPassthrough instanceof String) {
                    if (((String)returnPassthrough).isEmpty()) {
                        op.hasReturnPassthroughVoid = true;
                        op.returnPassthrough = null;
                    } else {
                        foundMatch = false;
                        for (CodegenProperty var : cm.vars) {
                            if (!var.name.equals(returnPassthrough)) continue;
                            foundMatch = true;
                            break;
                        }
                        if (foundMatch) {
                            op.returnPassthrough = (String)returnPassthrough;
                        } else {
                            op.hasReturnPassthroughVoid = true;
                            op.returnPassthrough = null;
                        }
                    }
                } else if (this.getDetectPassthroughModelsWithSuffixAndField() != null && op.returnBaseType.length() > this.getPassthroughSuffix().length() && op.returnBaseType.endsWith(this.getPassthroughSuffix())) {
                    foundMatch = false;
                    for (CodegenProperty var : cm.vars) {
                        if (!var.name.equals(this.getPassthroughField())) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) {
                        op.returnPassthrough = this.getPassthroughField();
                    } else {
                        op.hasReturnPassthroughVoid = true;
                        op.returnPassthrough = null;
                    }
                }
            }
            if (!op.hasReturnPassthroughVoid) {
                Schema responseSchema = this.unaliasSchema(ModelUtils.getSchemaFromResponse(this.openAPI, methodResponse));
                ExtendedCodegenProperty cp = null;
                if (op.returnPassthrough instanceof String && cm != null) {
                    cp = (ExtendedCodegenProperty)this.processCodeGenModel((ExtendedCodegenModel)cm).vars.get(1);
                } else if (responseSchema != null) {
                    cp = this.fromProperty("response", responseSchema, false);
                    this.processCodegenProperty(cp, "", null);
                }
                op.returnBaseTypeAlternate = null;
                if (cp != null) {
                    op.returnTypeAlternate = cp.dataTypeAlternate;
                    op.returnTypeIsModel = cp.isModel;
                    op.returnTypeIsArray = cp.isArray;
                    if (cp.isArray) {
                        if (cp.items.isModel) {
                            op.returnTypeSupportsEntities = true;
                            op.returnBaseTypeAlternate = cp.items.dataType + "Record";
                        } else if (cp.items.allowableValues != null) {
                            op.returnBaseTypeAlternate = cp.items.dataType;
                        }
                    } else if (cp.isModel) {
                        op.returnTypeSupportsEntities = true;
                        op.returnBaseTypeAlternate = cp.dataTypeAlternate;
                    } else if (cp.allowableValues != null) {
                        op.returnBaseTypeAlternate = cp.dataTypeAlternate;
                    }
                }
            }
        }
        return op;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.getSagasAndRecords().booleanValue()) {
            if (this.reservedWordsMappings().containsKey(name)) {
                return this.reservedWordsMappings().get(name);
            }
            return "_" + name;
        }
        return super.escapeReservedWord(name);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap operations, List<ModelMap> allModels) {
        if (!operations.isEmpty() && !this.addedApiIndex) {
            this.addedApiIndex = true;
            this.supportingFiles.add(new SupportingFile("apis.index.mustache", this.apiPackage().replace('.', File.separatorChar), "index.ts"));
            if (this.getSagasAndRecords().booleanValue()) {
                this.supportingFiles.add(new SupportingFile("sagaApiManager.mustache", this.apiPackage().replace('.', File.separatorChar), "SagaApiManager.ts"));
                this.supportingFiles.add(new SupportingFile("allSagas.mustache", this.apiPackage().replace('.', File.separatorChar), "allSagas.ts"));
            }
        }
        if (!allModels.isEmpty() && !this.addedModelIndex) {
            this.addedModelIndex = true;
            this.supportingFiles.add(new SupportingFile("models.index.mustache", this.modelPackage().replace('.', File.separatorChar), "index.ts"));
        }
        this.addOperationModelImportInformation(operations);
        this.updateOperationParameterForEnum(operations);
        if (this.getSagasAndRecords().booleanValue()) {
            this.updateOperationParameterForSagaAndRecords(operations);
        }
        this.addOperationObjectResponseInformation(operations);
        this.addOperationPrefixParameterInterfacesInformation(operations);
        this.escapeOperationIds(operations);
        return operations;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Map<String, Object> parentObjs = super.postProcessSupportingFileData(objs);
        parentObjs.put("useSagaAndRecords", this.getSagasAndRecords());
        return parentObjs;
    }

    private ExtendedCodegenModel processCodeGenModel(ExtendedCodegenModel cm) {
        ExtendedCodegenProperty var;
        block19: {
            block17: {
                block18: {
                    if (!this.getSagasAndRecords().booleanValue()) break block17;
                    Iterator<Object> xEntityId = cm.vendorExtensions.get(X_ENTITY_ID);
                    if (xEntityId == null && this.getInferEntityFromUniqueIdWithName() != null) {
                        xEntityId = this.getInferEntityFromUniqueIdWithName();
                    }
                    Object vendorKeepAsJSObject = cm.vendorExtensions.get(X_KEEP_AS_JS_OBJECT);
                    String[] propertiesToKeepAsJSObject = null;
                    if (vendorKeepAsJSObject instanceof String) {
                        propertiesToKeepAsJSObject = ((String)vendorKeepAsJSObject).split(",");
                    }
                    for (CodegenProperty cpVar : cm.vars) {
                        boolean parentIsEntity;
                        ExtendedCodegenProperty var2 = (ExtendedCodegenProperty)cpVar;
                        if (propertiesToKeepAsJSObject != null && Arrays.asList(propertiesToKeepAsJSObject).contains(var2.name)) {
                            var2.keepAsJSObject = true;
                        }
                        if (!(parentIsEntity = this.processCodegenProperty(var2, cm.classname, xEntityId))) continue;
                        cm.isEntity = true;
                    }
                    Object returnPassthrough = cm.vendorExtensions.get(X_OPERATION_RETURN_PASSTHROUGH);
                    if (!(returnPassthrough instanceof String)) break block18;
                    if (((String)returnPassthrough).isEmpty()) {
                        cm.hasReturnPassthroughVoid = true;
                        cm.returnPassthrough = null;
                    } else {
                        boolean foundMatch = false;
                        for (CodegenProperty var3 : cm.vars) {
                            if (!var3.name.equals(returnPassthrough)) continue;
                            foundMatch = true;
                            break;
                        }
                        if (foundMatch) {
                            cm.returnPassthrough = (String)returnPassthrough;
                        } else {
                            cm.hasReturnPassthroughVoid = true;
                            cm.returnPassthrough = null;
                        }
                    }
                    break block19;
                }
                if (this.getDetectPassthroughModelsWithSuffixAndField() == null || cm.name.length() <= this.getPassthroughSuffix().length() || !cm.name.endsWith(this.getPassthroughSuffix())) break block19;
                boolean foundMatch = false;
                for (CodegenProperty var4 : cm.vars) {
                    if (!var4.name.equals(this.getPassthroughField())) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) {
                    cm.returnPassthrough = this.getPassthroughField();
                } else {
                    cm.hasReturnPassthroughVoid = true;
                    cm.returnPassthrough = null;
                }
                break block19;
            }
            for (CodegenProperty cpVar : cm.vars) {
                var = (ExtendedCodegenProperty)cpVar;
                this.processCodegenProperty(var, cm.classname, null);
            }
        }
        if (cm.parent != null) {
            for (CodegenProperty cpVar : cm.allVars) {
                var = (ExtendedCodegenProperty)cpVar;
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
        }
        if (!cm.oneOf.isEmpty()) {
            TreeSet<String> oneOfRefs = new TreeSet<String>();
            for (String im : cm.imports) {
                if (!cm.oneOf.contains(im)) continue;
                oneOfRefs.add(im);
            }
            cm.imports = oneOfRefs;
        }
        return cm;
    }

    private boolean processCodegenProperty(ExtendedCodegenProperty var, String parentClassName, Object xEntityId) {
        if (Boolean.TRUE.equals(var.isEnum)) {
            int dotPos;
            var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, parentClassName + var.enumName);
            if (var.defaultValue != null && !var.defaultValue.equals("undefined") && (dotPos = var.defaultValue.indexOf(".")) != -1) {
                var.defaultValue = var.datatypeWithEnum + var.defaultValue.substring(dotPos);
            }
        }
        boolean parentIsEntity = false;
        if (this.getSagasAndRecords().booleanValue()) {
            if (var.vendorExtensions.get(X_IS_UNIQUE_ID) instanceof Boolean) {
                var.isUniqueId = Boolean.TRUE.equals(var.vendorExtensions.get(X_IS_UNIQUE_ID));
            } else if (this.getInferUniqueIdFromNameSuffix() && var.isArray && "number".equals(var.items.dataType) || "number".equals(var.dataType)) {
                var.isUniqueId = this.isUniqueIdAccordingToNameSuffix(var.name);
            }
            if (var.isUniqueId && xEntityId != null && xEntityId.equals(var.name)) {
                parentIsEntity = true;
            }
            var.dataTypeAlternate = var.dataType;
            if (var.isArray) {
                var.isUniqueId = var.isUniqueId || var.itemsAreUniqueId();
                var.dataTypeAlternate = var.dataType.replace("Array<", "List<");
                Object newItemsDataType = var.getItemsDataType();
                if (var.items.isModel) {
                    newItemsDataType = var.items.dataType + "Record";
                    var.dataTypeAlternate = var.dataTypeAlternate.replace(var.items.dataType, (CharSequence)newItemsDataType);
                } else if (var.items.isEnum) {
                    newItemsDataType = var.items.datatypeWithEnum;
                    var.dataTypeAlternate = var.dataTypeAlternate.replace(var.items.dataType, (CharSequence)newItemsDataType);
                } else if (var.isUniqueId) {
                    newItemsDataType = "string";
                    var.dataTypeAlternate = var.dataTypeAlternate.replace("number", (CharSequence)newItemsDataType);
                }
                if (var.itemsAreNullable()) {
                    var.dataTypeAlternate = var.dataTypeAlternate.replace((CharSequence)newItemsDataType, (String)newItemsDataType + " | null");
                }
            } else if (var.isEnum) {
                var.dataTypeAlternate = var.datatypeWithEnum;
            } else if (var.isModel) {
                var.dataTypeAlternate = var.dataType + "Record";
            } else if (var.isUniqueId) {
                var.dataTypeAlternate = "string";
                if (var.isNullable) {
                    var.dataTypeAlternate = var.dataTypeAlternate + " | null";
                }
            }
            if (var.defaultValue == null || var.defaultValue.equals("undefined")) {
                this.autoSetDefaultValueForProperty(var);
            }
        }
        return parentIsEntity;
    }

    private boolean itemsAreNullable(ExtendedCodegenProperty var) {
        return var.items.isNullable || var.items.items != null && var.items.items.isNullable;
    }

    private void escapeOperationIds(OperationsMap operations) {
        for (CodegenOperation _op : operations.getOperations().getOperation()) {
            ExtendedCodegenOperation op = (ExtendedCodegenOperation)_op;
            String param = op.operationIdCamelCase + "Request";
            if (!op.imports.contains(param)) continue;
            op.operationIdCamelCase = op.operationIdCamelCase + "Operation";
            op.operationIdLowerCase = op.operationIdLowerCase + "operation";
            op.operationIdSnakeCase = op.operationIdSnakeCase + "_operation";
        }
    }

    private void addOperationModelImportInformation(OperationsMap operations) {
        List<Map<String, String>> imports = operations.getImports();
        ArrayList<CallSite> existingRecordClassNames = new ArrayList<CallSite>();
        ArrayList<String> existingClassNames = new ArrayList<String>();
        for (Map<String, String> im : imports) {
            String className = im.get("import").replace(this.modelPackage() + ".", "");
            existingClassNames.add(className);
            existingRecordClassNames.add((CallSite)((Object)(className + "Record")));
            im.put("className", className);
        }
        if (this.getSagasAndRecords().booleanValue()) {
            TreeSet<String> additionalPassthroughImports = new TreeSet<String>();
            for (CodegenOperation _op : operations.getOperations().getOperation()) {
                ExtendedCodegenOperation op = (ExtendedCodegenOperation)_op;
                if (op.returnPassthrough == null || op.returnBaseTypeAlternate == null) continue;
                if (op.returnTypeSupportsEntities && !existingRecordClassNames.contains(op.returnBaseTypeAlternate)) {
                    additionalPassthroughImports.add(op.returnBaseTypeAlternate);
                    continue;
                }
                if (op.returnTypeSupportsEntities || existingClassNames.contains(op.returnBaseTypeAlternate)) continue;
                additionalPassthroughImports.add(op.returnBaseTypeAlternate);
            }
            operations.put("passthroughImports", additionalPassthroughImports);
            operations.put("hasPassthroughImports", additionalPassthroughImports.size() > 0);
        }
    }

    private void updateOperationParameterForEnum(OperationsMap operations) {
        boolean hasEnum = false;
        for (CodegenOperation _op : operations.getOperations().getOperation()) {
            ExtendedCodegenOperation op = (ExtendedCodegenOperation)_op;
            for (CodegenParameter cpParam : op.allParams) {
                ExtendedCodegenParameter param = (ExtendedCodegenParameter)cpParam;
                if (!Boolean.TRUE.equals(param.isEnum)) continue;
                hasEnum = true;
                param.datatypeWithEnum = param.datatypeWithEnum.replace(param.enumName, op.operationIdCamelCase + param.enumName);
            }
        }
        operations.put("hasEnums", hasEnum);
    }

    private void updateOperationParameterForSagaAndRecords(OperationsMap operations) {
        for (CodegenOperation _op : operations.getOperations().getOperation()) {
            ExtendedCodegenOperation op = (ExtendedCodegenOperation)_op;
            for (CodegenParameter cpParam : op.allParams) {
                ExtendedCodegenParameter param = (ExtendedCodegenParameter)cpParam;
                if (param.vendorExtensions.get(X_IS_UNIQUE_ID) instanceof Boolean) {
                    param.isUniqueId = Boolean.TRUE.equals(param.vendorExtensions.get(X_IS_UNIQUE_ID));
                } else if (this.getInferUniqueIdFromNameSuffix() && param.isArray && "number".equals(param.items.dataType) || "number".equals(param.dataType)) {
                    param.isUniqueId = this.isUniqueIdAccordingToNameSuffix(param.paramName);
                }
                param.dataTypeAlternate = param.dataType;
                if (param.isArray) {
                    param.isUniqueId = param.isUniqueId || param.itemsAreUniqueId();
                    param.dataTypeAlternate = param.dataType.replace("Array<", "List<");
                    Object newItemsDataType = param.getItemsDataType();
                    if (param.items.isModel) {
                        newItemsDataType = param.items.dataType + "Record";
                        param.dataTypeAlternate = param.dataTypeAlternate.replace(param.items.dataType, (CharSequence)newItemsDataType);
                    } else if (param.items.isEnum) {
                        newItemsDataType = param.datatypeWithEnum.substring(param.datatypeWithEnum.lastIndexOf("<") + 1, param.datatypeWithEnum.indexOf(">"));
                        param.dataTypeAlternate = param.datatypeWithEnum.replace("Array<", "List<");
                    } else if (param.isUniqueId) {
                        newItemsDataType = "string";
                        param.dataTypeAlternate = param.dataTypeAlternate.replace("number", (CharSequence)newItemsDataType);
                    }
                    if (!param.itemsAreNullable()) continue;
                    param.dataTypeAlternate = param.dataTypeAlternate.replace((CharSequence)newItemsDataType, (String)newItemsDataType + " | null");
                    continue;
                }
                if (param.isEnum) {
                    param.dataTypeAlternate = param.datatypeWithEnum;
                    continue;
                }
                if (param.isModel) {
                    param.dataTypeAlternate = param.dataType + "Record";
                    continue;
                }
                if (!param.isUniqueId) continue;
                param.dataTypeAlternate = "string";
                if (!param.isNullable) continue;
                param.dataTypeAlternate = param.dataTypeAlternate + " | null";
            }
        }
    }

    private void addOperationObjectResponseInformation(OperationsMap operations) {
        for (CodegenOperation _op : operations.getOperations().getOperation()) {
            ExtendedCodegenOperation op = (ExtendedCodegenOperation)_op;
            if (!"object".equals(op.returnType)) continue;
            op.isMap = true;
            op.returnSimpleType = false;
        }
    }

    private void addOperationPrefixParameterInterfacesInformation(Map<String, Object> operations) {
        operations.put(PREFIX_PARAMETER_INTERFACES, this.getPrefixParameterInterfaces());
    }

    private void addExtraReservedWords() {
        this.reservedWords.add("BASE_PATH");
        this.reservedWords.add("BaseAPI");
        this.reservedWords.add("RequiredError");
        this.reservedWords.add("COLLECTION_FORMATS");
        this.reservedWords.add("FetchAPI");
        this.reservedWords.add("ConfigurationParameters");
        this.reservedWords.add("Configuration");
        this.reservedWords.add("configuration");
        this.reservedWords.add("HTTPMethod");
        this.reservedWords.add("HTTPHeaders");
        this.reservedWords.add("HTTPQuery");
        this.reservedWords.add("HTTPBody");
        this.reservedWords.add("ModelPropertyNaming");
        this.reservedWords.add("FetchParams");
        this.reservedWords.add("RequestOpts");
        this.reservedWords.add("exists");
        this.reservedWords.add("RequestContext");
        this.reservedWords.add("ResponseContext");
        this.reservedWords.add("Middleware");
        this.reservedWords.add("ApiResponse");
        this.reservedWords.add("ResponseTransformer");
        this.reservedWords.add("JSONApiResponse");
        this.reservedWords.add("VoidApiResponse");
        this.reservedWords.add("BlobApiResponse");
        this.reservedWords.add("TextApiResponse");
        this.reservedWords.add("Index");
    }

    private void addExtraReservedWordsForSagasAndRecords() {
        this.reservedWords.add("entries");
    }

    private boolean getUseSingleRequestParameter() {
        return this.useSingleRequestParameter;
    }

    private void setUseSingleRequestParameter(boolean useSingleRequestParameter) {
        this.useSingleRequestParameter = useSingleRequestParameter;
    }

    private boolean getPrefixParameterInterfaces() {
        return this.prefixParameterInterfaces;
    }

    private void setPrefixParameterInterfaces(boolean prefixParameterInterfaces) {
        this.prefixParameterInterfaces = prefixParameterInterfaces;
    }

    private static boolean itemsAreUniqueId(CodegenProperty items) {
        if (items != null && items.items != null) {
            return TypeScriptFetchClientCodegen.itemsAreUniqueId(items.items);
        }
        if (items != null && items.vendorExtensions.get(X_IS_UNIQUE_ID) instanceof Boolean) {
            return Boolean.TRUE.equals(items.vendorExtensions.get(X_IS_UNIQUE_ID));
        }
        return false;
    }

    private static boolean itemsAreNullable(CodegenProperty items) {
        if (items == null) {
            return true;
        }
        if (items.items != null) {
            return TypeScriptFetchClientCodegen.itemsAreNullable(items.items);
        }
        return items.isNullable;
    }

    private static String getItemsDataType(CodegenProperty items) {
        if (items == null) {
            return null;
        }
        if (items.items != null) {
            return TypeScriptFetchClientCodegen.getItemsDataType(items.items);
        }
        return items.dataType;
    }

    class ExtendedCodegenModel
    extends CodegenModel {
        public Set<String> modelImports = new TreeSet<String>();
        public boolean isEntity;
        public String returnPassthrough;
        public boolean hasReturnPassthroughVoid;

        public boolean isDateType() {
            return this.isDate && "Date".equals(this.dataType);
        }

        public boolean isDateTimeType() {
            return this.isDateTime && "Date".equals(this.dataType);
        }

        public ExtendedCodegenModel(CodegenModel cm) {
            this.parent = cm.parent;
            this.parentSchema = cm.parentSchema;
            this.interfaces = cm.interfaces;
            this.allParents = cm.allParents;
            this.parentModel = cm.parentModel;
            this.interfaceModels = cm.interfaceModels;
            this.children = cm.children;
            this.anyOf = cm.anyOf;
            this.oneOf = cm.oneOf;
            this.allOf = cm.allOf;
            this.name = cm.name;
            this.classname = cm.classname;
            this.title = cm.title;
            this.description = cm.description;
            this.classVarName = cm.classVarName;
            this.modelJson = cm.modelJson;
            this.dataType = cm.dataType;
            this.xmlPrefix = cm.xmlPrefix;
            this.xmlNamespace = cm.xmlNamespace;
            this.xmlName = cm.xmlName;
            this.classFilename = cm.classFilename;
            this.unescapedDescription = cm.unescapedDescription;
            this.discriminator = cm.discriminator;
            this.defaultValue = cm.defaultValue;
            this.arrayModelType = cm.arrayModelType;
            this.isAlias = cm.isAlias;
            this.isString = cm.isString;
            this.isInteger = cm.isInteger;
            this.isLong = cm.isLong;
            this.isNumber = cm.isNumber;
            this.isNumeric = cm.isNumeric;
            this.isFloat = cm.isFloat;
            this.isDouble = cm.isDouble;
            this.isDate = cm.isDate;
            this.isDateTime = cm.isDateTime;
            this.vars = cm.vars;
            this.allVars = cm.allVars;
            this.requiredVars = cm.requiredVars;
            this.optionalVars = cm.optionalVars;
            this.readOnlyVars = cm.readOnlyVars;
            this.readWriteVars = cm.readWriteVars;
            this.parentVars = cm.parentVars;
            this.allowableValues = cm.allowableValues;
            this.mandatory = cm.mandatory;
            this.allMandatory = cm.allMandatory;
            this.imports = cm.imports;
            this.hasVars = cm.hasVars;
            this.emptyVars = cm.emptyVars;
            this.hasMoreModels = cm.hasMoreModels;
            this.hasEnums = cm.hasEnums;
            this.isEnum = cm.isEnum;
            this.isNullable = cm.isNullable;
            this.hasRequired = cm.hasRequired;
            this.hasOptional = cm.hasOptional;
            this.isArray = cm.isArray;
            this.hasChildren = cm.hasChildren;
            this.isMap = cm.isMap;
            this.isDeprecated = cm.isDeprecated;
            this.hasOnlyReadOnly = cm.hasOnlyReadOnly;
            this.externalDocumentation = cm.externalDocumentation;
            this.vendorExtensions = cm.vendorExtensions;
            this.additionalPropertiesType = cm.additionalPropertiesType;
            this.isAdditionalPropertiesTrue = cm.isAdditionalPropertiesTrue;
            this.setMaxProperties(cm.getMaxProperties());
            this.setMinProperties(cm.getMinProperties());
            this.setUniqueItems(cm.getUniqueItems());
            this.setMaxItems(cm.getMaxItems());
            this.setMinItems(cm.getMinItems());
            this.setMaxLength(cm.getMaxLength());
            this.setMinLength(cm.getMinLength());
            this.setExclusiveMinimum(cm.getExclusiveMinimum());
            this.setExclusiveMaximum(cm.getExclusiveMaximum());
            this.setMinimum(cm.getMinimum());
            this.setMaximum(cm.getMaximum());
            this.setPattern(cm.getPattern());
            this.setMultipleOf(cm.getMultipleOf());
            this.setItems(cm.getItems());
            this.setAdditionalProperties(cm.getAdditionalProperties());
            this.setIsModel(cm.getIsModel());
        }

        public Set<String> getModelImports() {
            return this.modelImports;
        }

        public void setModelImports(Set<String> modelImports) {
            this.modelImports = modelImports;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            boolean result = super.equals(o);
            ExtendedCodegenModel that = (ExtendedCodegenModel)o;
            return result && this.isEntity == that.isEntity && this.hasReturnPassthroughVoid == that.hasReturnPassthroughVoid && Objects.equals(this.returnPassthrough, that.returnPassthrough) && Objects.equals(this.modelImports, that.modelImports);
        }

        @Override
        public int hashCode() {
            int superHash = super.hashCode();
            return Objects.hash(superHash, this.isEntity, this.returnPassthrough, this.hasReturnPassthroughVoid, this.getModelImports());
        }

        @Override
        public String toString() {
            String superString = super.toString();
            StringBuilder sb = new StringBuilder(superString);
            sb.append(", modelImports=").append(this.modelImports);
            sb.append(", isEntity=").append(this.isEntity);
            sb.append(", returnPassthrough='").append(this.returnPassthrough).append('\'');
            sb.append(", hasReturnPassthroughVoid=").append(this.hasReturnPassthroughVoid);
            return sb.toString();
        }
    }

    class ExtendedCodegenOperation
    extends CodegenOperation {
        boolean hasReturnPassthroughVoid;
        boolean returnTypeSupportsEntities;
        boolean returnTypeIsModel;
        boolean returnTypeIsArray;
        String returnTypeAlternate;
        String returnBaseTypeAlternate;
        String returnPassthrough;

        public ExtendedCodegenOperation(CodegenOperation o) {
            this.responseHeaders.addAll(o.responseHeaders);
            this.hasAuthMethods = o.hasAuthMethods;
            this.hasConsumes = o.hasConsumes;
            this.hasProduces = o.hasProduces;
            this.hasParams = o.hasParams;
            this.hasOptionalParams = o.hasOptionalParams;
            this.hasRequiredParams = o.hasRequiredParams;
            this.returnTypeIsPrimitive = o.returnTypeIsPrimitive;
            this.returnSimpleType = o.returnSimpleType;
            this.subresourceOperation = o.subresourceOperation;
            this.isMap = o.isMap;
            this.isArray = o.isArray;
            this.isMultipart = o.isMultipart;
            this.isResponseBinary = o.isResponseBinary;
            this.isResponseFile = o.isResponseFile;
            this.isResponseOptional = o.isResponseOptional;
            this.hasReference = o.hasReference;
            this.isRestfulIndex = o.isRestfulIndex;
            this.isRestfulShow = o.isRestfulShow;
            this.isRestfulCreate = o.isRestfulCreate;
            this.isRestfulUpdate = o.isRestfulUpdate;
            this.isRestfulDestroy = o.isRestfulDestroy;
            this.isRestful = o.isRestful;
            this.isDeprecated = o.isDeprecated;
            this.isCallbackRequest = o.isCallbackRequest;
            this.uniqueItems = o.uniqueItems;
            this.path = o.path;
            this.operationId = o.operationId;
            this.returnType = o.returnType;
            this.returnFormat = o.returnFormat;
            this.httpMethod = o.httpMethod;
            this.returnBaseType = o.returnBaseType;
            this.returnContainer = o.returnContainer;
            this.summary = o.summary;
            this.unescapedNotes = o.unescapedNotes;
            this.notes = o.notes;
            this.baseName = o.baseName;
            this.defaultResponse = o.defaultResponse;
            this.discriminator = o.discriminator;
            this.consumes = o.consumes;
            this.produces = o.produces;
            this.prioritizedContentTypes = o.prioritizedContentTypes;
            this.servers = o.servers;
            this.bodyParam = o.bodyParam;
            this.allParams = o.allParams;
            this.bodyParams = o.bodyParams;
            this.pathParams = o.pathParams;
            this.queryParams = o.queryParams;
            this.headerParams = o.headerParams;
            this.formParams = o.formParams;
            this.cookieParams = o.cookieParams;
            this.requiredParams = o.requiredParams;
            this.optionalParams = o.optionalParams;
            this.authMethods = o.authMethods;
            this.tags = o.tags;
            this.responses = o.responses;
            this.callbacks = o.callbacks;
            this.imports = o.imports;
            this.examples = o.examples;
            this.requestBodyExamples = o.requestBodyExamples;
            this.externalDocs = o.externalDocs;
            this.vendorExtensions = o.vendorExtensions;
            this.nickname = o.nickname;
            this.operationIdOriginal = o.operationIdOriginal;
            this.operationIdLowerCase = o.operationIdLowerCase;
            this.operationIdCamelCase = o.operationIdCamelCase;
            this.operationIdSnakeCase = o.operationIdSnakeCase;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            boolean result = super.equals(o);
            ExtendedCodegenOperation that = (ExtendedCodegenOperation)o;
            return result && this.hasReturnPassthroughVoid == that.hasReturnPassthroughVoid && this.returnTypeSupportsEntities == that.returnTypeSupportsEntities && this.returnTypeIsArray == that.returnTypeIsArray && this.returnTypeIsModel == that.returnTypeIsModel && Objects.equals(this.returnTypeAlternate, that.returnTypeAlternate) && Objects.equals(this.returnBaseTypeAlternate, that.returnBaseTypeAlternate) && Objects.equals(this.returnPassthrough, that.returnPassthrough);
        }

        @Override
        public int hashCode() {
            int superHash = super.hashCode();
            return Objects.hash(superHash, this.returnPassthrough, this.hasReturnPassthroughVoid, this.returnTypeSupportsEntities, this.returnTypeIsArray, this.returnTypeIsModel, this.returnTypeAlternate, this.returnBaseTypeAlternate);
        }

        @Override
        public String toString() {
            String superString = super.toString();
            StringBuilder sb = new StringBuilder(superString);
            sb.append(", hasReturnPassthroughVoid=").append(this.hasReturnPassthroughVoid);
            sb.append(", returnTypeSupportsEntities=").append(this.returnTypeSupportsEntities);
            sb.append(", returnTypeIsArray=").append(this.returnTypeIsArray);
            sb.append(", returnTypeIsModel=").append(this.returnTypeIsModel);
            sb.append(", returnTypeAlternate='").append(this.returnTypeAlternate).append('\'');
            sb.append(", returnBaseTypeAlternate='").append(this.returnBaseTypeAlternate).append('\'');
            sb.append(", returnPassthrough='").append(this.returnPassthrough).append('\'');
            return sb.toString();
        }
    }

    class ExtendedCodegenProperty
    extends CodegenProperty {
        public String dataTypeAlternate;
        public boolean isEntity;
        public boolean isUniqueId;
        public boolean keepAsJSObject;
        public boolean isReservedRecordField;

        public boolean itemsAreUniqueId() {
            return TypeScriptFetchClientCodegen.itemsAreUniqueId(this.items);
        }

        public boolean itemsAreNullable() {
            return TypeScriptFetchClientCodegen.itemsAreNullable(this.items);
        }

        public String getItemsDataType() {
            return TypeScriptFetchClientCodegen.getItemsDataType(this.items);
        }

        public boolean isDateType() {
            return this.isDate && "Date".equals(this.dataType);
        }

        public boolean isDateTimeType() {
            return this.isDateTime && "Date".equals(this.dataType);
        }

        public ExtendedCodegenProperty(CodegenProperty cp) {
            this.openApiType = cp.openApiType;
            this.baseName = cp.baseName;
            this.complexType = cp.complexType;
            this.getter = cp.getter;
            this.setter = cp.setter;
            this.description = cp.description;
            this.dataType = cp.dataType;
            this.datatypeWithEnum = cp.datatypeWithEnum;
            this.dataFormat = cp.dataFormat;
            this.name = cp.name;
            this.min = cp.min;
            this.max = cp.max;
            this.defaultValue = cp.defaultValue;
            this.defaultValueWithParam = cp.defaultValueWithParam;
            this.baseType = cp.baseType;
            this.containerType = cp.containerType;
            this.title = cp.title;
            this.unescapedDescription = cp.unescapedDescription;
            this.maxLength = cp.maxLength;
            this.minLength = cp.minLength;
            this.pattern = cp.pattern;
            this.example = cp.example;
            this.jsonSchema = cp.jsonSchema;
            this.minimum = cp.minimum;
            this.maximum = cp.maximum;
            this.multipleOf = cp.multipleOf;
            this.exclusiveMinimum = cp.exclusiveMinimum;
            this.exclusiveMaximum = cp.exclusiveMaximum;
            this.required = cp.required;
            this.deprecated = cp.deprecated;
            this.hasMoreNonReadOnly = cp.hasMoreNonReadOnly;
            this.isPrimitiveType = cp.isPrimitiveType;
            this.isModel = cp.isModel;
            this.isContainer = cp.isContainer;
            this.isString = cp.isString;
            this.isNumeric = cp.isNumeric;
            this.isInteger = cp.isInteger;
            this.isLong = cp.isLong;
            this.isNumber = cp.isNumber;
            this.isFloat = cp.isFloat;
            this.isDouble = cp.isDouble;
            this.isDecimal = cp.isDecimal;
            this.isByteArray = cp.isByteArray;
            this.isBinary = cp.isBinary;
            this.isFile = cp.isFile;
            this.isBoolean = cp.isBoolean;
            this.isDate = cp.isDate;
            this.isDateTime = cp.isDateTime;
            this.isUuid = cp.isUuid;
            this.isUri = cp.isUri;
            this.isEmail = cp.isEmail;
            this.isFreeFormObject = cp.isFreeFormObject;
            this.isAnyType = cp.isAnyType;
            this.isArray = cp.isArray;
            this.isMap = cp.isMap;
            this.isEnum = cp.isEnum;
            this.isReadOnly = cp.isReadOnly;
            this.isWriteOnly = cp.isWriteOnly;
            this.isNullable = cp.isNullable;
            this.isSelfReference = cp.isSelfReference;
            this.isCircularReference = cp.isCircularReference;
            this.isDiscriminator = cp.isDiscriminator;
            this._enum = cp._enum;
            this.allowableValues = cp.allowableValues;
            this.items = cp.items;
            this.additionalProperties = cp.additionalProperties;
            this.vars = cp.vars;
            this.requiredVars = cp.requiredVars;
            this.mostInnerItems = cp.mostInnerItems;
            this.vendorExtensions = cp.vendorExtensions;
            this.hasValidation = cp.hasValidation;
            this.isInherited = cp.isInherited;
            this.discriminatorValue = cp.discriminatorValue;
            this.nameInLowerCase = cp.nameInLowerCase;
            this.nameInCamelCase = cp.nameInCamelCase;
            this.nameInSnakeCase = cp.nameInSnakeCase;
            this.enumName = cp.enumName;
            this.maxItems = cp.maxItems;
            this.minItems = cp.minItems;
            this.setMaxProperties(cp.getMaxProperties());
            this.setMinProperties(cp.getMinProperties());
            this.setUniqueItems(cp.getUniqueItems());
            this.isXmlAttribute = cp.isXmlAttribute;
            this.xmlPrefix = cp.xmlPrefix;
            this.xmlName = cp.xmlName;
            this.xmlNamespace = cp.xmlNamespace;
            this.isXmlWrapped = cp.isXmlWrapped;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            boolean result = super.equals(o);
            ExtendedCodegenProperty that = (ExtendedCodegenProperty)o;
            return result && this.isEntity == that.isEntity && this.isUniqueId == that.isUniqueId && this.keepAsJSObject == that.keepAsJSObject && this.isReservedRecordField == that.isReservedRecordField && Objects.equals(this.dataTypeAlternate, that.dataTypeAlternate);
        }

        @Override
        public int hashCode() {
            int superHash = super.hashCode();
            return Objects.hash(superHash, this.dataTypeAlternate, this.isEntity, this.isUniqueId, this.keepAsJSObject, this.isReservedRecordField);
        }

        @Override
        public String toString() {
            String superString = super.toString();
            StringBuilder sb = new StringBuilder(superString);
            sb.append(", dataTypeAlternate='").append(this.dataTypeAlternate).append('\'');
            sb.append(", isEntity=").append(this.isEntity);
            sb.append(", isUniqueId=").append(this.isUniqueId);
            sb.append(", keepAsJSObject=").append(this.keepAsJSObject);
            sb.append(", isReservedRecordField=").append(this.isReservedRecordField);
            return sb.toString();
        }
    }

    class ExtendedCodegenParameter
    extends CodegenParameter {
        public String dataTypeAlternate;
        public boolean isUniqueId;

        public boolean itemsAreUniqueId() {
            return TypeScriptFetchClientCodegen.itemsAreUniqueId(this.items);
        }

        public boolean itemsAreNullable() {
            return TypeScriptFetchClientCodegen.itemsAreNullable(this.items);
        }

        public String getItemsDataType() {
            return TypeScriptFetchClientCodegen.getItemsDataType(this.items);
        }

        public boolean isDateType() {
            return this.isDate && "Date".equals(this.dataType);
        }

        public boolean isDateTimeType() {
            return this.isDateTime && "Date".equals(this.dataType);
        }

        public ExtendedCodegenParameter(CodegenParameter cp) {
            this.isFormParam = cp.isFormParam;
            this.isQueryParam = cp.isQueryParam;
            this.isPathParam = cp.isPathParam;
            this.isHeaderParam = cp.isHeaderParam;
            this.isCookieParam = cp.isCookieParam;
            this.isBodyParam = cp.isBodyParam;
            this.isContainer = cp.isContainer;
            this.isCollectionFormatMulti = cp.isCollectionFormatMulti;
            this.isPrimitiveType = cp.isPrimitiveType;
            this.isModel = cp.isModel;
            this.isExplode = cp.isExplode;
            this.baseName = cp.baseName;
            this.paramName = cp.paramName;
            this.dataType = cp.dataType;
            this.datatypeWithEnum = cp.datatypeWithEnum;
            this.dataFormat = cp.dataFormat;
            this.contentType = cp.contentType;
            this.collectionFormat = cp.collectionFormat;
            this.description = cp.description;
            this.unescapedDescription = cp.unescapedDescription;
            this.baseType = cp.baseType;
            this.defaultValue = cp.defaultValue;
            this.enumName = cp.enumName;
            this.style = cp.style;
            this.nameInLowerCase = cp.nameInLowerCase;
            this.example = cp.example;
            this.jsonSchema = cp.jsonSchema;
            this.isString = cp.isString;
            this.isNumeric = cp.isNumeric;
            this.isInteger = cp.isInteger;
            this.isLong = cp.isLong;
            this.isNumber = cp.isNumber;
            this.isFloat = cp.isFloat;
            this.isDouble = cp.isDouble;
            this.isDecimal = cp.isDecimal;
            this.isByteArray = cp.isByteArray;
            this.isBinary = cp.isBinary;
            this.isBoolean = cp.isBoolean;
            this.isDate = cp.isDate;
            this.isDateTime = cp.isDateTime;
            this.isUuid = cp.isUuid;
            this.isUri = cp.isUri;
            this.isEmail = cp.isEmail;
            this.isFreeFormObject = cp.isFreeFormObject;
            this.isAnyType = cp.isAnyType;
            this.isArray = cp.isArray;
            this.isMap = cp.isMap;
            this.isFile = cp.isFile;
            this.isEnum = cp.isEnum;
            this._enum = cp._enum;
            this.allowableValues = cp.allowableValues;
            this.items = cp.items;
            this.additionalProperties = cp.additionalProperties;
            this.vars = cp.vars;
            this.requiredVars = cp.requiredVars;
            this.mostInnerItems = cp.mostInnerItems;
            this.vendorExtensions = cp.vendorExtensions;
            this.hasValidation = cp.hasValidation;
            this.isNullable = cp.isNullable;
            this.required = cp.required;
            this.maximum = cp.maximum;
            this.exclusiveMaximum = cp.exclusiveMaximum;
            this.minimum = cp.minimum;
            this.exclusiveMinimum = cp.exclusiveMinimum;
            this.maxLength = cp.maxLength;
            this.minLength = cp.minLength;
            this.pattern = cp.pattern;
            this.maxItems = cp.maxItems;
            this.minItems = cp.minItems;
            this.uniqueItems = cp.uniqueItems;
            this.multipleOf = cp.multipleOf;
            this.setMaxProperties(cp.getMaxProperties());
            this.setMinProperties(cp.getMinProperties());
        }

        @Override
        public ExtendedCodegenParameter copy() {
            CodegenParameter superCopy = super.copy();
            ExtendedCodegenParameter output = new ExtendedCodegenParameter(superCopy);
            output.dataTypeAlternate = this.dataTypeAlternate;
            output.isUniqueId = this.isUniqueId;
            return output;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            boolean result = super.equals(o);
            ExtendedCodegenParameter that = (ExtendedCodegenParameter)o;
            return result && this.isUniqueId == that.isUniqueId && Objects.equals(this.dataTypeAlternate, that.dataTypeAlternate);
        }

        @Override
        public int hashCode() {
            int superHash = super.hashCode();
            return Objects.hash(superHash, this.dataTypeAlternate, this.isUniqueId);
        }

        @Override
        public String toString() {
            String superString = super.toString();
            StringBuilder sb = new StringBuilder(superString);
            sb.append(", isUniqueId=").append(this.isUniqueId);
            sb.append(", dataTypeAlternate='").append(this.dataTypeAlternate).append('\'');
            return sb.toString();
        }
    }
}

