/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.v9_0.ast;

import org.opencypher.v9_0.ast.LoadCSV;
import org.opencypher.v9_0.ast.semantics.SemanticCheckResult;
import org.opencypher.v9_0.ast.semantics.SemanticError;
import org.opencypher.v9_0.ast.semantics.SemanticState$;
import org.opencypher.v9_0.expressions.Expression;
import org.opencypher.v9_0.expressions.StringLiteral;
import org.opencypher.v9_0.expressions.Variable;
import org.opencypher.v9_0.util.DummyPosition$;
import org.opencypher.v9_0.util.InputPosition;
import org.opencypher.v9_0.util.symbols.CypherType;
import org.opencypher.v9_0.util.symbols.TypeSpec;
import org.opencypher.v9_0.util.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000112A!\u0001\u0002\u0001\u0017\tYAj\\1e\u0007N3F+Z:u\u0015\t\u0019A!A\u0002bgRT!!\u0002\u0004\u0002\tYLt\f\r\u0006\u0003\u000f!\t!b\u001c9f]\u000eL\b\u000f[3s\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0012\t\u0005!Q\u000f^5m\u0013\t\u0019bB\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%\taG\u0001\u000bY&$XM]1m+JcU#\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0011aC3yaJ,7o]5p]NL!!\t\u0010\u0003\u001bM#(/\u001b8h\u0019&$XM]1m\u0011\u0019\u0019\u0003\u0001)A\u00059\u0005YA.\u001b;fe\u0006dWK\u0015'!\u0011\u001d)\u0003A1A\u0005\u0002\u0019\n\u0001B^1sS\u0006\u0014G.Z\u000b\u0002OA\u0011Q\u0004K\u0005\u0003Sy\u0011\u0001BV1sS\u0006\u0014G.\u001a\u0005\u0007W\u0001\u0001\u000b\u0011B\u0014\u0002\u0013Y\f'/[1cY\u0016\u0004\u0003")
public class LoadCSVTest
extends CypherFunSuite {
    private final StringLiteral literalURL = new StringLiteral("file:///tmp/foo.csv", DummyPosition$.MODULE$.apply(4));
    private final Variable variable = new Variable("a", DummyPosition$.MODULE$.apply(4));

    public StringLiteral literalURL() {
        return this.literalURL;
    }

    public Variable variable() {
        return this.variable;
    }

    public LoadCSVTest() {
        this.test("cannot overwrite existing variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LoadCSV loadCSV = new LoadCSV(true, (Expression)this.$outer.literalURL(), this.$outer.variable(), (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.errors());
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("when expecting headers, the variable has a map type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LoadCSV loadCSV = new LoadCSV(true, (Expression)this.$outer.literalURL(), this.$outer.variable(), (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TypeSpec expressionType = result.state().expressionType((Expression)this.$outer.variable()).actual();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(expressionType);
                TypeSpec $org_scalatest_assert_macro_right = org.opencypher.v9_0.util.symbols.package$.MODULE$.CTMap().invariant();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("when not expecting headers, the variable has a list type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LoadCSV loadCSV = new LoadCSV(false, (Expression)this.$outer.literalURL(), this.$outer.variable(), (Option)None$.MODULE$, DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TypeSpec expressionType = result.state().expressionType((Expression)this.$outer.variable()).actual();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(expressionType);
                TypeSpec $org_scalatest_assert_macro_right = org.opencypher.v9_0.util.symbols.package$.MODULE$.CTList((CypherType)org.opencypher.v9_0.util.symbols.package$.MODULE$.CTString()).invariant();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should accept one-character wide field terminators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral literal = new StringLiteral("http://example.com/foo.csv", DummyPosition$.MODULE$.apply(4));
                LoadCSV loadCSV = new LoadCSV(false, (Expression)literal, this.$outer.variable(), (Option)new Some((Object)new StringLiteral("\t", DummyPosition$.MODULE$.apply(0))), DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.errors());
                Vector $org_scalatest_assert_macro_right = package$.MODULE$.Vector().empty();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should reject more-than-one-character wide field terminators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCSVTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StringLiteral literal = new StringLiteral("http://example.com/foo.csv", DummyPosition$.MODULE$.apply(4));
                LoadCSV loadCSV = new LoadCSV(false, (Expression)literal, this.$outer.variable(), (Option)new Some((Object)new StringLiteral("  ", DummyPosition$.MODULE$.apply(0))), DummyPosition$.MODULE$.apply(6));
                SemanticCheckResult result = (SemanticCheckResult)loadCSV.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.errors());
                Vector $org_scalatest_assert_macro_right = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SemanticError[]{new SemanticError("CSV field terminator can only be one character wide", DummyPosition$.MODULE$.apply(0), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[0]))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

