/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.math.BigDecimal;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BiScorer;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetScoringConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetScoringBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B>
implements BavetScoringConstraintStream<Solution_> {
    private final BavetAbstractBiConstraintStream<Solution_, A, B> parent;
    private final boolean noMatchWeigher;
    private final ToIntBiFunction<A, B> intMatchWeigher;
    private final ToLongBiFunction<A, B> longMatchWeigher;
    private final BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher;
    private BavetConstraint<Solution_> constraint;

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, ToIntBiFunction<A, B> intMatchWeigher) {
        this(constraintFactory, parent, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, ToLongBiFunction<A, B> longMatchWeigher) {
        this(constraintFactory, parent, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> parent, boolean noMatchWeigher, ToIntBiFunction<A, B> intMatchWeigher, ToLongBiFunction<A, B> longMatchWeigher, BiFunction<A, B, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public void setConstraint(BavetConstraint<Solution_> constraint) {
        this.constraint = constraint;
    }

    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getTupleSource() {
        return this.parent.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        BiFunction<Object, Object, UndoScoreImpacter> scoreImpacter;
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's an endpoint.");
        }
        Score_ constraintWeight = buildHelper.getConstraintWeight((Constraint)this.constraint);
        WeightedScoreImpacter weightedScoreImpacter = buildHelper.getScoreInliner().buildWeightedScoreImpacter(this.constraint, constraintWeight);
        boolean constraintMatchEnabled = buildHelper.getScoreInliner().isConstraintMatchEnabled();
        if (this.intMatchWeigher != null) {
            scoreImpacter = constraintMatchEnabled ? (a, b) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b);
                this.constraint.assertCorrectImpact(matchWeight);
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (TriFunction)((TriFunction)this.constraint.getJustificationMapping()), (BiFunction)((BiFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b);
                return weightedScoreImpacter.impactScore(matchWeight, justificationsSupplier);
            } : (a, b) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, null);
            };
        } else if (this.longMatchWeigher != null) {
            scoreImpacter = constraintMatchEnabled ? (a, b) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b);
                this.constraint.assertCorrectImpact(matchWeight);
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (TriFunction)((TriFunction)this.constraint.getJustificationMapping()), (BiFunction)((BiFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b);
                return weightedScoreImpacter.impactScore(matchWeight, justificationsSupplier);
            } : (a, b) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, null);
            };
        } else if (this.bigDecimalMatchWeigher != null) {
            scoreImpacter = constraintMatchEnabled ? (a, b) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b);
                this.constraint.assertCorrectImpact(matchWeight);
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (TriFunction)((TriFunction)this.constraint.getJustificationMapping()), (BiFunction)((BiFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b);
                return weightedScoreImpacter.impactScore(matchWeight, justificationsSupplier);
            } : (a, b) -> {
                BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, null);
            };
        } else if (this.noMatchWeigher) {
            scoreImpacter = constraintMatchEnabled ? (a, b) -> {
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (TriFunction)((TriFunction)this.constraint.getJustificationMapping()), (BiFunction)((BiFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b);
                return weightedScoreImpacter.impactScore(1, justificationsSupplier);
            } : (a, b) -> weightedScoreImpacter.impactScore(1, null);
        } else {
            throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
        }
        BiScorer<Object, Object> scorer = new BiScorer<Object, Object>(this.constraint.getConstraintPackage(), this.constraint.getConstraintName(), (Score<?>)constraintWeight, scoreImpacter, buildHelper.reserveTupleStoreIndex((ConstraintStream)this.parent.getTupleSource()));
        buildHelper.putInsertUpdateRetract((ConstraintStream)this, scorer);
    }

    public String toString() {
        return "Scoring(" + this.constraint.getConstraintName() + ")";
    }
}

