/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractConditionalTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.AggregatedTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.LeftTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.RightTupleLifecycle;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.TupleLifecycle;
import org.optaplanner.constraint.streams.common.AbstractConstraintStream;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class NodeBuildHelper<Score_ extends Score<Score_>> {
    private final Set<? extends ConstraintStream> activeStreamSet;
    private final Map<Constraint, Score_> constraintWeightMap;
    private final AbstractScoreInliner<Score_> scoreInliner;
    private final Map<ConstraintStream, TupleLifecycle<? extends Tuple>> tupleLifecycleMap;
    private final Map<ConstraintStream, Integer> storeIndexMap;
    private List<AbstractNode> reversedNodeList;

    public NodeBuildHelper(Set<? extends ConstraintStream> activeStreamSet, Map<Constraint, Score_> constraintWeightMap, AbstractScoreInliner<Score_> scoreInliner) {
        this.activeStreamSet = activeStreamSet;
        this.constraintWeightMap = constraintWeightMap;
        this.scoreInliner = scoreInliner;
        int activeStreamSetSize = activeStreamSet.size();
        this.tupleLifecycleMap = new HashMap<ConstraintStream, TupleLifecycle<? extends Tuple>>(Math.max(16, activeStreamSetSize));
        this.storeIndexMap = new HashMap<ConstraintStream, Integer>(Math.max(16, activeStreamSetSize / 2));
        this.reversedNodeList = new ArrayList<AbstractNode>(activeStreamSetSize);
    }

    public boolean isStreamActive(ConstraintStream stream) {
        return this.activeStreamSet.contains(stream);
    }

    public AbstractScoreInliner<Score_> getScoreInliner() {
        return this.scoreInliner;
    }

    public Score_ getConstraintWeight(Constraint constraint) {
        return (Score_)((Score)this.constraintWeightMap.get(constraint));
    }

    public void addNode(AbstractNode node) {
        this.reversedNodeList.add(node);
    }

    public void addNode(AbstractNode node, ConstraintStream parent) {
        this.addNode(node);
        this.putInsertUpdateRetract(parent, (TupleLifecycle)((Object)node));
    }

    public void addNode(AbstractNode node, ConstraintStream leftParent, ConstraintStream rightParent) {
        this.addNode(node);
        this.putInsertUpdateRetract(leftParent, TupleLifecycle.ofLeft((LeftTupleLifecycle)((Object)node)));
        this.putInsertUpdateRetract(rightParent, TupleLifecycle.ofRight((RightTupleLifecycle)((Object)node)));
    }

    public <Tuple_ extends Tuple> void putInsertUpdateRetract(ConstraintStream stream, TupleLifecycle<Tuple_> tupleLifecycle) {
        this.tupleLifecycleMap.put(stream, tupleLifecycle);
    }

    public <Tuple_ extends Tuple> void putInsertUpdateRetract(ConstraintStream stream, List<? extends AbstractConstraintStream> childStreamList, Function<TupleLifecycle<Tuple_>, AbstractConditionalTupleLifecycle<Tuple_>> tupleLifecycleFunction) {
        TupleLifecycle<Tuple_> tupleLifecycle = this.getAggregatedTupleLifecycle(childStreamList);
        this.putInsertUpdateRetract(stream, tupleLifecycleFunction.apply(tupleLifecycle));
    }

    public <Tuple_ extends Tuple> TupleLifecycle<Tuple_> getAggregatedTupleLifecycle(List<? extends ConstraintStream> streamList) {
        TupleLifecycle[] tupleLifecycles = (TupleLifecycle[])streamList.stream().filter(this::isStreamActive).map(s -> NodeBuildHelper.getTupleLifecycle(s, this.tupleLifecycleMap)).toArray(TupleLifecycle[]::new);
        switch (tupleLifecycles.length) {
            case 0: {
                throw new IllegalStateException("Impossible state: None of the streamList (" + streamList + ") are active.");
            }
            case 1: {
                return tupleLifecycles[0];
            }
        }
        return new AggregatedTupleLifecycle(tupleLifecycles);
    }

    private static <Tuple_ extends Tuple> TupleLifecycle<Tuple_> getTupleLifecycle(ConstraintStream stream, Map<ConstraintStream, TupleLifecycle<? extends Tuple>> tupleLifecycleMap) {
        TupleLifecycle<? extends Tuple> tupleLifecycle = tupleLifecycleMap.get(stream);
        if (tupleLifecycle == null) {
            throw new IllegalStateException("Impossible state: the stream (" + stream + ") hasn't built a node yet.");
        }
        return tupleLifecycle;
    }

    public int reserveTupleStoreIndex(ConstraintStream tupleSourceStream) {
        return this.storeIndexMap.compute(tupleSourceStream, (k, index) -> {
            if (index == null) {
                return 0;
            }
            if (index < 0) {
                throw new IllegalStateException("Impossible state: the tupleSourceStream (" + k + ") is reserving a store after it has been extracted.");
            }
            return index + 1;
        });
    }

    public int extractTupleStoreSize(ConstraintStream tupleSourceStream) {
        Integer lastIndex = this.storeIndexMap.put(tupleSourceStream, Integer.MIN_VALUE);
        return lastIndex == null ? 0 : lastIndex + 1;
    }

    public List<AbstractNode> destroyAndGetNodeList() {
        List<AbstractNode> nodeList = this.reversedNodeList;
        Collections.reverse(nodeList);
        this.reversedNodeList = null;
        return nodeList;
    }
}

