/*
 * Decompiled with CFR 0.152.
 */
package org.xlcloud.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.xlcloud.ssh.SshExecutionOutput;
import org.xlcloud.ssh.SshSessionFactory;

public class SshTask {
    private static final Logger LOG = Logger.getLogger(SshTask.class);
    private String command;
    private SshSessionFactory sessionFactory;
    private SshExecutionOutput sshExecutionOutput;
    private Channel channel;

    public SshTask(String command) {
        this.command = command;
        this.sshExecutionOutput = new SshExecutionOutput();
    }

    public void setSessionFactory(SshSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void run() {
        Session session = null;
        try {
            session = this.sessionFactory.getSession();
            if (session == null) {
                throw new RuntimeException("could not retreive ssh session");
            }
            this.channel = session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(this.command);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing command: " + this.command));
            }
            this.channel.connect();
            this.channel.setInputStream(null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((ChannelExec)this.channel).setErrStream((OutputStream)baos);
            InputStream in = this.channel.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
            while (!this.channel.isClosed()) {
            }
            this.sshExecutionOutput.setExitCode(String.valueOf(this.channel.getExitStatus()));
            if (this.channel.getExitStatus() == 0) {
                LOG.debug((Object)("exit code is: " + this.channel.getExitStatus() + " message: " + writer.toString()));
                this.sshExecutionOutput.setMessage(writer.toString());
            } else {
                LOG.error((Object)("exit code is: " + this.channel.getExitStatus() + " reason: " + baos.toString() + " message: " + writer.toString()));
                this.sshExecutionOutput.setMessage(baos.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.channel != null) {
                this.channel.disconnect();
            }
            if (session != null) {
                this.sessionFactory.returnSession(session);
            }
        }
    }

    public SshExecutionOutput getOutput() {
        return this.sshExecutionOutput;
    }
}

