/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpConnection;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.Version;
import org.openqa.jetty.http.ajp.AJP13InputStream;
import org.openqa.jetty.http.ajp.AJP13Listener;
import org.openqa.jetty.http.ajp.AJP13OutputStream;
import org.openqa.jetty.http.ajp.AJP13RequestPacket;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LineInput;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.URI;

public class AJP13Connection
extends HttpConnection {
    private static Log log = LogFactory.getLog(AJP13Connection.class);
    private AJP13Listener _listener;
    private AJP13InputStream _ajpIn;
    private AJP13OutputStream _ajpOut;
    private String _remoteHost;
    private String _remoteAddr;
    private String _serverName;
    private int _serverPort;
    private boolean _isSSL;

    public AJP13Connection(AJP13Listener listener, InputStream in, OutputStream out, Socket socket, int bufferSize) throws IOException {
        super(listener, null, new AJP13InputStream(in, out, bufferSize), out, socket);
        LineInput lin = (LineInput)this.getInputStream().getInputStream();
        this._ajpIn = (AJP13InputStream)lin.getInputStream();
        this._ajpOut = new AJP13OutputStream(this.getOutputStream().getOutputStream(), bufferSize);
        this._ajpOut.setCommitObserver(this);
        this.getOutputStream().setBufferedOutputStream(this._ajpOut);
        this._listener = listener;
    }

    @Override
    public InetAddress getRemoteInetAddress() {
        return null;
    }

    @Override
    public void destroy() {
        if (this._ajpIn != null) {
            this._ajpIn.destroy();
        }
        this._ajpIn = null;
        if (this._ajpOut != null) {
            this._ajpOut.destroy();
        }
        this._ajpOut = null;
        this._remoteHost = null;
        this._remoteAddr = null;
        this._serverName = null;
    }

    @Override
    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    @Override
    public String getRemoteHost() {
        return this._remoteHost;
    }

    @Override
    public String getServerName() {
        return this._serverName;
    }

    @Override
    public int getServerPort() {
        return this._serverPort;
    }

    @Override
    public String getDefaultScheme() {
        return this._isSSL ? "https" : super.getDefaultScheme();
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    @Override
    public boolean handleNext() {
        block76: {
            AJP13RequestPacket packet = null;
            HttpRequest request = this.getRequest();
            HttpResponse response = this.getResponse();
            HttpContext context = null;
            boolean gotRequest = false;
            this._persistent = true;
            this._keepAlive = true;
            try {
                packet = null;
                packet = this._ajpIn.nextPacket();
                if (packet == null) {
                    return false;
                }
                if (packet.getDataSize() == 0) {
                    return true;
                }
            }
            catch (IOException e) {
                LogSupport.ignore(log, e);
                return false;
            }
            {
                try {
                    byte type = packet.getByte();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("AJP13 type=" + type + " size=" + packet.unconsumedData()));
                    }
                    switch (type) {
                        case 2: {
                            request.setTimeStamp(System.currentTimeMillis());
                            request.setState(0);
                            request.setMethod(packet.getMethod());
                            request.setVersion(packet.getString());
                            String version = packet.getString();
                            try {
                                request.setVersion(version);
                            }
                            catch (Exception e) {
                                log.warn((Object)("Bad version" + version), (Throwable)e);
                                log.warn((Object)packet.toString());
                            }
                            String path = packet.getString();
                            int sc = path.lastIndexOf(";");
                            if (sc < 0) {
                                request.setPath(URI.encodePath(path));
                            } else {
                                request.setPath(String.valueOf(URI.encodePath(path.substring(0, sc))) + path.substring(sc));
                            }
                            this._remoteAddr = packet.getString();
                            this._remoteHost = packet.getString();
                            this._serverName = packet.getString();
                            this._serverPort = packet.getInt();
                            this._isSSL = packet.getBoolean();
                            this._keepAlive = request.getDotVersion() >= 1;
                            int h = packet.getInt();
                            int i = 0;
                            while (i < h) {
                                String hdr = packet.getHeader();
                                String val = packet.getString();
                                request.addField(hdr, val);
                                if (!this._keepAlive && hdr.equalsIgnoreCase("Connection") && val.equalsIgnoreCase("keep-alive")) {
                                    this._keepAlive = true;
                                }
                                ++i;
                            }
                            byte attr = packet.getByte();
                            while ((0xFF & attr) != 255) {
                                String value = attr == 11 ? null : packet.getString();
                                switch (attr) {
                                    case 11: {
                                        request.setAttribute("javax.servlet.request.key_size", new Integer(packet.getInt()));
                                        break;
                                    }
                                    case 10: {
                                        request.setAttribute(value, packet.getString());
                                        break;
                                    }
                                    case 9: {
                                        request.setAttribute("javax.servlet.request.ssl_session", value);
                                        break;
                                    }
                                    case 8: {
                                        request.setAttribute("javax.servlet.request.cipher_suite", value);
                                        break;
                                    }
                                    case 7: {
                                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                        ByteArrayInputStream certstream = new ByteArrayInputStream(value.getBytes());
                                        X509Certificate cert = (X509Certificate)cf.generateCertificate(certstream);
                                        X509Certificate[] certs = new X509Certificate[]{cert};
                                        request.setAttribute("javax.servlet.request.X509Certificate", certs);
                                        break;
                                    }
                                    case 6: {
                                        request.setAttribute("org.openqa.jetty.http.ajp.JVMRoute", value);
                                        break;
                                    }
                                    case 5: {
                                        request.setQuery(value);
                                        break;
                                    }
                                    case 4: {
                                        request.setAuthType(value);
                                        break;
                                    }
                                    case 3: {
                                        request.setAuthUser(value);
                                        break;
                                    }
                                    default: {
                                        log.warn((Object)("Unknown attr: " + attr + "=" + value));
                                    }
                                }
                                attr = packet.getByte();
                            }
                            this._listener.customizeRequest(this, request);
                            gotRequest = true;
                            this.statsRequestStart();
                            request.setState(2);
                            if (request.getContentLength() == 0 && request.getField("Transfer-Encoding") == null) {
                                this._ajpIn.close();
                            }
                            response.setState(0);
                            response.setVersion("HTTP/1.1");
                            response.setDateField("Date", this._request.getTimeStamp());
                            if (!Version.isParanoid()) {
                                response.setField("Server", Version.getDetail());
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("REQUEST:\n" + request));
                            }
                            context = this.service(request, response);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("RESPONSE:\n" + response));
                                break;
                            }
                            break block76;
                        }
                        default: {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Ignored: " + packet));
                            }
                            this._persistent = false;
                            break;
                        }
                    }
                }
                catch (SocketException e) {
                    LogSupport.ignore(log, e);
                    this._persistent = false;
                }
                catch (Exception e) {
                    log.warn((Object)"EXCEPTION ", (Throwable)e);
                    this._persistent = false;
                    try {
                        if (gotRequest) {
                            this._ajpOut.close();
                        }
                        break block76;
                    }
                    catch (IOException e2) {
                        LogSupport.ignore(log, e2);
                    }
                }
                break block76;
            }
            finally {
                block78: {
                    if (packet == null || !gotRequest) {
                        return false;
                    }
                    try {
                        try {
                            this.getOutputStream().close();
                            if (!this._persistent) {
                                this._ajpOut.end();
                            }
                            this._ajpOut.close();
                            this.getOutputStream().resetStream();
                            this.getOutputStream().addObserver(this);
                            this.getInputStream().resetStream();
                            this._ajpIn.resetStream();
                            this._ajpOut.resetStream();
                        }
                        catch (Exception e) {
                            log.debug((Object)"EXCEPTION ", (Throwable)e);
                            this._persistent = false;
                            this.statsRequestEnd();
                            if (context != null) {
                                context.log(request, response, -1);
                            }
                            break block78;
                        }
                    }
                    catch (Throwable throwable) {
                        this.statsRequestEnd();
                        if (context != null) {
                            context.log(request, response, -1);
                        }
                        throw throwable;
                    }
                    this.statsRequestEnd();
                    if (context != null) {
                        context.log(request, response, -1);
                    }
                }
            }
        }
        return this._persistent;
    }

    @Override
    protected void firstWrite() throws IOException {
        log.debug((Object)"ajp13 firstWrite()");
    }

    @Override
    protected void commit() throws IOException {
        log.debug((Object)"ajp13 commit()");
        if (this._response.isCommitted()) {
            return;
        }
        this._request.setHandled(true);
        this.getOutputStream().writeHeader(this._response);
    }

    protected void setupOutputStream() throws IOException {
        if ("HEAD".equals(this.getRequest().getMethod())) {
            this.getOutputStream().nullOutput();
        }
    }
}

