/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.test.context.AnnotatedClassFinder;
import org.springframework.boot.test.context.DefaultTestExecutionListenersPostProcessor;
import org.springframework.boot.test.context.ReactiveWebMergedContextConfiguration;
import org.springframework.boot.test.context.SpringBootContextLoader;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTestArgs;
import org.springframework.boot.test.context.SpringBootTestWebEnvironment;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.DefaultTestContextBootstrapper;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SpringBootTestContextBootstrapper
extends DefaultTestContextBootstrapper {
    private static final String[] WEB_ENVIRONMENT_CLASSES = new String[]{"javax.servlet.Servlet", "org.springframework.web.context.ConfigurableWebApplicationContext"};
    private static final String REACTIVE_WEB_ENVIRONMENT_CLASS = "org.springframework.web.reactive.DispatcherHandler";
    private static final String MVC_WEB_ENVIRONMENT_CLASS = "org.springframework.web.servlet.DispatcherServlet";
    private static final String JERSEY_WEB_ENVIRONMENT_CLASS = "org.glassfish.jersey.server.ResourceConfig";
    private static final String ACTIVATE_SERVLET_LISTENER = "org.springframework.test.context.web.ServletTestExecutionListener.activateListener";
    private static final Log logger = LogFactory.getLog(SpringBootTestContextBootstrapper.class);

    public TestContext buildTestContext() {
        TestContext context = super.buildTestContext();
        this.verifyConfiguration(context.getTestClass());
        SpringBootTest.WebEnvironment webEnvironment = this.getWebEnvironment(context.getTestClass());
        if (webEnvironment == SpringBootTest.WebEnvironment.MOCK && this.deduceWebApplicationType() == WebApplicationType.SERVLET) {
            context.setAttribute(ACTIVATE_SERVLET_LISTENER, (Object)true);
        } else if (webEnvironment != null && webEnvironment.isEmbedded()) {
            context.setAttribute(ACTIVATE_SERVLET_LISTENER, (Object)false);
        }
        return context;
    }

    protected Set<Class<? extends TestExecutionListener>> getDefaultTestExecutionListenerClasses() {
        Set<Class<? extends TestExecutionListener>> listeners = super.getDefaultTestExecutionListenerClasses();
        List postProcessors = SpringFactoriesLoader.loadFactories(DefaultTestExecutionListenersPostProcessor.class, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (DefaultTestExecutionListenersPostProcessor postProcessor : postProcessors) {
            listeners = postProcessor.postProcessDefaultTestExecutionListeners(listeners);
        }
        return listeners;
    }

    protected ContextLoader resolveContextLoader(Class<?> testClass, List<ContextConfigurationAttributes> configAttributesList) {
        Object[] classes = this.getClasses(testClass);
        if (!ObjectUtils.isEmpty((Object[])classes)) {
            for (ContextConfigurationAttributes configAttributes : configAttributesList) {
                this.addConfigAttributesClasses(configAttributes, (Class<?>[])classes);
            }
        }
        return super.resolveContextLoader(testClass, configAttributesList);
    }

    private void addConfigAttributesClasses(ContextConfigurationAttributes configAttributes, Class<?>[] classes) {
        LinkedHashSet combined = new LinkedHashSet(Arrays.asList(classes));
        if (configAttributes.getClasses() != null) {
            combined.addAll(Arrays.asList(configAttributes.getClasses()));
        }
        configAttributes.setClasses(ClassUtils.toClassArray(combined));
    }

    protected Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> testClass) {
        return SpringBootContextLoader.class;
    }

    protected MergedContextConfiguration processMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        List<String> propertySourceProperties;
        Class<?>[] classes = this.getOrFindConfigurationClasses(mergedConfig);
        SpringBootTest.WebEnvironment webEnvironment = this.getWebEnvironment((mergedConfig = this.createModifiedConfig(mergedConfig, classes, StringUtils.toStringArray(propertySourceProperties = this.getAndProcessPropertySourceProperties(mergedConfig)))).getTestClass());
        if (webEnvironment != null && this.isWebEnvironmentSupported(mergedConfig)) {
            WebApplicationType webApplicationType = this.getWebApplicationType(mergedConfig);
            if (webApplicationType == WebApplicationType.SERVLET && (webEnvironment.isEmbedded() || webEnvironment == SpringBootTest.WebEnvironment.MOCK)) {
                mergedConfig = new WebMergedContextConfiguration(mergedConfig, this.determineResourceBasePath(mergedConfig));
            } else if (webApplicationType == WebApplicationType.REACTIVE && (webEnvironment.isEmbedded() || webEnvironment == SpringBootTest.WebEnvironment.MOCK)) {
                return new ReactiveWebMergedContextConfiguration(mergedConfig);
            }
        }
        return mergedConfig;
    }

    private WebApplicationType getWebApplicationType(MergedContextConfiguration configuration) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(TestPropertySourceUtils.convertInlinedPropertiesToMap((String[])configuration.getPropertySourceProperties()));
        Binder binder = new Binder(new ConfigurationPropertySource[]{source});
        return (WebApplicationType)binder.bind("spring.main.web-application-type", Bindable.of(WebApplicationType.class)).orElseGet(this::deduceWebApplicationType);
    }

    private WebApplicationType deduceWebApplicationType() {
        if (ClassUtils.isPresent((String)REACTIVE_WEB_ENVIRONMENT_CLASS, null) && !ClassUtils.isPresent((String)MVC_WEB_ENVIRONMENT_CLASS, null) && !ClassUtils.isPresent((String)JERSEY_WEB_ENVIRONMENT_CLASS, null)) {
            return WebApplicationType.REACTIVE;
        }
        for (String className : WEB_ENVIRONMENT_CLASSES) {
            if (ClassUtils.isPresent((String)className, null)) continue;
            return WebApplicationType.NONE;
        }
        return WebApplicationType.SERVLET;
    }

    protected String determineResourceBasePath(MergedContextConfiguration configuration) {
        return MergedAnnotations.from((AnnotatedElement)configuration.getTestClass(), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(WebAppConfiguration.class).getValue("value", String.class).orElse("src/main/webapp");
    }

    private boolean isWebEnvironmentSupported(MergedContextConfiguration mergedConfig) {
        Class testClass = mergedConfig.getTestClass();
        ContextHierarchy hierarchy = (ContextHierarchy)AnnotationUtils.getAnnotation((AnnotatedElement)testClass, ContextHierarchy.class);
        if (hierarchy == null || hierarchy.value().length == 0) {
            return true;
        }
        ContextConfiguration[] configurations = hierarchy.value();
        return this.isFromConfiguration(mergedConfig, configurations[configurations.length - 1]);
    }

    private boolean isFromConfiguration(MergedContextConfiguration candidateConfig, ContextConfiguration configuration) {
        ContextConfigurationAttributes attributes = new ContextConfigurationAttributes(candidateConfig.getTestClass(), configuration);
        HashSet<Class> configurationClasses = new HashSet<Class>(Arrays.asList(attributes.getClasses()));
        for (Class candidate : candidateConfig.getClasses()) {
            if (!configurationClasses.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    protected Class<?>[] getOrFindConfigurationClasses(MergedContextConfiguration mergedConfig) {
        Class[] classes = mergedConfig.getClasses();
        if (this.containsNonTestComponent(classes) || mergedConfig.hasLocations()) {
            return classes;
        }
        Class<?> found = new AnnotatedClassFinder(SpringBootConfiguration.class).findFromClass(mergedConfig.getTestClass());
        Assert.state((found != null ? 1 : 0) != 0, (String)"Unable to find a @SpringBootConfiguration, you need to use @ContextConfiguration or @SpringBootTest(classes=...) with your test");
        logger.info((Object)("Found @SpringBootConfiguration " + found.getName() + " for test " + mergedConfig.getTestClass()));
        return this.merge(found, classes);
    }

    private boolean containsNonTestComponent(Class<?>[] classes) {
        for (Class<?> candidate : classes) {
            if (MergedAnnotations.from(candidate, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).isPresent(TestConfiguration.class)) continue;
            return true;
        }
        return false;
    }

    private Class<?>[] merge(Class<?> head, Class<?>[] existing) {
        Class[] result = new Class[existing.length + 1];
        result[0] = head;
        System.arraycopy(existing, 0, result, 1, existing.length);
        return result;
    }

    private List<String> getAndProcessPropertySourceProperties(MergedContextConfiguration mergedConfig) {
        ArrayList<String> propertySourceProperties = new ArrayList<String>(Arrays.asList(mergedConfig.getPropertySourceProperties()));
        String differentiator = this.getDifferentiatorPropertySourceProperty();
        if (differentiator != null) {
            propertySourceProperties.add(differentiator);
        }
        this.processPropertySourceProperties(mergedConfig, propertySourceProperties);
        return propertySourceProperties;
    }

    protected String getDifferentiatorPropertySourceProperty() {
        return ((Object)((Object)this)).getClass().getName() + "=true";
    }

    protected void processPropertySourceProperties(MergedContextConfiguration mergedConfig, List<String> propertySourceProperties) {
        Class testClass = mergedConfig.getTestClass();
        Object[] properties = this.getProperties(testClass);
        if (!ObjectUtils.isEmpty((Object[])properties)) {
            propertySourceProperties.addAll(0, Arrays.asList(properties));
        }
        if (this.getWebEnvironment(testClass) == SpringBootTest.WebEnvironment.RANDOM_PORT) {
            propertySourceProperties.add("server.port=0");
        }
    }

    protected SpringBootTest.WebEnvironment getWebEnvironment(Class<?> testClass) {
        SpringBootTest annotation = this.getAnnotation(testClass);
        return annotation != null ? annotation.webEnvironment() : null;
    }

    protected Class<?>[] getClasses(Class<?> testClass) {
        SpringBootTest annotation = this.getAnnotation(testClass);
        return annotation != null ? annotation.classes() : null;
    }

    protected String[] getProperties(Class<?> testClass) {
        SpringBootTest annotation = this.getAnnotation(testClass);
        return annotation != null ? annotation.properties() : null;
    }

    protected SpringBootTest getAnnotation(Class<?> testClass) {
        return (SpringBootTest)TestContextAnnotationUtils.findMergedAnnotation(testClass, SpringBootTest.class);
    }

    protected void verifyConfiguration(Class<?> testClass) {
        SpringBootTest springBootTest = this.getAnnotation(testClass);
        if (springBootTest != null && this.isListeningOnPort(springBootTest.webEnvironment()) && MergedAnnotations.from(testClass, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).isPresent(WebAppConfiguration.class)) {
            throw new IllegalStateException("@WebAppConfiguration should only be used with @SpringBootTest when @SpringBootTest is configured with a mock web environment. Please remove @WebAppConfiguration or reconfigure @SpringBootTest.");
        }
    }

    private boolean isListeningOnPort(SpringBootTest.WebEnvironment webEnvironment) {
        return webEnvironment == SpringBootTest.WebEnvironment.DEFINED_PORT || webEnvironment == SpringBootTest.WebEnvironment.RANDOM_PORT;
    }

    protected final MergedContextConfiguration createModifiedConfig(MergedContextConfiguration mergedConfig, Class<?>[] classes) {
        return this.createModifiedConfig(mergedConfig, classes, mergedConfig.getPropertySourceProperties());
    }

    protected final MergedContextConfiguration createModifiedConfig(MergedContextConfiguration mergedConfig, Class<?>[] classes, String[] propertySourceProperties) {
        LinkedHashSet<Object> contextCustomizers = new LinkedHashSet<Object>(mergedConfig.getContextCustomizers());
        contextCustomizers.add(new SpringBootTestArgs(mergedConfig.getTestClass()));
        contextCustomizers.add(new SpringBootTestWebEnvironment(mergedConfig.getTestClass()));
        return new MergedContextConfiguration(mergedConfig.getTestClass(), mergedConfig.getLocations(), (Class[])classes, mergedConfig.getContextInitializerClasses(), mergedConfig.getActiveProfiles(), mergedConfig.getPropertySourceLocations(), propertySourceProperties, contextCustomizers, mergedConfig.getContextLoader(), this.getCacheAwareContextLoaderDelegate(), mergedConfig.getParent());
    }
}

