/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.cassandra.config.CassandraCqlSessionParser;
import org.springframework.data.cassandra.config.CassandraMappingXmlBeanFactoryPostProcessorRegistrar;
import org.springframework.data.cassandra.config.CassandraSessionFactoryBean;
import org.springframework.data.cassandra.config.ParsingUtils;
import org.springframework.data.cassandra.config.SchemaAction;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class CassandraSessionParser
extends CassandraCqlSessionParser {
    CassandraSessionParser() {
    }

    @Override
    protected Class<?> getBeanClass(Element element) {
        return CassandraSessionFactoryBean.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        CassandraMappingXmlBeanFactoryPostProcessorRegistrar.ensureRegistration(element, parserContext);
    }

    @Override
    protected void parseUnhandledSessionElementAttribute(Attr attribute, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String name = attribute.getName();
        if ("cassandra-converter-ref".equals(name)) {
            ParsingUtils.addOptionalPropertyReference(builder, "converter", attribute, "cassandraConverter");
        } else if ("schema-action".equals(name)) {
            ParsingUtils.addOptionalPropertyValue(builder, "schemaAction", attribute, SchemaAction.NONE.name());
        } else {
            super.parseUnhandledSessionElementAttribute(attribute, parserContext, builder);
        }
    }

    @Override
    protected void setDefaultProperties(BeanDefinitionBuilder builder) {
        super.setDefaultProperties(builder);
        ParsingUtils.addRequiredPropertyValue(builder, "schemaAction", SchemaAction.NONE.name());
        ParsingUtils.addRequiredPropertyReference(builder, "converter", "cassandraConverter");
    }
}

