/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import java.util.List;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ColumnReader {
    private final Row row;
    private final ColumnDefinitions columns;
    private final CodecRegistry codecRegistry;

    public ColumnReader(Row row) {
        this.row = row;
        this.columns = row.getColumnDefinitions();
        this.codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
    }

    @Nullable
    public Object get(CqlIdentifier columnName) {
        return this.get(columnName.toCql());
    }

    @Nullable
    public Object get(String columnName) {
        return this.get(this.getColumnIndex(columnName));
    }

    @Nullable
    public Object get(int columnIndex) {
        if (this.row.isNull(columnIndex)) {
            return null;
        }
        DataType type = this.columns.getType(columnIndex);
        if (type.isCollection()) {
            return this.getCollection(columnIndex, type);
        }
        if (DataType.Name.TUPLE.equals((Object)type.getName())) {
            return this.row.getTupleValue(columnIndex);
        }
        if (DataType.Name.UDT.equals((Object)type.getName())) {
            return this.row.getUDTValue(columnIndex);
        }
        return this.row.getObject(columnIndex);
    }

    @Nullable
    public <T> T get(CqlIdentifier columnName, Class<T> requestedType) {
        return this.get(columnName.toCql(), requestedType);
    }

    @Nullable
    public <T> T get(String columnName, Class<T> requestedType) {
        return this.get(this.getColumnIndex(columnName), requestedType);
    }

    @Nullable
    public <T> T get(int columnIndex, Class<T> requestedType) {
        Object value = this.get(columnIndex);
        return requestedType.cast(value);
    }

    @Nullable
    private Object getCollection(int index, DataType type) {
        List collectionTypes = type.getTypeArguments();
        if (collectionTypes.size() == 1) {
            DataType valueType = (DataType)collectionTypes.get(0);
            TypeCodec typeCodec = this.codecRegistry.codecFor(valueType);
            if (type.equals(DataType.list((DataType)valueType))) {
                return this.row.getList(index, typeCodec.getJavaType().getRawType());
            }
            if (type.equals(DataType.set((DataType)valueType))) {
                return this.row.getSet(index, typeCodec.getJavaType().getRawType());
            }
        }
        if (type.getName() == DataType.Name.MAP) {
            return this.row.getObject(index);
        }
        throw new IllegalStateException("Unknown Collection type encountered; valid collections are List, Set and Map.");
    }

    private int getColumnIndex(String columnName) {
        int index = this.columns.getIndexOf(columnName);
        Assert.isTrue((index > -1 ? 1 : 0) != 0, (String)String.format("Column [%s] does not exist in table", columnName));
        return index;
    }

    public Row getRow() {
        return this.row;
    }
}

