/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.DriverException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.cassandra.core.cql.PreparedStatementCreator;
import org.springframework.util.Assert;

@Deprecated
public class CachedPreparedStatementCreator
implements PreparedStatementCreator {
    private static final Map<Session, Map<String, PreparedStatement>> CACHE = new ConcurrentHashMap<Session, Map<String, PreparedStatement>>();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String cql;

    public CachedPreparedStatementCreator(String cql) {
        Assert.hasText((String)cql, (String)"CQL is required to create a PreparedStatement");
        this.cql = cql;
    }

    public String getCql() {
        return this.cql;
    }

    @Override
    public PreparedStatement createPreparedStatement(Session session) throws DriverException {
        String cacheKey = String.valueOf(session.getLoggedKeyspace()).concat("|").concat(this.cql);
        this.log.debug("Cacheable PreparedStatement in Keyspace {}", (Object)session.getLoggedKeyspace());
        Map<String, PreparedStatement> sessionCache = this.getOrCreateSessionLocalCache(session);
        return this.getOrPrepareStatement(session, cacheKey, sessionCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PreparedStatement> getOrCreateSessionLocalCache(Session session) {
        Map<String, PreparedStatement> sessionMap = CACHE.get(session);
        if (sessionMap == null) {
            Session session2 = session;
            synchronized (session2) {
                if (CACHE.containsKey(session)) {
                    sessionMap = CACHE.get(session);
                } else {
                    sessionMap = new ConcurrentHashMap<String, PreparedStatement>();
                    CACHE.put(session, sessionMap);
                }
            }
        }
        return sessionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getOrPrepareStatement(Session session, String cacheKey, Map<String, PreparedStatement> sessionCache) {
        PreparedStatement preparedStatement = sessionCache.get(cacheKey);
        if (preparedStatement == null) {
            Map<String, PreparedStatement> map = sessionCache;
            synchronized (map) {
                if (sessionCache.containsKey(cacheKey)) {
                    this.log.debug("Found cached PreparedStatement");
                    preparedStatement = sessionCache.get(cacheKey);
                } else {
                    this.log.debug("No cached PreparedStatement found... creating and caching");
                    preparedStatement = session.prepare(this.cql);
                    sessionCache.put(cacheKey, preparedStatement);
                }
            }
        }
        return preparedStatement;
    }
}

