/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Columns
implements Iterable<ColumnName> {
    private final Map<ColumnName, Selector> columns;

    private Columns(Map<ColumnName, Selector> columns) {
        this.columns = Collections.unmodifiableMap(columns);
    }

    public static Columns empty() {
        return new Columns(Collections.emptyMap());
    }

    public static Columns from(String ... columnNames) {
        Assert.notNull((Object)columnNames, (String)"Column names must not be null");
        HashMap<ColumnName, Selector> columns = new HashMap<ColumnName, Selector>(columnNames.length, 1.0f);
        Arrays.stream(columnNames).forEach(columnName -> {
            Selector cfr_ignored_0 = columns.put(ColumnName.from(columnName), ColumnSelector.from(columnName));
        });
        return new Columns(columns);
    }

    public static Columns from(CqlIdentifier ... columnNames) {
        Assert.notNull((Object)columnNames, (String)"Column names must not be null");
        HashMap<ColumnName, Selector> columns = new HashMap<ColumnName, Selector>(columnNames.length, 1.0f);
        Arrays.stream(columnNames).forEach(cqlId -> {
            Selector cfr_ignored_0 = columns.put(ColumnName.from(cqlId), ColumnSelector.from(cqlId));
        });
        return new Columns(columns);
    }

    public Columns include(String columnName) {
        return this.select(columnName, (Selector)ColumnSelector.from(columnName));
    }

    public Columns include(CqlIdentifier columnName) {
        return this.select(columnName, (Selector)ColumnSelector.from(columnName));
    }

    public Columns ttl(String columnName) {
        return this.select(columnName, (Selector)FunctionCall.from("TTL", ColumnSelector.from(columnName)));
    }

    public Columns ttl(CqlIdentifier columnName) {
        return this.select(columnName, (Selector)FunctionCall.from("TTL", ColumnSelector.from(columnName)));
    }

    public Columns select(String columnName, Selector selector) {
        Assert.notNull((Object)columnName, (String)"Column name must not be null");
        LinkedHashMap<ColumnName, Selector> result = new LinkedHashMap<ColumnName, Selector>(this.columns);
        result.put(ColumnName.from(columnName), selector);
        return new Columns(result);
    }

    public Columns select(CqlIdentifier columnName, Selector selector) {
        Assert.notNull((Object)columnName, (String)"Column name must not be null");
        LinkedHashMap<ColumnName, Selector> result = new LinkedHashMap<ColumnName, Selector>(this.columns);
        result.put(ColumnName.from(columnName), selector);
        return new Columns(result);
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public Columns and(Columns columns) {
        LinkedHashMap<ColumnName, Selector> result = new LinkedHashMap<ColumnName, Selector>(this.columns);
        result.putAll(columns.columns);
        return new Columns(result);
    }

    @Override
    public Iterator<ColumnName> iterator() {
        return this.columns.keySet().iterator();
    }

    public Optional<Selector> getSelector(ColumnName columnName) {
        Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
        return Optional.ofNullable(this.columns.get(columnName));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Columns)) {
            return false;
        }
        Columns that = (Columns)object;
        return this.columns.equals(that.columns);
    }

    public int hashCode() {
        int result = 17;
        return result += 31 * ObjectUtils.nullSafeHashCode(this.columns);
    }

    public String toString() {
        Iterator<Map.Entry<ColumnName, Selector>> iterator = this.columns.entrySet().iterator();
        StringBuilder builder = this.toString(iterator);
        if (builder.length() == 0) {
            return "*";
        }
        return builder.toString();
    }

    private StringBuilder toString(Iterator<Map.Entry<ColumnName, Selector>> iterator) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        while (iterator.hasNext()) {
            Map.Entry<ColumnName, Selector> entry = iterator.next();
            Selector expression = entry.getValue();
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(expression.toString());
        }
        return builder;
    }

    public static class FunctionCall
    implements Selector {
        private final String expression;
        private final List<Object> params;
        private final Optional<CqlIdentifier> alias;

        FunctionCall(String expression, List<Object> params) {
            this.expression = expression;
            this.params = params;
            this.alias = Optional.empty();
        }

        private FunctionCall(String expression, List<Object> params, CqlIdentifier alias) {
            this.expression = expression;
            this.params = params;
            this.alias = Optional.of(alias);
        }

        public static FunctionCall from(String expression, Object ... params) {
            return new FunctionCall(expression, Arrays.asList(params));
        }

        public FunctionCall as(String alias) {
            return this.as(CqlIdentifier.of(alias));
        }

        public FunctionCall as(CqlIdentifier alias) {
            return new FunctionCall(this.expression, this.params, alias);
        }

        @Override
        public String getExpression() {
            return this.expression;
        }

        @Override
        public Optional<CqlIdentifier> getAlias() {
            return this.alias;
        }

        public List<Object> getParameters() {
            return this.params;
        }

        public String toString() {
            String parameters = StringUtils.collectionToDelimitedString(this.getParameters(), (String)", ");
            return this.getAlias().map(cqlIdentifier -> String.format("%s(%s) AS %s", this.getExpression(), parameters, cqlIdentifier.toCql())).orElseGet(() -> String.format("%s(%s)", this.getExpression(), parameters));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionCall)) {
                return false;
            }
            FunctionCall other = (FunctionCall)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$expression = this.getExpression();
            String other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            List<Object> this$params = this.params;
            List<Object> other$params = other.params;
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            Optional<CqlIdentifier> this$alias = this.getAlias();
            Optional<CqlIdentifier> other$alias = other.getAlias();
            return !(this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FunctionCall;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            List<Object> $params = this.params;
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            Optional<CqlIdentifier> $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
            return result;
        }
    }

    public static class ColumnSelector
    implements Selector {
        private final ColumnName columnName;
        private final Optional<CqlIdentifier> alias;

        ColumnSelector(ColumnName columnName) {
            Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
            this.columnName = columnName;
            this.alias = Optional.empty();
        }

        ColumnSelector(ColumnName columnName, CqlIdentifier alias) {
            Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
            Assert.notNull((Object)alias, (String)"Alias must not be null");
            this.columnName = columnName;
            this.alias = Optional.of(alias);
        }

        public static ColumnSelector from(ColumnName columnName) {
            return new ColumnSelector(columnName);
        }

        public static ColumnSelector from(CqlIdentifier columnName) {
            return ColumnSelector.from(ColumnName.from(columnName));
        }

        public static ColumnSelector from(String columnName) {
            return ColumnSelector.from(ColumnName.from(columnName));
        }

        public ColumnSelector as(String alias) {
            return this.as(CqlIdentifier.of(alias));
        }

        public ColumnSelector as(CqlIdentifier alias) {
            return new ColumnSelector(this.columnName, alias);
        }

        @Override
        public Optional<CqlIdentifier> getAlias() {
            return this.alias;
        }

        @Override
        public String getExpression() {
            return this.columnName.toCql();
        }

        public String toString() {
            return this.getAlias().map(cqlIdentifier -> String.format("%s AS %s", this.getExpression(), cqlIdentifier.toCql())).orElseGet(this::getExpression);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnSelector)) {
                return false;
            }
            ColumnSelector other = (ColumnSelector)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ColumnName this$columnName = this.columnName;
            ColumnName other$columnName = other.columnName;
            if (this$columnName == null ? other$columnName != null : !((Object)this$columnName).equals(other$columnName)) {
                return false;
            }
            Optional<CqlIdentifier> this$alias = this.getAlias();
            Optional<CqlIdentifier> other$alias = other.getAlias();
            return !(this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColumnSelector;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ColumnName $columnName = this.columnName;
            result = result * 59 + ($columnName == null ? 43 : ((Object)$columnName).hashCode());
            Optional<CqlIdentifier> $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
            return result;
        }
    }

    public static interface Selector {
        public String getExpression();

        public Optional<CqlIdentifier> getAlias();
    }
}

