/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.data.cassandra.repository.CassandraRepository;
import org.springframework.data.cassandra.repository.support.CassandraRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CassandraRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String CASSANDRA_TEMPLATE_REF = "cassandra-template-ref";

    public String getModuleName() {
        return "Cassandra";
    }

    protected String getModulePrefix() {
        return "cassandra";
    }

    public String getRepositoryFactoryBeanClassName() {
        return CassandraRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        String cassandraTemplateRef = Optional.ofNullable(element.getAttribute(CASSANDRA_TEMPLATE_REF)).filter(StringUtils::hasText).orElse("cassandraTemplate");
        builder.addPropertyReference("cassandraTemplate", cassandraTemplateRef);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        String cassandraTemplateRef = config.getAttributes().getString("cassandraTemplateRef");
        if (StringUtils.hasText((String)cassandraTemplateRef)) {
            builder.addPropertyReference("cassandraTemplate", cassandraTemplateRef);
        }
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Table.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(CassandraRepository.class);
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return !metadata.isReactiveRepository();
    }
}

