/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class MethodParameters {
    private static ParameterNameDiscoverer DISCOVERER = new DefaultParameterNameDiscoverer();
    private final List<MethodParameter> parameters;
    private final Map<Class<?>, List<MethodParameter>> parametersWithAnnotationCache = new ConcurrentReferenceHashMap();

    public MethodParameters(Method method) {
        this(method, null);
    }

    public MethodParameters(Method method, AnnotationAttribute namingAnnotation) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        this.parameters = new ArrayList<MethodParameter>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            AnnotationNamingMethodParameter parameter = new AnnotationNamingMethodParameter(method, i, namingAnnotation);
            parameter.initParameterNameDiscovery(DISCOVERER);
            this.parameters.add((MethodParameter)parameter);
        }
    }

    public List<MethodParameter> getParameters() {
        return this.parameters;
    }

    public MethodParameter getParameter(String name) {
        Assert.hasText((String)name, (String)"Parameter name must not be null!");
        for (MethodParameter parameter : this.parameters) {
            if (!name.equals(parameter.getParameterName())) continue;
            return parameter;
        }
        return null;
    }

    public List<MethodParameter> getParametersOfType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        ArrayList<MethodParameter> result = new ArrayList<MethodParameter>();
        for (MethodParameter parameter : this.getParameters()) {
            if (!parameter.getParameterType().equals(type)) continue;
            result.add(parameter);
        }
        return result;
    }

    public List<MethodParameter> getParametersWith(Class<? extends Annotation> annotation) {
        List<MethodParameter> cached = this.parametersWithAnnotationCache.get(annotation);
        if (cached != null) {
            return cached;
        }
        Assert.notNull(annotation, (String)"Annotation must not be null!");
        ArrayList<MethodParameter> result = new ArrayList<MethodParameter>();
        for (MethodParameter parameter : this.getParameters()) {
            if (!parameter.hasParameterAnnotation(annotation)) continue;
            result.add(parameter);
        }
        this.parametersWithAnnotationCache.put(annotation, result);
        return result;
    }

    private static class AnnotationNamingMethodParameter
    extends SynthesizingMethodParameter {
        private final AnnotationAttribute attribute;
        private String name;

        public AnnotationNamingMethodParameter(Method method, int parameterIndex, AnnotationAttribute attribute) {
            super(method, parameterIndex);
            this.attribute = attribute;
        }

        public String getParameterName() {
            String foundName;
            if (this.name != null) {
                return this.name;
            }
            if (this.attribute != null && (foundName = this.attribute.getValueFrom((MethodParameter)this)) != null) {
                this.name = foundName;
                return this.name;
            }
            this.name = super.getParameterName();
            return this.name;
        }
    }
}

