/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.tuple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.tuple.Tuple;

public class TupleToJsonStringConverter
implements Converter<Tuple, String> {
    private final ObjectMapper mapper = new ObjectMapper();

    public String convert(Tuple source) {
        ObjectNode root = this.toObjectNode(source);
        String json = null;
        try {
            json = this.mapper.writeValueAsString((Object)root);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Tuple to string conversion failed", e);
        }
        return json;
    }

    private ObjectNode toObjectNode(Tuple source) {
        ObjectNode root = this.mapper.createObjectNode();
        for (int i = 0; i < source.size(); ++i) {
            Object value = source.getValues().get(i);
            String name = source.getFieldNames().get(i);
            if (value == null) {
                root.putNull(name);
                continue;
            }
            root.putPOJO(name, (Object)this.toNode(value));
        }
        return root;
    }

    private ArrayNode toArrayNode(List<?> source) {
        ArrayNode array = this.mapper.createArrayNode();
        for (Object value : source) {
            if (value == null) continue;
            array.add((JsonNode)this.toNode(value));
        }
        return array;
    }

    private BaseJsonNode toNode(Object value) {
        if (value != null) {
            if (value instanceof Tuple) {
                return this.toObjectNode((Tuple)value);
            }
            if (value instanceof List) {
                return this.toArrayNode((List)value);
            }
            if (!value.getClass().isPrimitive()) {
                return this.mapper.getNodeFactory().pojoNode(value);
            }
            return (BaseJsonNode)this.mapper.valueToTree(value);
        }
        return null;
    }
}

