/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.remoting.support.RemoteInvocationTraceInterceptor;
import org.springframework.util.ClassUtils;

public abstract class RemoteExporter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object service;
    private Class serviceInterface;
    private boolean registerTraceInterceptor = true;

    public void setService(Object service) {
        this.service = service;
    }

    protected Object getService() {
        return this.service;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("serviceInterface must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    protected Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
        this.registerTraceInterceptor = registerTraceInterceptor;
    }

    protected boolean isRegisterTraceInterceptor() {
        return this.registerTraceInterceptor;
    }

    protected void checkService() throws IllegalArgumentException {
        if (this.service == null) {
            throw new IllegalArgumentException("service is required");
        }
    }

    protected void checkServiceInterface() throws IllegalArgumentException {
        if (this.serviceInterface == null) {
            throw new IllegalArgumentException("serviceInterface is required");
        }
        if (!this.serviceInterface.isInstance(this.service)) {
            throw new IllegalArgumentException("serviceInterface [" + this.serviceInterface.getName() + "] needs to be implemented by service [" + this.service + "] of class [" + this.service.getClass().getName() + "]");
        }
    }

    protected Object getProxyForService() {
        this.checkService();
        this.checkServiceInterface();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addInterface(this.getServiceInterface());
        if (this.isRegisterTraceInterceptor()) {
            proxyFactory.addAdvice(new RemoteInvocationTraceInterceptor(this.getExporterName()));
        }
        proxyFactory.setTarget(this.getService());
        return proxyFactory.getProxy();
    }

    protected String getExporterName() {
        return ClassUtils.getShortName(this.getClass());
    }
}

