/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class DefaultMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    private final Map multipartParams;

    public DefaultMultipartHttpServletRequest(HttpServletRequest request, Map multipartFiles, Map multipartParams) {
        super(request);
        this.setMultipartFiles(multipartFiles);
        this.multipartParams = multipartParams;
    }

    public Enumeration getParameterNames() {
        HashSet<Object> paramNames = new HashSet<Object>();
        Enumeration paramEnum = this.getRequest().getParameterNames();
        while (paramEnum.hasMoreElements()) {
            paramNames.add(paramEnum.nextElement());
        }
        paramNames.addAll(this.multipartParams.keySet());
        return Collections.enumeration(paramNames);
    }

    public String getParameter(String name) {
        String[] values = (String[])this.multipartParams.get(name);
        if (values != null) {
            return values.length > 0 ? values[0] : null;
        }
        return this.getRequest().getParameter(name);
    }

    public String[] getParameterValues(String name) {
        String[] values = (String[])this.multipartParams.get(name);
        if (values != null) {
            return values;
        }
        return this.getRequest().getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap paramMap = new HashMap();
        paramMap.putAll(this.getRequest().getParameterMap());
        paramMap.putAll(this.multipartParams);
        return paramMap;
    }
}

