/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.xslt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.core.NestedRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FormatHelper {
    public static Node dateTimeElement(long time, String language, String country) {
        Locale locale = FormatHelper.getLocale(language, country);
        return FormatHelper.dateTimeElement(time, locale);
    }

    public static Node dateTimeElement(long time) {
        return FormatHelper.dateTimeElement(time, Locale.getDefault());
    }

    public static Node dateTimeElement(long time, Locale locale) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element dateNode = doc.createElement("formatted-date");
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale);
            Date d = new Date(time);
            df.applyPattern("MMMM");
            FormatHelper.addChild(dateNode, "month", df.format(d));
            df.applyPattern("EEEE");
            FormatHelper.addChild(dateNode, "day-of-week", df.format(d));
            df.applyPattern("yyyy");
            FormatHelper.addChild(dateNode, "year", df.format(d));
            df.applyPattern("dd");
            FormatHelper.addChild(dateNode, "day-of-month", df.format(d));
            df.applyPattern("h");
            FormatHelper.addChild(dateNode, "hours", df.format(d));
            df.applyPattern("mm");
            FormatHelper.addChild(dateNode, "minutes", df.format(d));
            df.applyPattern("a");
            FormatHelper.addChild(dateNode, "am-pm", df.format(d));
            return dateNode;
        }
        catch (Exception ex) {
            throw new XsltFormattingException("Failed to create XML date element", ex);
        }
    }

    public static String currency(double amount, Locale locale) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(locale);
        return nf.format(amount);
    }

    public static String currency(double amount, String language, String country) {
        Locale locale = FormatHelper.getLocale(language, country);
        return FormatHelper.currency(amount, locale);
    }

    private static void addChild(Node parent, String name, String text) {
        Element child = parent.getOwnerDocument().createElement(name);
        child.appendChild(parent.getOwnerDocument().createTextNode(text));
        parent.appendChild(child);
    }

    private static Locale getLocale(String language, String country) {
        Locale locale = null;
        locale = language == null || country == null ? Locale.getDefault() : new Locale(language, country);
        return locale;
    }

    public static class XsltFormattingException
    extends NestedRuntimeException {
        public XsltFormattingException(String msg, Throwable ex) {
            super(msg, ex);
        }
    }
}

