/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ConstructorArgumentValues {
    private final Map indexedArgumentValues = new HashMap();
    private final List genericArgumentValues = new LinkedList();

    public ConstructorArgumentValues() {
    }

    public ConstructorArgumentValues(ConstructorArgumentValues other) {
        this.addArgumentValues(other);
    }

    public void addArgumentValues(ConstructorArgumentValues other) {
        if (other != null) {
            this.genericArgumentValues.addAll(other.genericArgumentValues);
            this.indexedArgumentValues.putAll(other.indexedArgumentValues);
        }
    }

    public void addIndexedArgumentValue(int index, Object value) {
        Assert.isTrue(index >= 0, "Index must not be negative");
        this.indexedArgumentValues.put(new Integer(index), new ValueHolder(value));
    }

    public void addIndexedArgumentValue(int index, Object value, String type) {
        Assert.isTrue(index >= 0, "Index must not be negative");
        this.indexedArgumentValues.put(new Integer(index), new ValueHolder(value, type));
    }

    public void addIndexedArgumentValue(int index, ValueHolder valueHolder) {
        Assert.isTrue(index >= 0, "Index must not be negative");
        Assert.notNull(valueHolder, "ValueHolder must not be null");
        this.indexedArgumentValues.put(new Integer(index), valueHolder);
    }

    public ValueHolder getIndexedArgumentValue(int index, Class requiredType) {
        Assert.isTrue(index >= 0, "Index must not be negative");
        ValueHolder valueHolder = (ValueHolder)this.indexedArgumentValues.get(new Integer(index));
        if (valueHolder != null && (valueHolder.getType() == null || requiredType != null && requiredType.getName().equals(valueHolder.getType()))) {
            return valueHolder;
        }
        return null;
    }

    public Map getIndexedArgumentValues() {
        return Collections.unmodifiableMap(this.indexedArgumentValues);
    }

    public void addGenericArgumentValue(Object value) {
        this.genericArgumentValues.add(new ValueHolder(value));
    }

    public void addGenericArgumentValue(Object value, String type) {
        this.genericArgumentValues.add(new ValueHolder(value, type));
    }

    public void addGenericArgumentValue(ValueHolder valueHolder) {
        Assert.notNull(valueHolder, "ValueHolder must not be null");
        this.genericArgumentValues.add(valueHolder);
    }

    public ValueHolder getGenericArgumentValue(Class requiredType) {
        return this.getGenericArgumentValue(requiredType, null);
    }

    public ValueHolder getGenericArgumentValue(Class requiredType, Set usedValueHolders) {
        Iterator it = this.genericArgumentValues.iterator();
        while (it.hasNext()) {
            ValueHolder valueHolder = (ValueHolder)it.next();
            if (usedValueHolders != null && usedValueHolders.contains(valueHolder) || !(requiredType != null ? (valueHolder.getType() != null ? valueHolder.getType().equals(requiredType.getName()) : ClassUtils.isAssignableValue(requiredType, valueHolder.getValue())) : valueHolder.getType() == null)) continue;
            return valueHolder;
        }
        return null;
    }

    public List getGenericArgumentValues() {
        return Collections.unmodifiableList(this.genericArgumentValues);
    }

    public ValueHolder getArgumentValue(int index, Class requiredType) {
        return this.getArgumentValue(index, requiredType, null);
    }

    public ValueHolder getArgumentValue(int index, Class requiredType, Set usedValueHolders) {
        Assert.isTrue(index >= 0, "Index must not be negative");
        ValueHolder valueHolder = this.getIndexedArgumentValue(index, requiredType);
        if (valueHolder == null) {
            valueHolder = this.getGenericArgumentValue(requiredType, usedValueHolders);
        }
        return valueHolder;
    }

    public int getArgumentCount() {
        return this.indexedArgumentValues.size() + this.genericArgumentValues.size();
    }

    public boolean isEmpty() {
        return this.indexedArgumentValues.isEmpty() && this.genericArgumentValues.isEmpty();
    }

    public void clear() {
        this.indexedArgumentValues.clear();
        this.genericArgumentValues.clear();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConstructorArgumentValues)) {
            return false;
        }
        ConstructorArgumentValues that = (ConstructorArgumentValues)other;
        if (this.genericArgumentValues.size() != that.genericArgumentValues.size() || this.indexedArgumentValues.size() != that.indexedArgumentValues.size()) {
            return false;
        }
        Iterator it1 = this.genericArgumentValues.iterator();
        Iterator it2 = that.genericArgumentValues.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            ValueHolder vh2;
            ValueHolder vh1 = (ValueHolder)it1.next();
            if (vh1.contentEquals(vh2 = (ValueHolder)it2.next())) continue;
            return false;
        }
        Iterator it = this.indexedArgumentValues.entrySet().iterator();
        while (it.hasNext()) {
            ValueHolder vh2;
            Map.Entry entry = it.next();
            ValueHolder vh1 = (ValueHolder)entry.getValue();
            if (vh1.contentEquals(vh2 = (ValueHolder)that.indexedArgumentValues.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.genericArgumentValues.size() * 29 + this.indexedArgumentValues.size();
    }

    public static class ValueHolder
    implements BeanMetadataElement {
        private Object value;
        private String type;
        private Object source;

        public ValueHolder(Object value) {
            this.value = value;
        }

        public ValueHolder(Object value, String type) {
            this.value = value;
            this.type = type;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setSource(Object source) {
            this.source = source;
        }

        public Object getSource() {
            return this.source;
        }

        private boolean contentEquals(ValueHolder other) {
            return this == other || ObjectUtils.nullSafeEquals(this.value, other.value) && ObjectUtils.nullSafeEquals(this.type, other.type);
        }
    }
}

