/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ClassFilters;
import org.springframework.util.Assert;

class UnionPointcut
implements Pointcut,
Serializable {
    private final Pointcut a;
    private final Pointcut b;
    private MethodMatcher methodMatcher;

    public UnionPointcut(Pointcut a, Pointcut b) {
        Assert.notNull(a, "First Pointcut must not be null");
        Assert.notNull(b, "Second Pointcut must not be null");
        this.a = a;
        this.b = b;
        this.methodMatcher = new PointcutUnionMethodMatcher();
    }

    public ClassFilter getClassFilter() {
        return ClassFilters.union(this.a.getClassFilter(), this.b.getClassFilter());
    }

    public MethodMatcher getMethodMatcher() {
        return this.methodMatcher;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnionPointcut)) {
            return false;
        }
        UnionPointcut that = (UnionPointcut)other;
        return this.a.equals(that.a) && this.b.equals(that.b);
    }

    public int hashCode() {
        int code = 17;
        code = 37 * code + this.a.hashCode();
        code = 37 * code + this.b.hashCode();
        return code;
    }

    private class PointcutUnionMethodMatcher
    implements MethodMatcher,
    Serializable {
        private PointcutUnionMethodMatcher() {
        }

        public boolean matches(Method method, Class targetClass) {
            return UnionPointcut.this.a.getClassFilter().matches(targetClass) && UnionPointcut.this.a.getMethodMatcher().matches(method, targetClass) || UnionPointcut.this.b.getClassFilter().matches(targetClass) && UnionPointcut.this.b.getMethodMatcher().matches(method, targetClass);
        }

        public boolean isRuntime() {
            return UnionPointcut.this.a.getMethodMatcher().isRuntime() || UnionPointcut.this.b.getMethodMatcher().isRuntime();
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            return UnionPointcut.this.a.getMethodMatcher().matches(method, targetClass, args) || UnionPointcut.this.b.getMethodMatcher().matches(method, targetClass, args);
        }
    }
}

