/*
 * Decompiled with CFR 0.152.
 */
package colorzoo.swing.gradient;

import colorzoo.swing.ColorUtil;
import colorzoo.swing.Thumb;
import colorzoo.swing.gradient.GradientPicker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class GradientPreviewPanel
extends JPanel {
    private Paint checker_texture = null;
    private Point2D start = new Point2D.Float(10.0f, 10.0f);
    private Point2D end = new Point2D.Float(80.0f, 10.0f);
    public GradientPicker picker;
    boolean moving_start = false;
    boolean moving_end = false;

    public GradientPreviewPanel() {
        this.checker_texture = ColorUtil.getCheckerPaint();
        GradientMouseHandler gradientMouseHandler = new GradientMouseHandler();
        this.addMouseListener(gradientMouseHandler);
        this.addMouseMotionListener(gradientMouseHandler);
    }

    public void setGradient() {
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.checker_texture);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            List<Thumb<Color>> list = this.picker.slider.getModel().getSortedThumbs();
            int n = list.size();
            float[] fArray = new float[n];
            Color[] colorArray = new Color[n];
            int n2 = 0;
            for (Thumb<Color> thumb : list) {
                colorArray[n2] = thumb.getObject();
                fArray[n2] = thumb.getPosition();
                ++n2;
            }
            MultipleGradientPaint multipleGradientPaint = this.calculateGradient(fArray, colorArray);
            if (multipleGradientPaint != null) {
                graphics2D.setPaint(multipleGradientPaint);
            } else {
                graphics2D.setPaint(Color.black);
            }
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.drawHandles(graphics2D);
        }
        catch (Exception exception) {
            System.out.println("ex: " + exception);
        }
    }

    private MultipleGradientPaint calculateGradient(float[] fArray, Color[] colorArray) {
        Point2D point2D = this.start;
        Point2D point2D2 = this.end;
        if (this.picker.reversed.isSelected()) {
            point2D = this.end;
            point2D2 = this.start;
        }
        MultipleGradientPaint.CycleMethodEnum cycleMethodEnum = MultipleGradientPaint.NO_CYCLE;
        if (this.picker.repeated.isSelected()) {
            cycleMethodEnum = MultipleGradientPaint.REPEAT;
        }
        if (this.picker.reflected.isSelected()) {
            cycleMethodEnum = MultipleGradientPaint.REFLECT;
        }
        MultipleGradientPaint multipleGradientPaint = null;
        if (this.picker.style_list.getSelectedItem().toString().equals("Linear")) {
            multipleGradientPaint = new LinearGradientPaint((float)point2D.getX(), (float)point2D.getY(), (float)point2D2.getX(), (float)point2D2.getY(), fArray, colorArray, cycleMethodEnum);
        }
        if (this.picker.style_list.getSelectedItem().toString().equals("Radial")) {
            multipleGradientPaint = new RadialGradientPaint(point2D, (float)point2D.distance(point2D2), point2D, fArray, colorArray, cycleMethodEnum, MultipleGradientPaint.SRGB);
        }
        return multipleGradientPaint;
    }

    private void drawHandles(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval((int)this.start.getX() - 5, (int)this.start.getY() - 5, 10, 10);
        graphics2D.setColor(Color.white);
        graphics2D.drawOval((int)this.start.getX() - 4, (int)this.start.getY() - 4, 8, 8);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval((int)this.end.getX() - 5, (int)this.end.getY() - 5, 10, 10);
        graphics2D.setColor(Color.white);
        graphics2D.drawOval((int)this.end.getX() - 4, (int)this.end.getY() - 4, 8, 8);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.end.getX(), (int)this.end.getY());
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine((int)this.start.getX() - 1, (int)this.start.getY() - 1, (int)this.end.getX() - 1, (int)this.end.getY() - 1);
    }

    private class GradientMouseHandler
    extends MouseInputAdapter {
        private GradientMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GradientPreviewPanel.this.moving_start = false;
            GradientPreviewPanel.this.moving_end = false;
            if (mouseEvent.getPoint().distance(GradientPreviewPanel.this.start) < 5.0) {
                GradientPreviewPanel.this.moving_start = true;
                GradientPreviewPanel.this.start = mouseEvent.getPoint();
                return;
            }
            if (mouseEvent.getPoint().distance(GradientPreviewPanel.this.end) < 5.0) {
                GradientPreviewPanel.this.moving_end = true;
                GradientPreviewPanel.this.end = mouseEvent.getPoint();
                return;
            }
            GradientPreviewPanel.this.start = mouseEvent.getPoint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (GradientPreviewPanel.this.moving_start) {
                GradientPreviewPanel.this.start = mouseEvent.getPoint();
            } else {
                GradientPreviewPanel.this.end = mouseEvent.getPoint();
            }
            GradientPreviewPanel.this.repaint();
        }
    }
}

