/*
 * Decompiled with CFR 0.152.
 */
package colorzoo.tilebuilder;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class TileBuilderEditorPanel
extends JPanel {
    private int gridwidth = 10;
    private int gridheight = 10;
    private int[][] gridcells = new int[this.getGridwidth()][this.getGridheight()];
    private int bgcolor = Color.black.getRGB();
    private int fgcolor = Color.red.getRGB();

    public TileBuilderEditorPanel() {
        Handler handler = new Handler();
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2 = this.getHeight() / this.getGridheight();
        int n3 = this.getWidth() / this.getGridwidth();
        graphics.setColor(new Color(this.getBgcolor()));
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (n = 0; n < this.getGridwidth(); ++n) {
            for (int i = 0; i < this.getGridheight(); ++i) {
                graphics.setColor(new Color(this.gridcells[n][i]));
                graphics.fillRect(n * n3, i * n2, n3, n2);
            }
        }
        graphics.setColor(Color.red);
        for (n = 0; n <= this.getGridwidth(); ++n) {
            graphics.drawLine(n * n3, 0, n * n3, this.getHeight());
        }
        for (n = 0; n <= this.getGridheight(); ++n) {
            graphics.drawLine(0, n * n2, this.getWidth(), n * n2);
        }
    }

    public Paint getTilePaint() {
        BufferedImage bufferedImage = new BufferedImage(this.getGridwidth(), this.getGridheight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        for (int i = 0; i < this.getGridwidth(); ++i) {
            for (int j = 0; j < this.getGridheight(); ++j) {
                graphics.setColor(new Color(this.gridcells[i][j]));
                graphics.drawLine(i, j, i, j);
            }
        }
        TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, this.getGridwidth(), this.getGridheight()));
        return texturePaint;
    }

    private void rebuildGrid() {
        int[][] nArray = new int[this.gridwidth][this.gridheight];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                nArray[i][j] = this.getBgcolor();
                if (i >= this.gridcells.length || j >= this.gridcells[0].length) continue;
                nArray[i][j] = this.gridcells[i][j];
            }
        }
        this.gridcells = nArray;
        this.repaint();
        this.firePropertyChange("grid", false, true);
    }

    public int getGridwidth() {
        return this.gridwidth;
    }

    public void setGridwidth(int n) {
        this.gridwidth = n;
        this.rebuildGrid();
    }

    public int getGridheight() {
        return this.gridheight;
    }

    public void setGridheight(int n) {
        this.gridheight = n;
        this.rebuildGrid();
    }

    public int getBgcolor() {
        return this.bgcolor;
    }

    public void setBgcolor(int n) {
        this.bgcolor = n;
    }

    public int getFgcolor() {
        return this.fgcolor;
    }

    public void setFgcolor(int n) {
        this.fgcolor = n;
    }

    public void setTilePaint(BufferedImage bufferedImage) {
        this.setGridwidth(bufferedImage.getWidth());
        this.setGridheight(bufferedImage.getHeight());
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                this.gridcells[i][j] = bufferedImage.getRGB(i, j);
            }
        }
        this.repaint();
    }

    private class Handler
    extends MouseInputAdapter {
        Point last_cell;
        int last_color;

        private Handler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            int n2 = TileBuilderEditorPanel.this.getWidth() / TileBuilderEditorPanel.this.getGridwidth();
            int n3 = TileBuilderEditorPanel.this.getHeight() / TileBuilderEditorPanel.this.getGridheight();
            int n4 = mouseEvent.getX() / n2;
            if (n4 >= TileBuilderEditorPanel.this.getGridwidth()) {
                return;
            }
            int n5 = mouseEvent.getY() / n3;
            if (n5 >= TileBuilderEditorPanel.this.getGridheight()) {
                return;
            }
            int n6 = TileBuilderEditorPanel.this.gridcells[n4][n5];
            if (n6 == (n = TileBuilderEditorPanel.this.getFgcolor())) {
                n = TileBuilderEditorPanel.this.getBgcolor();
            }
            ((TileBuilderEditorPanel)TileBuilderEditorPanel.this).gridcells[n4][n5] = n;
            this.last_cell = new Point(n4, n5);
            this.last_color = n;
            TileBuilderEditorPanel.this.firePropertyChange("grid", n6, n);
            TileBuilderEditorPanel.this.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = TileBuilderEditorPanel.this.getWidth() / TileBuilderEditorPanel.this.getGridwidth();
            int n2 = TileBuilderEditorPanel.this.getHeight() / TileBuilderEditorPanel.this.getGridheight();
            int n3 = mouseEvent.getX() / n;
            if (n3 >= TileBuilderEditorPanel.this.getGridwidth()) {
                return;
            }
            int n4 = mouseEvent.getY() / n2;
            if (n4 >= TileBuilderEditorPanel.this.getGridheight()) {
                return;
            }
            int n5 = TileBuilderEditorPanel.this.gridcells[n3][n4];
            int n6 = this.last_color;
            Point point = new Point(n3, n4);
            if (point.equals(this.last_cell)) {
                return;
            }
            ((TileBuilderEditorPanel)TileBuilderEditorPanel.this).gridcells[n3][n4] = n6;
            this.last_cell = new Point(n3, n4);
            TileBuilderEditorPanel.this.firePropertyChange("grid", n5, n6);
            TileBuilderEditorPanel.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.last_cell = null;
            this.last_color = -1;
        }
    }
}

