/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.block;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import tachyon.client.ClientContext;
import tachyon.client.RemoteBlockReader;
import tachyon.client.block.BufferedBlockInStream;

public final class RemoteBlockInStream
extends BufferedBlockInStream {
    public RemoteBlockInStream(long blockId, long blockSize, InetSocketAddress location) {
        super(blockId, blockSize, location);
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        ClientContext.getClientMetrics().incBlocksReadRemote(1L);
        this.mClosed = true;
    }

    @Override
    protected void bufferedRead(int len) throws IOException {
        this.mBuffer.clear();
        int bytesRead = this.readFromRemote(this.mBuffer.array(), 0, len);
        this.mBuffer.limit(bytesRead);
    }

    @Override
    protected int directRead(byte[] b, int off, int len) throws IOException {
        return this.readFromRemote(b, off, len);
    }

    @Override
    protected void incrementBytesReadMetric(int bytes) {
        ClientContext.getClientMetrics().incBytesReadRemote(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readFromRemote(byte[] b, int off, int len) throws IOException {
        int toRead;
        int bytesLeft = toRead = (int)Math.min((long)len, this.remaining());
        while (bytesLeft > 0) {
            RemoteBlockReader reader = RemoteBlockReader.Factory.createRemoteBlockReader(ClientContext.getConf());
            try {
                ByteBuffer data = reader.readRemoteBlock(this.mLocation, this.mBlockId, this.getPosition(), bytesLeft);
                int bytesRead = data.remaining();
                data.get(b, off, bytesRead);
                bytesLeft -= bytesRead;
                this.incrementBytesReadMetric(bytesRead);
            }
            finally {
                reader.close();
            }
        }
        return toRead;
    }
}

