/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.lineage;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.lineage.LineageClient;
import tachyon.client.lineage.LineageContext;
import tachyon.client.lineage.LineageMasterClient;
import tachyon.client.lineage.options.CreateLineageOptions;
import tachyon.client.lineage.options.DeleteLineageOptions;
import tachyon.client.lineage.options.GetLineageInfoListOptions;
import tachyon.exception.FileDoesNotExistException;
import tachyon.exception.LineageDeletionException;
import tachyon.exception.LineageDoesNotExistException;
import tachyon.exception.TachyonException;
import tachyon.job.CommandLineJob;
import tachyon.job.Job;
import tachyon.thrift.LineageInfo;

public abstract class AbstractLineageClient
implements LineageClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    protected LineageContext mContext = LineageContext.INSTANCE;

    @Override
    public long createLineage(List<TachyonURI> inputFiles, List<TachyonURI> outputFiles, Job job, CreateLineageOptions options) throws FileDoesNotExistException, TachyonException, IOException {
        Preconditions.checkState((boolean)(job instanceof CommandLineJob), (Object)"only command line job supported");
        LineageMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            long lineageId = masterClient.createLineage(this.stripURIList(inputFiles), this.stripURIList(outputFiles), (CommandLineJob)job);
            LOG.info("Created lineage " + lineageId);
            long l = lineageId;
            return l;
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, FileDoesNotExistException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    @Override
    public boolean deleteLineage(long lineageId, DeleteLineageOptions options) throws IOException, LineageDoesNotExistException, LineageDeletionException, TachyonException {
        LineageMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            boolean result = masterClient.deleteLineage(lineageId, options.isCascade());
            LOG.info(result ? "Succeeded to " : "Failed to delete lineage " + lineageId);
            boolean bl = result;
            return bl;
        }
        catch (TachyonException e) {
            TachyonException.unwrap(e, LineageDoesNotExistException.class);
            TachyonException.unwrap(e, LineageDeletionException.class);
            throw e;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LineageInfo> getLineageInfoList(GetLineageInfoListOptions options) throws IOException {
        LineageMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            List<LineageInfo> result;
            List<LineageInfo> list = result = masterClient.getLineageInfoList();
            return list;
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    private List<String> stripURIList(List<TachyonURI> uris) {
        ArrayList<String> pathStrings = new ArrayList<String>(uris.size());
        for (TachyonURI uri : uris) {
            pathStrings.add(uri.getPath());
        }
        return pathStrings;
    }
}

