/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import tachyon.client.ClientContext;
import tachyon.client.netty.ClientHandler;
import tachyon.conf.TachyonConf;
import tachyon.network.ChannelType;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCMessageDecoder;
import tachyon.network.protocol.RPCMessageEncoder;
import tachyon.util.network.NettyUtils;

public final class NettyClient {
    private static final RPCMessageEncoder ENCODER = new RPCMessageEncoder();
    private static final RPCMessageDecoder DECODER = new RPCMessageDecoder();
    private static final TachyonConf TACHYON_CONF = ClientContext.getConf();
    private static final ChannelType CHANNEL_TYPE = TACHYON_CONF.getEnum("tachyon.user.network.netty.channel", ChannelType.class);
    private static final Class<? extends SocketChannel> CLIENT_CHANNEL_CLASS = NettyUtils.getClientChannelClass(CHANNEL_TYPE);
    private static final EventLoopGroup WORKER_GROUP = NettyUtils.createEventLoop(CHANNEL_TYPE, TACHYON_CONF.getInt("tachyon.user.network.netty.worker.threads"), "netty-client-worker-%d", true);
    public static final long TIMEOUT_MS = TACHYON_CONF.getInt("tachyon.user.network.netty.timeout.ms");

    public static Bootstrap createClientBootstrap(final ClientHandler handler) {
        Bootstrap boot = new Bootstrap();
        ((Bootstrap)boot.group(WORKER_GROUP)).channel(CLIENT_CHANNEL_CLASS);
        boot.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        boot.option(ChannelOption.TCP_NODELAY, (Object)true);
        boot.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        boot.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{RPCMessage.createFrameDecoder()});
                pipeline.addLast(new ChannelHandler[]{ENCODER});
                pipeline.addLast(new ChannelHandler[]{DECODER});
                pipeline.addLast(new ChannelHandler[]{handler});
            }
        });
        return boot;
    }
}

