/*
 * Decompiled with CFR 0.152.
 */
package tachyon.heartbeat;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.heartbeat.HeartbeatTimer;

public final class HeartbeatContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static Map<String, Class<HeartbeatTimer>> sTimerClasses;
    public static final Class<HeartbeatTimer> SCHEDULED_TIMER_CLASS;
    public static final Class<HeartbeatTimer> SLEEPING_TIMER_CLASS;
    public static final String MASTER_CHECKPOINT_SCHEDULING = "Master Checkpoint Scheduling";
    public static final String MASTER_FILE_RECOMPUTATION = "Master File Recomputation";
    public static final String MASTER_LOST_WORKER_DETECTION = "Master Lost Worker Detection";
    public static final String MASTER_TTL_CHECK = "Master TTL Check";
    public static final String WORKER_LINEAGE_SYNC = "Worker Lineage Sync";
    public static final String WORKER_CLIENT = "Worker Client";

    private HeartbeatContext() {
    }

    public static synchronized Class<HeartbeatTimer> getTimerClass(String name) {
        return sTimerClasses.get(name);
    }

    public static synchronized void setTimerClass(String name, Class<HeartbeatTimer> timerClass) {
        sTimerClasses.put(name, timerClass);
    }

    static {
        try {
            SCHEDULED_TIMER_CLASS = Class.forName("tachyon.heartbeat.ScheduledTimer");
            SLEEPING_TIMER_CLASS = Class.forName("tachyon.heartbeat.SleepingTimer");
        }
        catch (Exception e) {
            throw new RuntimeException("requested class could not be loaded: " + e.getMessage());
        }
        sTimerClasses = new HashMap<String, Class<HeartbeatTimer>>();
        sTimerClasses.put(MASTER_CHECKPOINT_SCHEDULING, SLEEPING_TIMER_CLASS);
        sTimerClasses.put(MASTER_FILE_RECOMPUTATION, SLEEPING_TIMER_CLASS);
        sTimerClasses.put(MASTER_LOST_WORKER_DETECTION, SLEEPING_TIMER_CLASS);
        sTimerClasses.put(MASTER_TTL_CHECK, SLEEPING_TIMER_CLASS);
        sTimerClasses.put(WORKER_LINEAGE_SYNC, SLEEPING_TIMER_CLASS);
        sTimerClasses.put(WORKER_CLIENT, SLEEPING_TIMER_CLASS);
    }
}

