/*
 * Decompiled with CFR 0.152.
 */
package tachyon.job;

import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.job.Job;
import tachyon.job.JobConf;
import tachyon.thrift.CommandLineJobInfo;
import tachyon.thrift.JobConfInfo;

public class CommandLineJob
extends Job {
    private static final long serialVersionUID = 1655996721855899996L;
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final String mCommand;

    public CommandLineJob(String command, JobConf jobConf) {
        super(jobConf);
        this.mCommand = command;
    }

    public CommandLineJobInfo generateCommandLineJobInfo() {
        return new CommandLineJobInfo(this.mCommand, new JobConfInfo(this.getJobConf().getOutputFilePath()));
    }

    public String getCommand() {
        return this.mCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run() {
        try {
            String outputPath = this.getJobConf().getOutputFilePath();
            LOG.info("Exec " + this.mCommand + " output to " + outputPath);
            Process p = Runtime.getRuntime().exec(this.mCommand);
            Closer closer = Closer.create();
            try {
                String line;
                BufferedReader bri = (BufferedReader)closer.register((Closeable)new BufferedReader(new InputStreamReader(p.getInputStream())));
                BufferedReader bre = (BufferedReader)closer.register((Closeable)new BufferedReader(new InputStreamReader(p.getErrorStream())));
                File file = new File(outputPath);
                FileWriter fw = new FileWriter(file.getAbsoluteFile());
                BufferedWriter bw = (BufferedWriter)closer.register((Closeable)new BufferedWriter(fw));
                while ((line = bri.readLine()) != null) {
                    bw.write(line + "\n");
                }
                while ((line = bre.readLine()) != null) {
                    bw.write(line + "\n");
                }
                bw.flush();
            }
            finally {
                closer.close();
            }
            p.waitFor();
            LOG.info("Exec " + this.mCommand + " output to " + outputPath + " done.");
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage());
            return false;
        }
        return true;
    }

    public String toString() {
        return "Command line job, command:" + this.mCommand;
    }
}

