/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class AnswerInlineQuery
extends BotApiMethod<Boolean> {
    public static final String PATH = "answerInlineQuery";
    private static final String INLINEQUERYID_FIELD = "inline_query_id";
    private static final String RESULTS_FIELD = "results";
    private static final String CACHETIME_FIELD = "cache_time";
    private static final String ISPERSONAL_FIELD = "is_personal";
    private static final String NEXTOFFSET_FIELD = "next_offset";
    private static final String SWITCH_PM_TEXT_FIELD = "switch_pm_text";
    private static final String SWITCH_PM_PARAMETER_FIELD = "switch_pm_parameter";
    @JsonProperty(value="inline_query_id")
    private String inlineQueryId;
    @JsonProperty(value="results")
    private List<InlineQueryResult> results;
    @JsonProperty(value="cache_time")
    private Integer cacheTime;
    @JsonProperty(value="is_personal")
    private Boolean isPersonal;
    @JsonProperty(value="next_offset")
    private String nextOffset;
    @JsonProperty(value="switch_pm_text")
    private String switchPmText;
    @JsonProperty(value="switch_pm_parameter")
    private String switchPmParameter;

    public String getInlineQueryId() {
        return this.inlineQueryId;
    }

    public AnswerInlineQuery setInlineQueryId(String inlineQueryId) {
        this.inlineQueryId = inlineQueryId;
        return this;
    }

    public List<InlineQueryResult> getResults() {
        return this.results;
    }

    public AnswerInlineQuery setResults(List<InlineQueryResult> results) {
        this.results = results;
        return this;
    }

    @JsonIgnore
    public AnswerInlineQuery setResults(InlineQueryResult ... results) {
        this.results = Arrays.asList(results);
        return this;
    }

    public Integer getCacheTime() {
        return this.cacheTime;
    }

    public AnswerInlineQuery setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
        return this;
    }

    public Boolean isPersonal() {
        return this.isPersonal;
    }

    public AnswerInlineQuery setPersonal(Boolean personal) {
        this.isPersonal = personal;
        return this;
    }

    public String getNextOffset() {
        return this.nextOffset;
    }

    public AnswerInlineQuery setNextOffset(String nextOffset) {
        this.nextOffset = nextOffset;
        return this;
    }

    public String getSwitchPmText() {
        return this.switchPmText;
    }

    public AnswerInlineQuery setSwitchPmText(String switchPmText) {
        this.switchPmText = switchPmText;
        return this;
    }

    public String getSwitchPmParameter() {
        return this.switchPmParameter;
    }

    public AnswerInlineQuery setSwitchPmParameter(String switchPmParameter) {
        this.switchPmParameter = switchPmParameter;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineQueryId == null) {
            throw new TelegramApiValidationException("InlineQueryId can't be empty", this);
        }
        if (this.results == null) {
            throw new TelegramApiValidationException("Results array can't be null", this);
        }
        for (InlineQueryResult result : this.results) {
            result.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error answering inline query", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public String toString() {
        return "AnswerInlineQuery{inlineQueryId='" + this.inlineQueryId + '\'' + ", results=" + this.results + ", cacheTime=" + this.cacheTime + ", isPersonal=" + this.isPersonal + ", switchPmText=" + this.switchPmText + ", switchPmParameter=" + this.switchPmParameter + ", nextOffset='" + this.nextOffset + '\'' + '}';
    }
}

