/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.telegram.telegrambots.api.interfaces.InputBotApiObject;
import org.telegram.telegrambots.api.interfaces.Validable;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class KeyboardButton
implements InputBotApiObject,
Validable {
    private static final String TEXT_FIELD = "text";
    private static final String REQUEST_CONTACT_FIELD = "request_contact";
    private static final String REQUEST_LOCATION_FIELD = "request_location";
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="request_contact")
    private Boolean requestContact;
    @JsonProperty(value="request_location")
    private Boolean requestLocation;

    public KeyboardButton() {
    }

    public KeyboardButton(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public KeyboardButton setText(String text) {
        this.text = text;
        return this;
    }

    public Boolean getRequestContact() {
        return this.requestContact;
    }

    public KeyboardButton setRequestContact(Boolean requestContact) {
        this.requestContact = requestContact;
        return this;
    }

    public Boolean getRequestLocation() {
        return this.requestLocation;
    }

    public KeyboardButton setRequestLocation(Boolean requestLocation) {
        this.requestLocation = requestLocation;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.requestContact != null && this.requestLocation != null && this.requestContact.booleanValue() && this.requestLocation.booleanValue()) {
            throw new TelegramApiValidationException("Cant request contact and location at the same time", this);
        }
    }

    public String toString() {
        return "KeyboardButton{text=" + this.text + ", requestContact=" + this.requestContact + ", requestLocation=" + this.requestLocation + '}';
    }
}

