/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.testcontainers.containers.ContainerDef;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;

public class KafkaContainer
extends GenericContainer<KafkaContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"confluentinc/cp-kafka");
    private static final String DEFAULT_TAG = "5.4.3";
    public static final int KAFKA_PORT = 9093;
    public static final int ZOOKEEPER_PORT = 2181;
    private static final String DEFAULT_INTERNAL_TOPIC_RF = "1";
    private static final String STARTER_SCRIPT = "/tmp/testcontainers_start.sh";
    private static final String MIN_KRAFT_TAG = "7.0.0";
    public static final String DEFAULT_CLUSTER_ID = "4L6g3nShT-eMCtK--X86sw";
    protected String externalZookeeperConnect = null;
    private boolean kraftEnabled = false;
    private static final String PROTOCOL_PREFIX = "TC";

    @Deprecated
    public KafkaContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    @Deprecated
    public KafkaContainer(String confluentPlatformVersion) {
        this(DEFAULT_IMAGE_NAME.withTag(confluentPlatformVersion));
    }

    public KafkaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
    }

    KafkaContainerDef createContainerDef() {
        return new KafkaContainerDef();
    }

    KafkaContainerDef getContainerDef() {
        return (KafkaContainerDef)super.getContainerDef();
    }

    public KafkaContainer withEmbeddedZookeeper() {
        if (this.kraftEnabled) {
            throw new IllegalStateException("Cannot configure Zookeeper when using Kraft mode");
        }
        this.externalZookeeperConnect = null;
        return (KafkaContainer)this.self();
    }

    public KafkaContainer withExternalZookeeper(String connectString) {
        if (this.kraftEnabled) {
            throw new IllegalStateException("Cannot configure Zookeeper when using Kraft mode");
        }
        this.externalZookeeperConnect = connectString;
        return (KafkaContainer)this.self();
    }

    public KafkaContainer withKraft() {
        if (this.externalZookeeperConnect != null) {
            throw new IllegalStateException("Cannot configure Kraft mode when Zookeeper configured");
        }
        this.verifyMinKraftVersion();
        this.kraftEnabled = true;
        return (KafkaContainer)this.self();
    }

    private void verifyMinKraftVersion() {
        String actualVersion = DockerImageName.parse((String)this.getDockerImageName()).getVersionPart();
        if (new ComparableVersion(actualVersion).isLessThan(MIN_KRAFT_TAG)) {
            throw new IllegalArgumentException(String.format("Provided Confluent Platform's version %s is not supported in Kraft mode (must be %s or above)", actualVersion, MIN_KRAFT_TAG));
        }
    }

    private boolean isLessThanCP740() {
        String actualVersion = DockerImageName.parse((String)this.getDockerImageName()).getVersionPart();
        return new ComparableVersion(actualVersion).isLessThan("7.4.0");
    }

    public KafkaContainer withClusterId(String clusterId) {
        Objects.requireNonNull(clusterId, "clusterId cannot be null");
        this.getContainerDef().withClusterId(clusterId);
        return (KafkaContainer)this.self();
    }

    public String getBootstrapServers() {
        return String.format("PLAINTEXT://%s:%s", this.getHost(), this.getMappedPort(9093));
    }

    protected void configure() {
        this.getContainerDef().resolveListeners();
        if (this.kraftEnabled) {
            this.configureKraft();
        } else {
            this.configureZookeeper();
        }
    }

    protected void configureKraft() {
        this.getContainerDef().withRaft();
    }

    protected void configureZookeeper() {
        if (this.externalZookeeperConnect == null) {
            this.getContainerDef().withEmbeddedZookeeper();
        } else {
            this.getContainerDef().withZookeeper(this.externalZookeeperConnect);
        }
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        super.containerIsStarting(containerInfo);
        ArrayList<String> advertisedListeners = new ArrayList<String>();
        advertisedListeners.add(this.getBootstrapServers());
        advertisedListeners.add(this.brokerAdvertisedListener(containerInfo));
        ArrayList listenersToTransform = new ArrayList(this.getContainerDef().listeners);
        for (int i = 0; i < listenersToTransform.size(); ++i) {
            Supplier listenerSupplier = (Supplier)listenersToTransform.get(i);
            String protocol = String.format("%s-%d", PROTOCOL_PREFIX, i);
            String listener = (String)listenerSupplier.get();
            String listenerProtocol = String.format("%s://%s", protocol, listener);
            advertisedListeners.add(listenerProtocol);
        }
        String kafkaAdvertisedListeners = String.join((CharSequence)",", advertisedListeners);
        String command = "#!/bin/bash\n";
        command = command + String.format("export KAFKA_ADVERTISED_LISTENERS=%s\n", kafkaAdvertisedListeners);
        if (!this.kraftEnabled || this.isLessThanCP740()) {
            command = command + "echo '' > /etc/confluent/docker/ensure \n";
        }
        if (this.kraftEnabled) {
            command = command + this.commandKraft();
        } else if (this.externalZookeeperConnect == null) {
            command = command + this.commandZookeeper();
        }
        command = command + "/etc/confluent/docker/run \n";
        this.copyFileToContainer(Transferable.of((String)command, (int)511), STARTER_SCRIPT);
    }

    protected String commandKraft() {
        String command = "sed -i '/KAFKA_ZOOKEEPER_CONNECT/d' /etc/confluent/docker/configure\n";
        command = command + "echo 'kafka-storage format --ignore-formatted -t \"" + (String)this.getContainerDef().getEnvVars().get("CLUSTER_ID") + "\" -c /etc/kafka/kafka.properties' >> /etc/confluent/docker/configure\n";
        return command;
    }

    protected String commandZookeeper() {
        String command = "echo 'clientPort=2181' > /tmp/zookeeper.properties\n";
        command = command + "echo 'dataDir=/var/lib/zookeeper/data' >> /tmp/zookeeper.properties\n";
        command = command + "echo 'dataLogDir=/var/lib/zookeeper/log' >> /tmp/zookeeper.properties\n";
        command = command + "zookeeper-server-start /tmp/zookeeper.properties &\n";
        return command;
    }

    public KafkaContainer withListener(Supplier<String> listenerSupplier) {
        this.getContainerDef().withListener(listenerSupplier);
        return this;
    }

    protected String brokerAdvertisedListener(InspectContainerResponse containerInfo) {
        return String.format("BROKER://%s:%s", containerInfo.getConfig().getHostName(), "9092");
    }

    private static class KafkaContainerDef
    extends ContainerDef {
        private final Set<Supplier<String>> listeners = new HashSet<Supplier<String>>();
        private String clusterId = "4L6g3nShT-eMCtK--X86sw";

        KafkaContainerDef() {
            this.addEnvVar("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9093,BROKER://0.0.0.0:9092");
            this.addEnvVar("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "BROKER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            this.addEnvVar("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
            this.addEnvVar("KAFKA_BROKER_ID", KafkaContainer.DEFAULT_INTERNAL_TOPIC_RF);
            this.addEnvVar("KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR", KafkaContainer.DEFAULT_INTERNAL_TOPIC_RF);
            this.addEnvVar("KAFKA_OFFSETS_TOPIC_NUM_PARTITIONS", KafkaContainer.DEFAULT_INTERNAL_TOPIC_RF);
            this.addEnvVar("KAFKA_TRANSACTION_STATE_LOG_REPLICATION_FACTOR", KafkaContainer.DEFAULT_INTERNAL_TOPIC_RF);
            this.addEnvVar("KAFKA_TRANSACTION_STATE_LOG_MIN_ISR", KafkaContainer.DEFAULT_INTERNAL_TOPIC_RF);
            this.addEnvVar("KAFKA_LOG_FLUSH_INTERVAL_MESSAGES", "9223372036854775807");
            this.addEnvVar("KAFKA_GROUP_INITIAL_REBALANCE_DELAY_MS", "0");
            this.addExposedTcpPort(9093);
            this.setEntrypoint(new String[]{"sh"});
            this.setCommand(new String[]{"-c", "while [ ! -f /tmp/testcontainers_start.sh ]; do sleep 0.1; done; /tmp/testcontainers_start.sh"});
            this.setWaitStrategy((WaitStrategy)Wait.forLogMessage((String)".*\\[KafkaServer id=\\d+\\] started.*", (int)1));
        }

        private void resolveListeners() {
            Set listeners = Arrays.stream(((String)this.envVars.get("KAFKA_LISTENERS")).split(",")).collect(Collectors.toSet());
            Set listenerSecurityProtocolMap = Arrays.stream(((String)this.envVars.get("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP")).split(",")).collect(Collectors.toSet());
            ArrayList<Supplier<String>> listenersToTransform = new ArrayList<Supplier<String>>(this.listeners);
            for (int i = 0; i < listenersToTransform.size(); ++i) {
                Supplier listenerSupplier = (Supplier)listenersToTransform.get(i);
                String protocol = String.format("%s-%d", KafkaContainer.PROTOCOL_PREFIX, i);
                String listener = (String)listenerSupplier.get();
                String listenerPort = listener.split(":")[1];
                String listenerProtocol = String.format("%s://0.0.0.0:%s", protocol, listenerPort);
                String protocolMap = String.format("%s:PLAINTEXT", protocol);
                listeners.add(listenerProtocol);
                listenerSecurityProtocolMap.add(protocolMap);
                String host = listener.split(":")[0];
                this.addNetworkAlias(host);
            }
            String kafkaListeners = String.join((CharSequence)",", listeners);
            String kafkaListenerSecurityProtocolMap = String.join((CharSequence)",", listenerSecurityProtocolMap);
            this.envVars.put("KAFKA_LISTENERS", kafkaListeners);
            this.envVars.put("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", kafkaListenerSecurityProtocolMap);
        }

        void withListener(Supplier<String> listenerSupplier) {
            this.listeners.add(listenerSupplier);
        }

        void withEmbeddedZookeeper() {
            this.addExposedTcpPort(2181);
            this.addEnvVar("KAFKA_ZOOKEEPER_CONNECT", "localhost:2181");
        }

        void withZookeeper(String connectionString) {
            this.addEnvVar("KAFKA_ZOOKEEPER_CONNECT", connectionString);
        }

        void withClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        void withRaft() {
            this.envVars.computeIfAbsent("CLUSTER_ID", key -> this.clusterId);
            this.envVars.computeIfAbsent("KAFKA_NODE_ID", key -> (String)this.getEnvVars().get("KAFKA_BROKER_ID"));
            this.addEnvVar("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", this.kafkaListenerSecurityProtocolMap());
            this.addEnvVar("KAFKA_LISTENERS", this.kafkaListeners());
            this.addEnvVar("KAFKA_PROCESS_ROLES", "broker,controller");
            String firstNetworkAlias = this.getNetworkAliases().stream().findFirst().orElse(null);
            String networkAlias = this.getNetwork() != null ? firstNetworkAlias : "localhost";
            String controllerQuorumVoters = String.format("%s@%s:9094", this.getEnvVars().get("KAFKA_NODE_ID"), networkAlias);
            this.envVars.computeIfAbsent("KAFKA_CONTROLLER_QUORUM_VOTERS", key -> controllerQuorumVoters);
            this.addEnvVar("KAFKA_CONTROLLER_LISTENER_NAMES", "CONTROLLER");
            this.setWaitStrategy((WaitStrategy)Wait.forLogMessage((String)".*Transitioning from RECOVERY to RUNNING.*", (int)1));
        }

        private String kafkaListenerSecurityProtocolMap() {
            String kafkaListenerSecurityProtocolMapEnvVar = (String)this.getEnvVars().get("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP");
            String kafkaListenerSecurityProtocolMap = String.format("%s,CONTROLLER:PLAINTEXT", kafkaListenerSecurityProtocolMapEnvVar);
            HashSet<String> listenerSecurityProtocolMap = new HashSet<String>(Arrays.asList(kafkaListenerSecurityProtocolMap.split(",")));
            return String.join((CharSequence)",", listenerSecurityProtocolMap);
        }

        private String kafkaListeners() {
            String kafkaListenersEnvVar = (String)this.getEnvVars().get("KAFKA_LISTENERS");
            String kafkaListeners = String.format("%s,CONTROLLER://0.0.0.0:9094", kafkaListenersEnvVar);
            HashSet<String> listeners = new HashSet<String>(Arrays.asList(kafkaListeners.split(",")));
            return String.join((CharSequence)",", listeners);
        }
    }
}

