/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.arguments;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.BackQuotesState;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.QuotesState;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.as.cli.parsing.arguments.ExpressionValueState;
import org.jboss.as.cli.parsing.arguments.ListItemSeparatorState;
import org.jboss.as.cli.parsing.arguments.ListState;
import org.jboss.as.cli.parsing.arguments.NameValueSeparatorState;

public class ArgumentValueState
extends DefaultParsingState {
    public static final String ID = "ARG_VALUE";
    public static final ArgumentValueState INSTANCE = new ArgumentValueState();

    public ArgumentValueState() {
        super(ID);
        this.setEnterHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                char ch = ctx.getCharacter();
                switch (ch) {
                    case '\"': {
                        ctx.enterState(QuotesState.QUOTES_EXCLUDED);
                        break;
                    }
                    case '$': {
                        ctx.enterState(ExpressionValueState.INSTANCE);
                        break;
                    }
                    case '{': {
                        break;
                    }
                    case '`': {
                        ctx.enterState(BackQuotesState.QUOTES_INCLUDED);
                        break;
                    }
                    default: {
                        ctx.getCallbackHandler().character(ctx);
                    }
                }
            }
        });
        this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
        this.enterState('=', NameValueSeparatorState.INSTANCE);
        this.enterState(',', ListItemSeparatorState.INSTANCE);
        this.enterState('[', new ListState(this));
        this.enterState('\"', QuotesState.QUOTES_INCLUDED);
        this.enterState('`', BackQuotesState.QUOTES_INCLUDED);
        this.leaveState(']');
        this.enterState('{', this);
        this.leaveState('}');
        this.enterState('$', ExpressionValueState.INSTANCE);
    }
}

