/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import org.jboss.as.process.CommandLineArgumentUsageImpl;
import org.jboss.as.process.ProcessController;
import org.jboss.as.process.ProcessMessages;
import org.jboss.as.process.SynchronizedWriter;
import org.jboss.as.process.protocol.ProtocolServer;
import org.jboss.as.version.ProductConfig;
import org.jboss.as.version.Version;
import org.jboss.logging.MDC;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.modules.Module;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public final class Main {
    public static final String HOST_CONTROLLER_PROCESS_NAME = "Host Controller";
    public static final String HOST_CONTROLLER_MODULE = "org.jboss.as.host-controller";

    public static String getVersionString() {
        return Version.AS_VERSION;
    }

    private static void usage() {
        CommandLineArgumentUsageImpl.printUsage(System.out);
    }

    private Main() {
    }

    public static void main(String[] args) throws IOException {
        Main.start(args);
    }

    public static ProcessController start(String[] args) throws IOException {
        MDC.put((String)"process", (Object)"process controller");
        String javaHome = WildFlySecurityManager.getPropertyPrivileged((String)"java.home", (String)".");
        String jvmName = javaHome + "/bin/java";
        String jbossHome = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", (String)".");
        String modulePath = null;
        String bootJar = null;
        String bootModule = HOST_CONTROLLER_MODULE;
        PCSocketConfig pcSocketConfig = new PCSocketConfig();
        String currentWorkingDir = WildFlySecurityManager.getPropertyPrivileged((String)"user.dir", null);
        ArrayList<String> javaOptions = new ArrayList<String>();
        ArrayList<String> smOptions = new ArrayList<String>();
        block0: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-jvm".equals(arg)) {
                jvmName = args[++i];
                continue;
            }
            if ("-jboss-home".equals(arg)) {
                jbossHome = args[++i];
                continue;
            }
            if ("-mp".equals(arg)) {
                modulePath = args[++i];
                continue;
            }
            if ("-jar".equals(arg)) {
                bootJar = args[++i];
                continue;
            }
            if ("--".equals(arg)) {
                ++i;
                while (i < args.length) {
                    arg = args[i];
                    if ("--".equals(arg)) {
                        ++i;
                        while (i < args.length) {
                            String val;
                            arg = args[i];
                            if (Main.handleHelpOrVersion(arg, jbossHome)) {
                                return null;
                            }
                            if (pcSocketConfig.processPCSocketConfigArgument(arg, args, i)) {
                                if (pcSocketConfig.isParseFailed()) {
                                    return null;
                                }
                                i += pcSocketConfig.getArgIncrement();
                            } else if (arg.startsWith("-Djava.net.preferIPv4Stack=")) {
                                val = Main.parseValue(arg, "-Djava.net.preferIPv4Stack");
                                WildFlySecurityManager.setPropertyPrivileged((String)"java.net.preferIPv4Stack", (String)val);
                                Main.addJavaOption(arg, javaOptions);
                            } else if (arg.startsWith("-Djava.net.preferIPv6Addresses=")) {
                                val = Main.parseValue(arg, "-Djava.net.preferIPv6Addresses");
                                WildFlySecurityManager.setPropertyPrivileged((String)"java.net.preferIPv6Addresses", (String)val);
                                Main.addJavaOption(arg, javaOptions);
                            } else {
                                Main.addJavaOption(arg, smOptions);
                            }
                            ++i;
                        }
                        break block0;
                    }
                    if (Main.handleHelpOrVersion(arg, jbossHome)) {
                        return null;
                    }
                    if (pcSocketConfig.processPCSocketConfigArgument(arg, args, i)) {
                        if (pcSocketConfig.isParseFailed()) {
                            return null;
                        }
                        i += pcSocketConfig.getArgIncrement();
                    } else {
                        Main.addJavaOption(arg, javaOptions);
                    }
                    ++i;
                }
                break;
            }
            if (Main.handleHelpOrVersion(arg, jbossHome)) {
                return null;
            }
            if (pcSocketConfig.processPCSocketConfigArgument(arg, args, i)) {
                if (pcSocketConfig.isParseFailed()) {
                    return null;
                }
                i += pcSocketConfig.getArgIncrement();
                continue;
            }
            throw ProcessMessages.MESSAGES.invalidOption(arg);
        }
        if (modulePath == null) {
            modulePath = WildFlySecurityManager.getPropertyPrivileged((String)"module.path", (String)(jbossHome + File.separator + "modules"));
        }
        if (bootJar == null) {
            bootJar = jbossHome + File.separator + "jboss-modules.jar";
        }
        Handler consoleHandler = null;
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            if (consoleHandler != null) {
                rootLogger.removeHandler(handler);
                continue;
            }
            consoleHandler = handler;
            ((ConsoleHandler)consoleHandler).setWriter((Writer)new SynchronizedWriter(System.out));
        }
        ProtocolServer.Configuration configuration = new ProtocolServer.Configuration();
        InetAddress pcInetAddress = InetAddress.getByName(pcSocketConfig.getBindAddress());
        InetSocketAddress pcInetSocketAddress = new InetSocketAddress(pcInetAddress, pcSocketConfig.getBindPort());
        configuration.setBindAddress(pcInetSocketAddress);
        configuration.setSocketFactory(ServerSocketFactory.getDefault());
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("ProcessController-threads"), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        configuration.setThreadFactory((ThreadFactory)threadFactory);
        configuration.setReadExecutor(Executors.newCachedThreadPool((ThreadFactory)threadFactory));
        final ProcessController processController = new ProcessController(configuration, System.out, System.err);
        InetSocketAddress boundAddress = processController.getServer().getBoundAddress();
        ArrayList<String> initialCommand = new ArrayList<String>();
        initialCommand.add(jvmName);
        initialCommand.add("-D[Host Controller]");
        initialCommand.addAll(javaOptions);
        initialCommand.add("-jar");
        initialCommand.add(bootJar);
        initialCommand.add("-mp");
        initialCommand.add(modulePath);
        initialCommand.add(bootModule);
        initialCommand.add("-mp");
        initialCommand.add(modulePath);
        initialCommand.add("--pc-address");
        initialCommand.add(boundAddress.getAddress().getHostAddress());
        initialCommand.add("--pc-port");
        initialCommand.add(Integer.toString(boundAddress.getPort()));
        initialCommand.addAll(smOptions);
        initialCommand.add("-Djboss.home.dir=" + jbossHome);
        processController.addProcess(HOST_CONTROLLER_PROCESS_NAME, initialCommand, Collections.emptyMap(), currentWorkingDir, true, true);
        processController.startProcess(HOST_CONTROLLER_PROCESS_NAME);
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                processController.shutdown();
            }
        }, "Shutdown thread");
        shutdownThread.setDaemon(false);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        return processController;
    }

    private static String parseValue(String arg, String key) {
        String value = null;
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            System.out.println(ProcessMessages.MESSAGES.noArgValue(key));
            Main.usage();
        } else {
            value = arg.substring(splitPos + 1);
        }
        return value;
    }

    private static void addJavaOption(String option, List<String> javaOptions) {
        if (option.startsWith("-D")) {
            int splitPos = option.indexOf(61);
            String key = splitPos < 0 ? option : option.substring(0, splitPos);
            Iterator<String> iter = javaOptions.iterator();
            while (iter.hasNext()) {
                String existingOp = iter.next();
                if (!existingOp.equals(key) && (!existingOp.startsWith(key) || existingOp.indexOf(61) != key.length())) continue;
                iter.remove();
            }
        }
        javaOptions.add(option);
    }

    private static boolean handleHelpOrVersion(String arg, String jbossHome) {
        if ("--help".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
            Main.usage();
            return true;
        }
        if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
            System.out.println(new ProductConfig(Module.getBootModuleLoader(), jbossHome, null).getPrettyVersionString());
            return true;
        }
        return false;
    }

    private static class PCSocketConfig {
        private String bindAddress;
        private int bindPort = 0;
        private int argIncrement = 0;
        private boolean parseFailed;

        private PCSocketConfig() {
        }

        private String getBindAddress() {
            if (this.bindAddress != null) {
                return this.bindAddress;
            }
            boolean v4Stack = Boolean.valueOf(WildFlySecurityManager.getPropertyPrivileged((String)"java.net.preferIPv4Stack", (String)"false"));
            boolean useV6 = !v4Stack && Boolean.valueOf(WildFlySecurityManager.getPropertyPrivileged((String)"java.net.preferIPv6Addresses", (String)"false")) != false;
            return useV6 ? "::1" : "127.0.0.1";
        }

        private int getBindPort() {
            return this.bindPort;
        }

        private int getArgIncrement() {
            return this.argIncrement;
        }

        private boolean isParseFailed() {
            return this.parseFailed;
        }

        private boolean processPCSocketConfigArgument(String arg, String[] args, int index) {
            boolean isPCSocketArg = true;
            this.argIncrement = 0;
            if ("--pc-address".equals(arg) || "-bind-addr".equals(arg)) {
                this.bindAddress = args[index + 1];
                this.argIncrement = 1;
            } else if (arg.startsWith("--pc-address")) {
                String addr = Main.parseValue(arg, "--pc-address");
                if (addr == null) {
                    this.parseFailed = true;
                } else {
                    this.bindAddress = addr;
                }
            } else if (arg.startsWith("-bind-addr")) {
                String addr = Main.parseValue(arg, "-bind-addr");
                if (addr == null) {
                    this.parseFailed = true;
                } else {
                    this.bindAddress = addr;
                }
            } else if ("--pc-port".equals(arg) || "-bind-port".equals(arg)) {
                this.bindPort = Integer.parseInt(args[index + 1]);
                this.argIncrement = 1;
            } else if (arg.startsWith("--pc-port")) {
                String port = Main.parseValue(arg, "--pc-port");
                if (port == null) {
                    this.parseFailed = true;
                } else {
                    this.bindPort = Integer.parseInt(port);
                }
            } else if (arg.startsWith("-bind-port")) {
                String port = Main.parseValue(arg, "-bind-port");
                if (port == null) {
                    this.parseFailed = true;
                } else {
                    this.bindPort = Integer.parseInt(port);
                }
            } else {
                isPCSocketArg = false;
            }
            return isPCSocketArg;
        }
    }
}

