/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.AccessControlUser;
import redis.clients.jedis.Builder;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.Module;
import redis.clients.jedis.StreamConsumersInfo;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamGroupInfo;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.util.JedisByteHashMap;
import redis.clients.jedis.util.SafeEncoder;

public final class BuilderFactory {
    public static final Builder<Double> DOUBLE = new Builder<Double>(){

        @Override
        public Double build(Object data) {
            String string = STRING.build(data);
            if (string == null) {
                return null;
            }
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException e) {
                if (string.equals("inf") || string.equals("+inf")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (string.equals("-inf")) {
                    return Double.NEGATIVE_INFINITY;
                }
                throw e;
            }
        }

        public String toString() {
            return "double";
        }
    };
    public static final Builder<Boolean> BOOLEAN = new Builder<Boolean>(){

        @Override
        public Boolean build(Object data) {
            return (Long)data == 1L;
        }

        public String toString() {
            return "boolean";
        }
    };
    public static final Builder<byte[]> BYTE_ARRAY = new Builder<byte[]>(){

        @Override
        public byte[] build(Object data) {
            return (byte[])data;
        }

        public String toString() {
            return "byte[]";
        }
    };
    public static final Builder<Long> LONG = new Builder<Long>(){

        @Override
        public Long build(Object data) {
            return (Long)data;
        }

        public String toString() {
            return "long";
        }
    };
    public static final Builder<String> STRING = new Builder<String>(){

        @Override
        public String build(Object data) {
            return data == null ? null : SafeEncoder.encode((byte[])data);
        }

        public String toString() {
            return "string";
        }
    };
    public static final Builder<List<String>> STRING_LIST = new Builder<List<String>>(){

        @Override
        public List<String> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            ArrayList<String> result = new ArrayList<String>(l.size());
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode(barray));
            }
            return result;
        }

        public String toString() {
            return "List<String>";
        }
    };
    public static final Builder<Map<String, String>> STRING_MAP = new Builder<Map<String, String>>(){

        @Override
        public Map<String, String> build(Object data) {
            List flatHash = (List)data;
            HashMap<String, String> hash = new HashMap<String, String>(flatHash.size() / 2, 1.0f);
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next()));
            }
            return hash;
        }

        public String toString() {
            return "Map<String, String>";
        }
    };
    public static final Builder<Map<String, String>> PUBSUB_NUMSUB_MAP = new Builder<Map<String, String>>(){

        @Override
        public Map<String, String> build(Object data) {
            List flatHash = (List)data;
            HashMap<String, String> hash = new HashMap<String, String>(flatHash.size() / 2, 1.0f);
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(SafeEncoder.encode((byte[])iterator.next()), String.valueOf((Long)iterator.next()));
            }
            return hash;
        }

        public String toString() {
            return "PUBSUB_NUMSUB_MAP<String, String>";
        }
    };
    public static final Builder<Set<String>> STRING_SET = new Builder<Set<String>>(){

        @Override
        public Set<String> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            HashSet<String> result = new HashSet<String>(l.size(), 1.0f);
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode(barray));
            }
            return result;
        }

        public String toString() {
            return "Set<String>";
        }
    };
    public static final Builder<List<byte[]>> BYTE_ARRAY_LIST = new Builder<List<byte[]>>(){

        @Override
        public List<byte[]> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            return l;
        }

        public String toString() {
            return "List<byte[]>";
        }
    };
    public static final Builder<Set<byte[]>> BYTE_ARRAY_ZSET = new Builder<Set<byte[]>>(){

        @Override
        public Set<byte[]> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<byte[]> result = new LinkedHashSet<byte[]>(l);
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(barray);
            }
            return result;
        }

        public String toString() {
            return "ZSet<byte[]>";
        }
    };
    public static final Builder<Map<byte[], byte[]>> BYTE_ARRAY_MAP = new Builder<Map<byte[], byte[]>>(){

        @Override
        public Map<byte[], byte[]> build(Object data) {
            List flatHash = (List)data;
            JedisByteHashMap hash = new JedisByteHashMap();
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(iterator.next(), iterator.next());
            }
            return hash;
        }

        public String toString() {
            return "Map<byte[], byte[]>";
        }
    };
    public static final Builder<Set<String>> STRING_ZSET = new Builder<Set<String>>(){

        @Override
        public Set<String> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<String> result = new LinkedHashSet<String>(l.size(), 1.0f);
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode(barray));
            }
            return result;
        }

        public String toString() {
            return "ZSet<String>";
        }
    };
    public static final Builder<Set<Tuple>> TUPLE_ZSET = new Builder<Set<Tuple>>(){

        @Override
        public Set<Tuple> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<Tuple> result = new LinkedHashSet<Tuple>(l.size() / 2, 1.0f);
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                result.add(new Tuple((byte[])iterator.next(), DOUBLE.build(iterator.next())));
            }
            return result;
        }

        public String toString() {
            return "ZSet<Tuple>";
        }
    };
    public static final Builder<Tuple> TUPLE = new Builder<Tuple>(){

        @Override
        public Tuple build(Object data) {
            List l = (List)data;
            if (l.isEmpty()) {
                return null;
            }
            return new Tuple((byte[])l.get(0), DOUBLE.build(l.get(1)));
        }

        public String toString() {
            return "Tuple";
        }
    };
    public static final Builder<Object> EVAL_RESULT = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            return this.evalResult(data);
        }

        public String toString() {
            return "Eval<Object>";
        }

        private Object evalResult(Object result) {
            if (result instanceof byte[]) {
                return SafeEncoder.encode((byte[])result);
            }
            if (result instanceof List) {
                List list = (List)result;
                ArrayList<Object> listResult = new ArrayList<Object>(list.size());
                for (Object bin : list) {
                    listResult.add(this.evalResult(bin));
                }
                return listResult;
            }
            return result;
        }
    };
    public static final Builder<Object> EVAL_BINARY_RESULT = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            return this.evalResult(data);
        }

        public String toString() {
            return "Eval<Object>";
        }

        private Object evalResult(Object result) {
            if (result instanceof List) {
                List list = (List)result;
                ArrayList<Object> listResult = new ArrayList<Object>(list.size());
                for (Object bin : list) {
                    listResult.add(this.evalResult(bin));
                }
                return listResult;
            }
            return result;
        }
    };
    public static final Builder<List<GeoCoordinate>> GEO_COORDINATE_LIST = new Builder<List<GeoCoordinate>>(){

        @Override
        public List<GeoCoordinate> build(Object data) {
            if (null == data) {
                return null;
            }
            return this.interpretGeoposResult((List)data);
        }

        public String toString() {
            return "List<GeoCoordinate>";
        }

        private List<GeoCoordinate> interpretGeoposResult(List<Object> responses) {
            ArrayList<GeoCoordinate> responseCoordinate = new ArrayList<GeoCoordinate>(responses.size());
            for (Object response : responses) {
                if (response == null) {
                    responseCoordinate.add(null);
                    continue;
                }
                List respList = (List)response;
                GeoCoordinate coord = new GeoCoordinate(DOUBLE.build(respList.get(0)), DOUBLE.build(respList.get(1)));
                responseCoordinate.add(coord);
            }
            return responseCoordinate;
        }
    };
    public static final Builder<List<GeoRadiusResponse>> GEORADIUS_WITH_PARAMS_RESULT = new Builder<List<GeoRadiusResponse>>(){

        @Override
        public List<GeoRadiusResponse> build(Object data) {
            if (data == null) {
                return null;
            }
            List objectList = (List)data;
            ArrayList<GeoRadiusResponse> responses = new ArrayList<GeoRadiusResponse>(objectList.size());
            if (objectList.isEmpty()) {
                return responses;
            }
            if (objectList.get(0) instanceof List) {
                for (Object obj : objectList) {
                    List informations = (List)obj;
                    GeoRadiusResponse resp = new GeoRadiusResponse((byte[])informations.get(0));
                    int size = informations.size();
                    for (int idx = 1; idx < size; ++idx) {
                        Object info = informations.get(idx);
                        if (info instanceof List) {
                            List coord = (List)info;
                            resp.setCoordinate(new GeoCoordinate(DOUBLE.build(coord.get(0)), DOUBLE.build(coord.get(1))));
                            continue;
                        }
                        if (info instanceof Long) {
                            resp.setRawScore(LONG.build(info));
                            continue;
                        }
                        resp.setDistance(DOUBLE.build(info));
                    }
                    responses.add(resp);
                }
            } else {
                for (Object obj : objectList) {
                    responses.add(new GeoRadiusResponse((byte[])obj));
                }
            }
            return responses;
        }

        public String toString() {
            return "GeoRadiusWithParamsResult";
        }
    };
    public static final Builder<List<Module>> MODULE_LIST = new Builder<List<Module>>(){

        @Override
        public List<Module> build(Object data) {
            if (data == null) {
                return null;
            }
            List objectList = (List)data;
            ArrayList<Module> responses = new ArrayList<Module>(objectList.size());
            if (objectList.isEmpty()) {
                return responses;
            }
            for (List moduleResp : objectList) {
                Module m = new Module(SafeEncoder.encode((byte[])moduleResp.get(1)), ((Long)moduleResp.get(3)).intValue());
                responses.add(m);
            }
            return responses;
        }

        public String toString() {
            return "List<Module>";
        }
    };
    public static final Builder<AccessControlUser> ACCESS_CONTROL_USER = new Builder<AccessControlUser>(){

        @Override
        public AccessControlUser build(Object data) {
            if (data == null) {
                return null;
            }
            List objectList = (List)data;
            if (objectList.isEmpty()) {
                return null;
            }
            AccessControlUser accessControlUser = new AccessControlUser();
            List flags = (List)objectList.get(1);
            for (Object f : flags) {
                accessControlUser.addFlag(SafeEncoder.encode((byte[])f));
            }
            List passwords = (List)objectList.get(3);
            for (Object p : passwords) {
                accessControlUser.addPassword(SafeEncoder.encode((byte[])p));
            }
            accessControlUser.setCommands(SafeEncoder.encode((byte[])objectList.get(5)));
            List keys = (List)objectList.get(7);
            for (Object k : keys) {
                accessControlUser.addKey(SafeEncoder.encode((byte[])k));
            }
            return accessControlUser;
        }

        public String toString() {
            return "AccessControlUser";
        }
    };
    public static final Builder<List<Long>> LONG_LIST = new Builder<List<Long>>(){

        @Override
        public List<Long> build(Object data) {
            if (null == data) {
                return null;
            }
            return (List)data;
        }

        public String toString() {
            return "List<Long>";
        }
    };
    public static final Builder<StreamEntryID> STREAM_ENTRY_ID = new Builder<StreamEntryID>(){

        @Override
        public StreamEntryID build(Object data) {
            if (null == data) {
                return null;
            }
            String id = SafeEncoder.encode((byte[])data);
            return new StreamEntryID(id);
        }

        public String toString() {
            return "StreamEntryID";
        }
    };
    public static final Builder<List<StreamEntry>> STREAM_ENTRY_LIST = new Builder<List<StreamEntry>>(){

        @Override
        public List<StreamEntry> build(Object data) {
            if (null == data) {
                return null;
            }
            List objectList = (List)data;
            ArrayList<StreamEntry> responses = new ArrayList<StreamEntry>(objectList.size() / 2);
            if (objectList.isEmpty()) {
                return responses;
            }
            for (ArrayList res : objectList) {
                String entryIdString = SafeEncoder.encode((byte[])res.get(0));
                StreamEntryID entryID = new StreamEntryID(entryIdString);
                List hash = (List)res.get(1);
                Iterator hashIterator = hash.iterator();
                HashMap<String, String> map = new HashMap<String, String>(hash.size() / 2);
                while (hashIterator.hasNext()) {
                    map.put(SafeEncoder.encode((byte[])hashIterator.next()), SafeEncoder.encode((byte[])hashIterator.next()));
                }
                responses.add(new StreamEntry(entryID, map));
            }
            return responses;
        }

        public String toString() {
            return "List<StreamEntry>";
        }
    };
    public static final Builder<StreamEntry> STREAM_ENTRY = new Builder<StreamEntry>(){

        @Override
        public StreamEntry build(Object data) {
            if (null == data) {
                return null;
            }
            List objectList = (List)data;
            if (objectList.isEmpty()) {
                return null;
            }
            String entryIdString = SafeEncoder.encode((byte[])objectList.get(0));
            StreamEntryID entryID = new StreamEntryID(entryIdString);
            List hash = (List)objectList.get(1);
            Iterator hashIterator = hash.iterator();
            HashMap<String, String> map = new HashMap<String, String>(hash.size() / 2);
            while (hashIterator.hasNext()) {
                map.put(SafeEncoder.encode((byte[])hashIterator.next()), SafeEncoder.encode((byte[])hashIterator.next()));
            }
            StreamEntry streamEntry = new StreamEntry(entryID, map);
            return streamEntry;
        }

        public String toString() {
            return "StreamEntry";
        }
    };
    public static final Builder<List<StreamPendingEntry>> STREAM_PENDING_ENTRY_LIST = new Builder<List<StreamPendingEntry>>(){

        @Override
        public List<StreamPendingEntry> build(Object data) {
            if (null == data) {
                return null;
            }
            List streamsEntries = (List)data;
            ArrayList<StreamPendingEntry> result = new ArrayList<StreamPendingEntry>(streamsEntries.size());
            for (Object streamObj : streamsEntries) {
                List stream = (List)streamObj;
                String id = SafeEncoder.encode((byte[])stream.get(0));
                String consumerName = SafeEncoder.encode((byte[])stream.get(1));
                long idleTime = LONG.build(stream.get(2));
                long deliveredTimes = LONG.build(stream.get(3));
                result.add(new StreamPendingEntry(new StreamEntryID(id), consumerName, idleTime, deliveredTimes));
            }
            return result;
        }

        public String toString() {
            return "List<StreamPendingEntry>";
        }
    };
    public static final Builder<StreamInfo> STREAM_INFO = new Builder<StreamInfo>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("last-generated-id", STREAM_ENTRY_ID);
            tempMappingFunctions.put("first-entry", STREAM_ENTRY);
            tempMappingFunctions.put("length", LONG);
            tempMappingFunctions.put("radix-tree-keys", LONG);
            tempMappingFunctions.put("radix-tree-nodes", LONG);
            tempMappingFunctions.put("last-entry", STREAM_ENTRY);
            tempMappingFunctions.put("groups", LONG);
            return tempMappingFunctions;
        }

        @Override
        public StreamInfo build(Object data) {
            if (null == data) {
                return null;
            }
            List streamsEntries = (List)data;
            Iterator iterator = streamsEntries.iterator();
            StreamInfo streamInfo = new StreamInfo(BuilderFactory.createMapFromDecodingFunctions(iterator, this.mappingFunctions));
            return streamInfo;
        }

        public String toString() {
            return "StreamInfo";
        }
    };
    public static final Builder<List<StreamGroupInfo>> STREAM_GROUP_INFO_LIST = new Builder<List<StreamGroupInfo>>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("name", STRING);
            tempMappingFunctions.put("consumers", LONG);
            tempMappingFunctions.put("pending", LONG);
            tempMappingFunctions.put("last-delivered-id", STREAM_ENTRY_ID);
            return tempMappingFunctions;
        }

        @Override
        public List<StreamGroupInfo> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<StreamGroupInfo> list = new ArrayList<StreamGroupInfo>();
            List streamsEntries = (List)data;
            for (List groupInfo : streamsEntries) {
                Iterator groupInfoIterator = groupInfo.iterator();
                StreamGroupInfo streamGroupInfo = new StreamGroupInfo(BuilderFactory.createMapFromDecodingFunctions(groupInfoIterator, this.mappingFunctions));
                list.add(streamGroupInfo);
            }
            return list;
        }

        public String toString() {
            return "List<StreamGroupInfo>";
        }
    };
    public static final Builder<List<StreamConsumersInfo>> STREAM_CONSUMERS_INFO_LIST = new Builder<List<StreamConsumersInfo>>(){
        Map<String, Builder> mappingFunctions = this.createDecoderMap();

        private Map<String, Builder> createDecoderMap() {
            HashMap<String, Builder> tempMappingFunctions = new HashMap<String, Builder>();
            tempMappingFunctions.put("name", STRING);
            tempMappingFunctions.put("idle", LONG);
            tempMappingFunctions.put("pending", LONG);
            tempMappingFunctions.put("last-delivered-id", STRING);
            return tempMappingFunctions;
        }

        @Override
        public List<StreamConsumersInfo> build(Object data) {
            if (null == data) {
                return null;
            }
            ArrayList<StreamConsumersInfo> list = new ArrayList<StreamConsumersInfo>();
            List streamsEntries = (List)data;
            for (List groupInfo : streamsEntries) {
                Iterator consumerInfoIterator = groupInfo.iterator();
                StreamConsumersInfo streamGroupInfo = new StreamConsumersInfo(BuilderFactory.createMapFromDecodingFunctions(consumerInfoIterator, this.mappingFunctions));
                list.add(streamGroupInfo);
            }
            return list;
        }

        public String toString() {
            return "List<StreamConsumersInfo>";
        }
    };
    public static final Builder<Object> OBJECT = new Builder<Object>(){

        @Override
        public Object build(Object data) {
            return data;
        }

        public String toString() {
            return "Object";
        }
    };

    private BuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }

    private static Map<String, Object> createMapFromDecodingFunctions(Iterator<Object> iterator, Map<String, Builder> mappingFunctions) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        block2: while (iterator.hasNext()) {
            String mapKey = STRING.build(iterator.next());
            if (mappingFunctions.containsKey(mapKey)) {
                resultMap.put(mapKey, mappingFunctions.get(mapKey).build(iterator.next()));
                continue;
            }
            Object unknownData = iterator.next();
            for (Builder b : mappingFunctions.values()) {
                try {
                    resultMap.put(mapKey, b.build(unknownData));
                    continue block2;
                }
                catch (ClassCastException classCastException) {
                }
            }
        }
        return resultMap;
    }
}

