/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.forwarding;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.GlobalRequestHandler;
import com.sshtools.j2ssh.connection.GlobalRequestResponse;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingListener;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import com.sshtools.j2ssh.io.ByteArrayReader;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketPermission;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingServer
implements ChannelFactory,
GlobalRequestHandler {
    private static Log log = LogFactory.getLog((Class)ForwardingServer.class);
    private ConnectionProtocol connection;
    private List channelTypes = new Vector();
    private List localForwardings = new Vector();
    private List remoteForwardings = new Vector();

    public ForwardingServer(ConnectionProtocol connectionProtocol) throws IOException {
        this.connection = connectionProtocol;
        this.channelTypes.add("direct-tcpip");
        connectionProtocol.addChannelFactory("direct-tcpip", (ChannelFactory)this);
        connectionProtocol.allowGlobalRequest("tcpip-forward", (GlobalRequestHandler)this);
        connectionProtocol.allowGlobalRequest("cancel-tcpip-forward", (GlobalRequestHandler)this);
    }

    public Channel createChannel(String string, byte[] byArray) throws InvalidChannelException {
        if (!string.equals("direct-tcpip")) {
            throw new InvalidChannelException("The client can only request the opening of a local forwarding channel");
        }
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string2 = byteArrayReader.readString();
            int n = (int)byteArrayReader.readInt();
            String string3 = byteArrayReader.readString();
            int n2 = (int)byteArrayReader.readInt();
            ForwardingConfiguration forwardingConfiguration = this.getLocalForwardingByAddress(string3, n2);
            Socket socket = new Socket(string2, n);
            ForwardingSocketChannel forwardingSocketChannel = forwardingConfiguration.createForwardingSocketChannel(string, string2, n, string3, n2);
            forwardingSocketChannel.bindSocket(socket);
            return forwardingSocketChannel;
        }
        catch (ForwardingConfigurationException forwardingConfigurationException) {
            throw new InvalidChannelException("No valid forwarding configuration was available for the request");
        }
        catch (IOException iOException) {
            throw new InvalidChannelException("The channel request data is invalid/or corrupt for channel type " + string);
        }
    }

    public GlobalRequestResponse processGlobalRequest(String string, byte[] byArray) {
        GlobalRequestResponse globalRequestResponse = new GlobalRequestResponse(false);
        String string2 = null;
        int n = -1;
        log.debug((Object)("Processing " + string + " global request"));
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            string2 = byteArrayReader.readString();
            n = (int)byteArrayReader.readInt();
            if (string.equals("tcpip-forward")) {
                this.addRemoteForwardingConfiguration(string2, n);
                globalRequestResponse = new GlobalRequestResponse(true);
            }
            if (string.equals("cancel-tcpip-forward")) {
                this.removeRemoteForwarding(string2, n);
                globalRequestResponse = new GlobalRequestResponse(true);
            }
        }
        catch (IOException iOException) {
            log.warn((Object)("The client failed to request " + string + " for " + string2 + ":" + String.valueOf(n)), (Throwable)iOException);
        }
        return globalRequestResponse;
    }

    protected ForwardingConfiguration getLocalForwardingByAddress(String string, int n) throws ForwardingConfigurationException {
        try {
            ForwardingConfiguration forwardingConfiguration;
            Iterator iterator = this.localForwardings.iterator();
            while (iterator.hasNext()) {
                forwardingConfiguration = (ForwardingConfiguration)iterator.next();
                if (!forwardingConfiguration.getAddressToBind().equals(string) || forwardingConfiguration.getPortToBind() != n) continue;
                return forwardingConfiguration;
            }
            forwardingConfiguration = new ForwardingConfiguration(string, n);
            forwardingConfiguration.start();
            this.localForwardings.add(forwardingConfiguration);
            return forwardingConfiguration;
        }
        catch (IOException iOException) {
            throw new ForwardingConfigurationException(iOException.getMessage());
        }
    }

    protected ForwardingConfiguration getRemoteForwardingByAddress(String string, int n) throws ForwardingConfigurationException {
        Iterator iterator = this.remoteForwardings.iterator();
        while (iterator.hasNext()) {
            ForwardingConfiguration forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            if (!forwardingConfiguration.getAddressToBind().equals(string) || forwardingConfiguration.getPortToBind() != n) continue;
            return forwardingConfiguration;
        }
        throw new ForwardingConfigurationException("The remote forwarding does not exist!");
    }

    protected void addRemoteForwardingConfiguration(String string, int n) throws ForwardingConfigurationException {
        ForwardingConfiguration forwardingConfiguration;
        Iterator iterator = this.remoteForwardings.iterator();
        while (iterator.hasNext()) {
            forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            if (!forwardingConfiguration.getAddressToBind().equals(string) || forwardingConfiguration.getPortToBind() != n) continue;
            throw new ForwardingConfigurationException("The address and port are already in use!");
        }
        forwardingConfiguration = new ForwardingConfiguration(string, n);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SocketPermission(string + ":" + String.valueOf(n), "accept,listen"));
            }
            catch (SecurityException securityException) {
                throw new ForwardingConfigurationException("The security manager has denied listen permision on " + string + ":" + String.valueOf(n));
            }
        }
        try {
            ServerForwardingListener serverForwardingListener = new ServerForwardingListener(this.connection, string, n);
            this.remoteForwardings.add(serverForwardingListener);
            serverForwardingListener.start();
        }
        catch (IOException iOException) {
            throw new ForwardingConfigurationException(iOException.getMessage());
        }
    }

    protected void removeRemoteForwarding(String string, int n) throws ForwardingConfigurationException {
        ForwardingConfiguration forwardingConfiguration = this.getRemoteForwardingByAddress(string, n);
        forwardingConfiguration.stop();
        this.remoteForwardings.remove(forwardingConfiguration);
    }

    class ServerForwardingListener
    extends ForwardingListener {
        public ServerForwardingListener(ConnectionProtocol connectionProtocol, String string, int n) {
            super(connectionProtocol, string, n);
        }

        public ForwardingSocketChannel createChannel(String string, int n, Socket socket) throws ForwardingConfigurationException {
            try {
                ForwardingSocketChannel forwardingSocketChannel = this.createForwardingSocketChannel("forwarded-tcpip", string, n, socket.getInetAddress().getHostAddress(), socket.getPort());
                forwardingSocketChannel.bindSocket(socket);
                return forwardingSocketChannel;
            }
            catch (IOException iOException) {
                throw new ForwardingConfigurationException(iOException.getMessage());
            }
        }
    }
}

