/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.registration.EntitiesRegistrationException;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LayoutUtils {
    static final Log log = LogFactory.getLog((Class)LayoutUtils.class);

    public static int findVerticalOffset(JRDesignBand band) {
        int finalHeight = 0;
        if (band != null) {
            Iterator iter = band.getChildren().iterator();
            while (iter.hasNext()) {
                JRDesignElement element = (JRDesignElement)iter.next();
                int currentHeight = element.getY() + element.getHeight();
                if (currentHeight <= finalHeight) continue;
                finalHeight = currentHeight;
            }
            return finalHeight;
        }
        return finalHeight;
    }

    public static void copyBandElements(JRDesignBand destBand, JRBand sourceBand) {
        int offset = LayoutUtils.findVerticalOffset(destBand);
        Iterator iterator = sourceBand.getChildren().iterator();
        while (iterator.hasNext()) {
            JRDesignElement element = (JRDesignElement)iterator.next();
            JRDesignElement dest = null;
            try {
                dest = (JRDesignElement)element.getClass().newInstance();
                BeanUtils.copyProperties((Object)dest, (Object)element);
                dest.setY(dest.getY() + offset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            destBand.addElement(dest);
        }
    }

    public static void moveBandsElemnts(int yOffset, JRDesignBand band) {
        if (band == null) {
            return;
        }
        Iterator iterator = band.getChildren().iterator();
        while (iterator.hasNext()) {
            JRDesignElement elem = (JRDesignElement)iterator.next();
            elem.setY(elem.getY() + yOffset);
        }
    }

    public static void registerCustomExpressionParameter(DynamicJasperDesign design, String name, CustomExpression customExpression) {
        if (customExpression == null) {
            return;
        }
        JRDesignParameter dparam = new JRDesignParameter();
        dparam.setName(name);
        dparam.setValueClassName(CustomExpression.class.getName());
        log.debug((Object)("Registering customExpression parameter with name " + name));
        try {
            design.addParameter((JRParameter)dparam);
        }
        catch (JRException e) {
            throw new EntitiesRegistrationException(e.getMessage(), e);
        }
        design.getParametersWithValues().put(name, customExpression);
    }

    public static JRDesignGroup getJRDesignGroup(DynamicJasperDesign jd, LayoutManager layoutManager, DJGroup group) {
        Map references = layoutManager.getReferencesMap();
        Iterator iterator = references.keySet().iterator();
        while (iterator.hasNext()) {
            String groupName = (String)iterator.next();
            DJGroup djGroup = (DJGroup)references.get(groupName);
            if (group != djGroup) continue;
            return (JRDesignGroup)jd.getGroupsMap().get(groupName);
        }
        return null;
    }

    public static JRDesignGroup findParentJRGroup(DJGroup djgroup, DynamicReport dr, DynamicJasperDesign djd, LayoutManager layoutManager) {
        JRDesignGroup registeredGroup;
        int gidx = dr.getColumnsGroups().indexOf(djgroup);
        if (gidx > 0) {
            JRDesignGroup jrParentGroup;
            DJGroup djParentGroup = (DJGroup)dr.getColumnsGroups().get(--gidx);
            registeredGroup = jrParentGroup = LayoutUtils.getJRDesignGroup(djd, layoutManager, djParentGroup);
        } else {
            registeredGroup = null;
        }
        return registeredGroup;
    }

    public static DJGroup findChildDJGroup(DJGroup djgroup, DynamicReport dr) {
        DJGroup child = null;
        int gidx = dr.getColumnsGroups().indexOf(djgroup);
        if (gidx + 1 < dr.getColumnsGroups().size()) {
            child = (DJGroup)dr.getColumnsGroups().get(++gidx);
        }
        return child;
    }
}

