/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class PEMReader
extends BufferedReader {
    private PasswordFinder pFinder;
    private String provider;

    public PEMReader(Reader reader) {
        this(reader, null, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder passwordFinder) {
        this(reader, passwordFinder, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder passwordFinder, String string) {
        super(reader);
        this.pFinder = passwordFinder;
        this.provider = string;
    }

    public Object readObject() throws IOException {
        String string;
        while ((string = this.readLine()) != null) {
            if (string.indexOf("-----BEGIN PUBLIC KEY") != -1) {
                return this.readPublicKey("-----END PUBLIC KEY");
            }
            if (string.indexOf("-----BEGIN RSA PUBLIC KEY") != -1) {
                return this.readRSAPublicKey("-----END RSA PUBLIC KEY");
            }
            if (string.indexOf("-----BEGIN CERTIFICATE REQUEST") != -1) {
                return this.readCertificateRequest("-----END CERTIFICATE REQUEST");
            }
            if (string.indexOf("-----BEGIN NEW CERTIFICATE REQUEST") != -1) {
                return this.readCertificateRequest("-----END NEW CERTIFICATE REQUEST");
            }
            if (string.indexOf("-----BEGIN CERTIFICATE") != -1) {
                return this.readCertificate("-----END CERTIFICATE");
            }
            if (string.indexOf("-----BEGIN PKCS7") != -1) {
                return this.readPKCS7("-----END PKCS7");
            }
            if (string.indexOf("-----BEGIN X509 CERTIFICATE") != -1) {
                return this.readCertificate("-----END X509 CERTIFICATE");
            }
            if (string.indexOf("-----BEGIN X509 CRL") != -1) {
                return this.readCRL("-----END X509 CRL");
            }
            if (string.indexOf("-----BEGIN ATTRIBUTE CERTIFICATE") != -1) {
                return this.readAttributeCertificate("-----END ATTRIBUTE CERTIFICATE");
            }
            if (string.indexOf("-----BEGIN RSA PRIVATE KEY") != -1) {
                try {
                    return this.readKeyPair("RSA", "-----END RSA PRIVATE KEY");
                }
                catch (Exception exception) {
                    throw new IOException("problem creating RSA private key: " + exception.toString());
                }
            }
            if (string.indexOf("-----BEGIN DSA PRIVATE KEY") != -1) {
                try {
                    return this.readKeyPair("DSA", "-----END DSA PRIVATE KEY");
                }
                catch (Exception exception) {
                    throw new IOException("problem creating DSA private key: " + exception.toString());
                }
            }
            if (string.indexOf("-----BEGIN EC PARAMETERS-----") != -1) {
                return this.readECParameters("-----END EC PARAMETERS-----");
            }
            if (string.indexOf("-----BEGIN EC PRIVATE KEY-----") == -1) continue;
            return this.readECPrivateKey("-----END EC PRIVATE KEY-----");
        }
        return null;
    }

    private byte[] readBytes(String string) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = this.readLine()) != null && string2.indexOf(string) == -1) {
            stringBuffer.append(string2.trim());
        }
        if (string2 == null) {
            throw new IOException(string + " not found");
        }
        return Base64.decode(stringBuffer.toString());
    }

    private PublicKey readRSAPublicKey(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readBytes(string));
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        DERObject dERObject = aSN1InputStream.readObject();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)dERObject;
        RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(aSN1Sequence);
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKeyStructure.getModulus(), rSAPublicKeyStructure.getPublicExponent());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", this.provider);
            return keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new IOException("can't find provider " + this.provider);
        }
        catch (Exception exception) {
            throw new IOException("problem extracting key: " + exception.toString());
        }
    }

    private PublicKey readPublicKey(String string) throws IOException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(this.readBytes(string));
        String[] stringArray = new String[]{"DSA", "RSA"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(stringArray[i], this.provider);
                PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                return publicKey;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                continue;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException("can't find provider " + this.provider);
            }
        }
        return null;
    }

    private X509Certificate readCertificate(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readBytes(string));
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", this.provider);
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new IOException("problem parsing cert: " + exception.toString());
        }
    }

    private X509CRL readCRL(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.readBytes(string));
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", this.provider);
            return (X509CRL)certificateFactory.generateCRL(byteArrayInputStream);
        }
        catch (Exception exception) {
            throw new IOException("problem parsing cert: " + exception.toString());
        }
    }

    private PKCS10CertificationRequest readCertificateRequest(String string) throws IOException {
        try {
            return new PKCS10CertificationRequest(this.readBytes(string));
        }
        catch (Exception exception) {
            throw new IOException("problem parsing cert: " + exception.toString());
        }
    }

    private X509AttributeCertificate readAttributeCertificate(String string) throws IOException {
        return new X509V2AttributeCertificate(this.readBytes(string));
    }

    private ContentInfo readPKCS7(String string) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((string2 = this.readLine()) != null && string2.indexOf(string) == -1) {
            string2 = string2.trim();
            stringBuffer.append(string2.trim());
            Base64.decode(stringBuffer.substring(0, stringBuffer.length() / 4 * 4), byteArrayOutputStream);
            stringBuffer.delete(0, stringBuffer.length() / 4 * 4);
        }
        if (stringBuffer.length() != 0) {
            throw new RuntimeException("base64 data appears to be truncated");
        }
        if (string2 == null) {
            throw new IOException(string + " not found");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            return ContentInfo.getInstance(aSN1InputStream.readObject());
        }
        catch (Exception exception) {
            throw new IOException("problem parsing PKCS7 object: " + exception.toString());
        }
    }

    private SecretKey getKey(String string, int n, byte[] byArray) throws IOException {
        if (this.pFinder == null) {
            throw new IOException("No password finder specified, but a password is required");
        }
        char[] cArray = this.pFinder.getPassword();
        if (cArray == null) {
            throw new IOException("Password is null, but a password is required");
        }
        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
        openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray);
        return new SecretKeySpec(((KeyParameter)openSSLPBEParametersGenerator.generateDerivedParameters(n * 8)).getKey(), string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyPair readKeyPair(String string, String string2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string3 = this.readLine()) != null) {
            if (string3.startsWith("Proc-Type: 4,ENCRYPTED")) {
                bl = true;
                continue;
            }
            if (string3.startsWith("DEK-Info:")) {
                string4 = string3.substring(10);
                continue;
            }
            if (string3.indexOf(string2) != -1) break;
            stringBuffer.append(string3.trim());
        }
        byte[] byArray = null;
        if (bl) {
            object6 = new StringTokenizer(string4, ",");
            object5 = ((StringTokenizer)object6).nextToken();
            if (((String)object5).equals("DES-EDE3-CBC")) {
                object4 = "DESede";
                object3 = Hex.decode(((StringTokenizer)object6).nextToken());
                object2 = this.getKey((String)object4, 24, (byte[])object3);
                object = Cipher.getInstance("DESede/CBC/PKCS5Padding", this.provider);
                ((Cipher)object).init(2, (Key)object2, new IvParameterSpec((byte[])object3));
                byArray = ((Cipher)object).doFinal(Base64.decode(stringBuffer.toString()));
            } else {
                if (!((String)object5).equals("DES-CBC")) throw new IOException("unknown encryption with private key");
                object4 = "DES";
                object3 = Hex.decode(((StringTokenizer)object6).nextToken());
                object2 = this.getKey((String)object4, 8, (byte[])object3);
                object = Cipher.getInstance("DES/CBC/PKCS5Padding", this.provider);
                ((Cipher)object).init(2, (Key)object2, new IvParameterSpec((byte[])object3));
                byArray = ((Cipher)object).doFinal(Base64.decode(stringBuffer.toString()));
            }
        } else {
            byArray = Base64.decode(stringBuffer.toString());
        }
        object4 = new ByteArrayInputStream(byArray);
        object3 = new ASN1InputStream((InputStream)object4);
        object2 = (ASN1Sequence)((ASN1InputStream)object3).readObject();
        if (string.equals("RSA")) {
            object = (DERInteger)((ASN1Sequence)object2).getObjectAt(0);
            DERInteger dERInteger = (DERInteger)((ASN1Sequence)object2).getObjectAt(1);
            DERInteger dERInteger2 = (DERInteger)((ASN1Sequence)object2).getObjectAt(2);
            DERInteger dERInteger3 = (DERInteger)((ASN1Sequence)object2).getObjectAt(3);
            DERInteger dERInteger4 = (DERInteger)((ASN1Sequence)object2).getObjectAt(4);
            DERInteger dERInteger5 = (DERInteger)((ASN1Sequence)object2).getObjectAt(5);
            DERInteger dERInteger6 = (DERInteger)((ASN1Sequence)object2).getObjectAt(6);
            DERInteger dERInteger7 = (DERInteger)((ASN1Sequence)object2).getObjectAt(7);
            DERInteger dERInteger8 = (DERInteger)((ASN1Sequence)object2).getObjectAt(8);
            object6 = new RSAPublicKeySpec(dERInteger.getValue(), dERInteger2.getValue());
            object5 = new RSAPrivateCrtKeySpec(dERInteger.getValue(), dERInteger2.getValue(), dERInteger3.getValue(), dERInteger4.getValue(), dERInteger5.getValue(), dERInteger6.getValue(), dERInteger7.getValue(), dERInteger8.getValue());
        } else {
            object = (DERInteger)((ASN1Sequence)object2).getObjectAt(0);
            DERInteger dERInteger = (DERInteger)((ASN1Sequence)object2).getObjectAt(1);
            DERInteger dERInteger9 = (DERInteger)((ASN1Sequence)object2).getObjectAt(2);
            DERInteger dERInteger10 = (DERInteger)((ASN1Sequence)object2).getObjectAt(3);
            DERInteger dERInteger11 = (DERInteger)((ASN1Sequence)object2).getObjectAt(4);
            DERInteger dERInteger12 = (DERInteger)((ASN1Sequence)object2).getObjectAt(5);
            object5 = new DSAPrivateKeySpec(dERInteger12.getValue(), dERInteger.getValue(), dERInteger9.getValue(), dERInteger10.getValue());
            object6 = new DSAPublicKeySpec(dERInteger11.getValue(), dERInteger.getValue(), dERInteger9.getValue(), dERInteger10.getValue());
        }
        object = KeyFactory.getInstance(string, this.provider);
        return new KeyPair(((KeyFactory)object).generatePublic((KeySpec)object6), ((KeyFactory)object).generatePrivate((KeySpec)object5));
    }

    private ECNamedCurveParameterSpec readECParameters(String string) throws IOException {
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)ASN1Object.fromByteArray(this.readBytes(string));
        return ECNamedCurveTable.getParameterSpec(dERObjectIdentifier.getId());
    }

    private KeyPair readECPrivateKey(String string) throws IOException {
        try {
            ECPrivateKeyStructure eCPrivateKeyStructure = new ECPrivateKeyStructure((ASN1Sequence)ASN1Object.fromByteArray(this.readBytes(string)));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, eCPrivateKeyStructure.getParameters());
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, eCPrivateKeyStructure.getDERObject());
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, eCPrivateKeyStructure.getPublicKey().getBytes());
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("EC", this.provider);
            return new KeyPair(keyFactory.generatePublic(x509EncodedKeySpec), keyFactory.generatePrivate(pKCS8EncodedKeySpec));
        }
        catch (ClassCastException classCastException) {
            throw new IOException("wrong ASN.1 object found in stream");
        }
        catch (Exception exception) {
            throw new IOException("problem parsing EC private key: " + exception);
        }
    }
}

