/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.ApplicationException;
import ca.uhn.hl7v2.app.ApplicationExceptionHandler;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MessageTypeRouter
implements Application,
ApplicationExceptionHandler {
    private static final HapiLog log = HapiLogFactory.getHapiLog(MessageTypeRouter.class);
    private HashMap apps = new HashMap(20);

    public boolean canProcess(Message in) {
        boolean can = false;
        try {
            Application matches = this.getMatchingApplication(in);
            if (matches != null) {
                can = true;
            }
        }
        catch (HL7Exception e) {
            can = false;
        }
        return can;
    }

    public Message processMessage(Message in) throws ApplicationException {
        Message out;
        try {
            Application matchingApp = this.getMatchingApplication(in);
            out = matchingApp.processMessage(in);
        }
        catch (HL7Exception e) {
            throw new ApplicationException("Error internally routing message: " + e.toString(), e);
        }
        return out;
    }

    public String processException(String incomingMessage, String outgoingMessage, Exception e) throws HL7Exception {
        String outgoingMessageResult = outgoingMessage;
        Set entrySet = this.apps.entrySet();
        for (Map.Entry entry : entrySet) {
            Object app = entry.getValue();
            if (!(app instanceof ApplicationExceptionHandler)) continue;
            ApplicationExceptionHandler aeh = (ApplicationExceptionHandler)app;
            outgoingMessageResult = aeh.processException(incomingMessage, outgoingMessageResult, e);
        }
        return outgoingMessageResult;
    }

    public synchronized void registerApplication(String messageType, String triggerEvent, Application handler) {
        this.apps.put(this.getKey(messageType, triggerEvent), handler);
        StringBuffer buf = new StringBuffer();
        buf.append(handler.getClass().getName());
        buf.append(" registered to handle ");
        buf.append(messageType);
        buf.append("^");
        buf.append(triggerEvent);
        buf.append(" messages");
        log.info(buf.toString());
    }

    private Application getMatchingApplication(Message message) throws HL7Exception {
        Terser t = new Terser(message);
        String messageType = t.get("/MSH-9-1");
        String triggerEvent = t.get("/MSH-9-2");
        return this.getMatchingApplication(messageType, triggerEvent);
    }

    private synchronized Application getMatchingApplication(String messageType, String triggerEvent) {
        Application matchingApp = null;
        Object o = this.apps.get(this.getKey(messageType, triggerEvent));
        if (o == null) {
            o = this.apps.get(this.getKey(messageType, "*"));
        }
        if (o == null) {
            o = this.apps.get(this.getKey("*", triggerEvent));
        }
        if (o == null) {
            o = this.apps.get(this.getKey("*", "*"));
        }
        if (o != null) {
            matchingApp = (Application)o;
        }
        return matchingApp;
    }

    private String getKey(String messageType, String triggerEvent) {
        return String.valueOf(messageType) + "|" + triggerEvent;
    }
}

